/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.spark.impl.acceptance;

import org.junit.runner.RunWith;
import org.opencypher.okapi.api.graph.CypherResult;
import org.opencypher.okapi.api.graph.PropertyGraph;
import org.opencypher.okapi.api.schema.PropertyKeys$;
import org.opencypher.okapi.api.schema.Schema$;
import org.opencypher.okapi.api.table.CypherRecords;
import org.opencypher.okapi.api.types.CTInteger$;
import org.opencypher.okapi.api.types.CTNode;
import org.opencypher.okapi.api.types.CTRelationship;
import org.opencypher.okapi.api.types.CTString$;
import org.opencypher.okapi.api.value.CypherValue;
import org.opencypher.okapi.relational.api.graph.RelationalCypherGraph;
import org.opencypher.okapi.relational.api.planning.RelationalCypherResult;
import org.opencypher.okapi.relational.api.table.Table;
import org.opencypher.okapi.relational.impl.graph.UnionGraph;
import org.opencypher.okapi.relational.impl.operators.RelationalOperator;
import org.opencypher.okapi.relational.impl.operators.SwitchContext;
import org.opencypher.okapi.testing.Bag$;
import org.opencypher.spark.api.CAPSSession;
import org.opencypher.spark.api.value.CAPSEntity;
import org.opencypher.spark.api.value.CAPSEntity$;
import org.opencypher.spark.api.value.CAPSNode;
import org.opencypher.spark.api.value.CAPSNode$;
import org.opencypher.spark.api.value.CAPSRelationship;
import org.opencypher.spark.api.value.CAPSRelationship$;
import org.opencypher.spark.impl.CAPSConverters;
import org.opencypher.spark.impl.CAPSConverters$;
import org.opencypher.spark.impl.acceptance.MultipleGraphTests$;
import org.opencypher.spark.impl.acceptance.ScanGraphInit;
import org.opencypher.spark.impl.acceptance.ScanGraphInit$class;
import org.opencypher.spark.impl.table.SparkTable;
import org.opencypher.spark.schema.CAPSSchema$;
import org.opencypher.spark.testing.CAPSTestSuite;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.enablers.Emptiness$;
import org.scalatest.junit.JUnitRunner;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@RunWith(value=JUnitRunner.class)
@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001\u001b\t\u0011R*\u001e7uSBdWm\u0012:ba\"$Vm\u001d;t\u0015\t\u0019A!\u0001\u0006bG\u000e,\u0007\u000f^1oG\u0016T!!\u0002\u0004\u0002\t%l\u0007\u000f\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\u0015=\u0004XM\\2za\",'OC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0003#\u0019\tq\u0001^3ti&tw-\u0003\u0002\u0014!\ti1)\u0011)T)\u0016\u001cHoU;ji\u0016\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003\u001bM\u001b\u0017M\\$sCBD\u0017J\\5u\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u0016\u0001!)Q\u0004\u0001C\u0001=\u0005QA/Z:u\u000fJ\f\u0007\u000f[\u0019\u0016\u0003}\u00012\u0001I\u0015,\u001b\u0005\t#B\u0001\u0012$\u0003\u00159'/\u00199i\u0015\t!S%A\u0002ba&T!AJ\u0014\u0002\u0015I,G.\u0019;j_:\fGN\u0003\u0002)\u0011\u0005)qn[1qS&\u0011!&\t\u0002\u0016%\u0016d\u0017\r^5p]\u0006d7)\u001f9iKJ<%/\u00199i!\ta#G\u0004\u0002.a5\taF\u0003\u00020\t\u0005)A/\u00192mK&\u0011\u0011GL\u0001\u000b'B\f'o\u001b+bE2,\u0017BA\u001a5\u00059!\u0015\r^1Ge\u0006lW\rV1cY\u0016T!!\r\u0018\t\u000bY\u0002A\u0011\u0001\u0010\u0002\u0015Q,7\u000f^$sCBD'\u0007C\u00039\u0001\u0011\u0005a$\u0001\u0006uKN$xI]1qQNBQA\u000f\u0001\u0005\u0002y\tQ\u0002^3ti\u001e\u0013\u0018\r\u001d5SK2\u001c\b\u0006\u0002\u0001=\t\u0016\u0003\"!\u0010\"\u000e\u0003yR!a\u0010!\u0002\rI,hN\\3s\u0015\t\t%\"A\u0003kk:LG/\u0003\u0002D}\t9!+\u001e8XSRD\u0017!\u0002<bYV,7%\u0001$\u0011\u0005\u001d[U\"\u0001%\u000b\u0005\u0005K%B\u0001&\u000b\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002M\u0011\nY!*\u00168jiJ+hN\\3s\u0001")
public class MultipleGraphTests
extends CAPSTestSuite
implements ScanGraphInit {
    @Override
    public RelationalCypherGraph<SparkTable.DataFrameTable> initGraph(String createQuery, CAPSSession caps) {
        return ScanGraphInit$class.initGraph(this, createQuery, caps);
    }

    public RelationalCypherGraph<SparkTable.DataFrameTable> testGraph1() {
        return this.initGraph("CREATE (:Person {name: 'Mats'})", this.caps());
    }

    public RelationalCypherGraph<SparkTable.DataFrameTable> testGraph2() {
        return this.initGraph("CREATE (:Person {name: 'Phil'})", this.caps());
    }

    public RelationalCypherGraph<SparkTable.DataFrameTable> testGraph3() {
        return this.initGraph("CREATE (:Car {type: 'Toyota'})", this.caps());
    }

    public RelationalCypherGraph<SparkTable.DataFrameTable> testGraphRels() {
        return this.initGraph(new StringOps(Predef$.MODULE$.augmentString("|CREATE (mats:Person {name: 'Mats'})\n       |CREATE (max:Person {name: 'Max'})\n       |CREATE (max)-[:HAS_SIMILAR_NAME]->(mats)\n    ")).stripMargin(), this.caps());
    }

    public MultipleGraphTests() {
        ScanGraphInit$class.$init$(this);
        this.it().apply("creates multiple copies of the same node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                RelationalCypherGraph g = (RelationalCypherGraph)this.$outer.caps().cypher(new StringOps(Predef$.MODULE$.augmentString("\n        |CONSTRUCT\n        |  CREATE ()\n        |RETURN GRAPH\n      ")).stripMargin(), this.$outer.caps().cypher$default$2(), this.$outer.caps().cypher$default$3(), this.$outer.caps().cypher$default$4()).graph();
                CypherRecords results = g.cypher(new StringOps(Predef$.MODULE$.augmentString("\n        |MATCH (a)\n        |CONSTRUCT\n        |  CREATE (f COPY OF a)-[:FOO]->(g COPY OF a)\n        |MATCH (n)\n        |RETURN n\n      ")).stripMargin(), g.cypher$default$2(), g.cypher$default$3(), g.cypher$default$4()).records();
                return this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)results.size()), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)2));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
        this.it().apply("can match on constructed graph", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                CypherRecords results = this.$outer.caps().cypher(new StringOps(Predef$.MODULE$.augmentString("\n        |CONSTRUCT\n        |  CREATE ()\n        |MATCH (a)\n        |CONSTRUCT\n        |  CREATE (f COPY OF a)-[:FOO]->(g COPY OF a)\n        |MATCH (n)\n        |RETURN n\n      ")).stripMargin(), this.$outer.caps().cypher$default$2(), this.$outer.caps().cypher$default$3(), this.$outer.caps().cypher$default$4()).records();
                return this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)results.size()), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)2));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        this.it().apply("CLONEs with an alias", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                String query = new StringOps(Predef$.MODULE$.augmentString("\n        |MATCH (n)\n        |CONSTRUCT\n        |  CLONE n AS m\n        |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$1 = this.$outer.testGraph1();
                String x$1 = query;
                Map x$2 = qual$1.cypher$default$2();
                Option x$3 = qual$1.cypher$default$3();
                Map x$4 = qual$1.cypher$default$4();
                CypherResult result = qual$1.cypher(x$1, x$2, x$3, x$4);
                return this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107), Prettifier$.MODULE$.default()).should(this.$outer.be().apply((Object)None$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        this.it().apply("should return a graph", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String query = new StringOps(Predef$.MODULE$.augmentString("RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$2 = this.$outer.testGraph1();
                String x$5 = query;
                Map x$6 = qual$2.cypher$default$2();
                Option x$7 = qual$2.cypher$default$3();
                Map x$8 = qual$2.cypher$default$4();
                CypherResult result = qual$2.cypher(x$5, x$6, x$7, x$8);
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115), Prettifier$.MODULE$.default()).should(this.$outer.be().apply((Object)None$.MODULE$));
                this.$outer.GraphMatcher(CAPSConverters.RichPropertyGraph$.MODULE$.asCaps$extension(CAPSConverters$.MODULE$.RichPropertyGraph(result.graph()))).shouldMatch(this.$outer.testGraph1());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        this.it().apply("should switch to another graph and then return it", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.caps().catalog().store("graph2", this.$outer.testGraph2());
                String query = new StringOps(Predef$.MODULE$.augmentString("FROM GRAPH graph2\n        |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$3 = this.$outer.testGraph1();
                String x$9 = query;
                Map x$10 = qual$3.cypher$default$2();
                Option x$11 = qual$3.cypher$default$3();
                Map x$12 = qual$3.cypher$default$4();
                CypherResult result = qual$3.cypher(x$9, x$10, x$11, x$12);
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127), Prettifier$.MODULE$.default()).shouldBe((Object)None$.MODULE$);
                this.$outer.GraphMatcher(CAPSConverters.RichPropertyGraph$.MODULE$.asCaps$extension(CAPSConverters$.MODULE$.RichPropertyGraph(result.graph()))).shouldMatch(this.$outer.testGraph2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.it().apply("can select a source graph to match data from", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                this.$outer.caps().catalog().store("graph1", this.$outer.testGraph1());
                this.$outer.caps().catalog().store("graph2", this.$outer.testGraph2());
                String query = new StringOps(Predef$.MODULE$.augmentString("FROM GRAPH graph2\n        |MATCH (n:Person)\n        |RETURN n.name AS name")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$4 = this.$outer.testGraph1();
                String x$13 = query;
                Map x$14 = qual$4.cypher$default$2();
                Option x$15 = qual$4.cypher$default$3();
                Map x$16 = qual$4.cypher$default$4();
                CypherResult result = qual$4.cypher(x$13, x$14, x$15, x$16);
                return this.$outer.convertToAnyShouldWrapper(this.$outer.RichRecords(result.records()).toMaps(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Phil")})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        this.it().apply("matches from different graphs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                this.$outer.caps().catalog().store("graph1", this.$outer.testGraph1());
                this.$outer.caps().catalog().store("graph2", this.$outer.testGraph2());
                this.$outer.caps().catalog().store("graph3", this.$outer.testGraph3());
                String query = new StringOps(Predef$.MODULE$.augmentString("FROM GRAPH graph2\n        |MATCH (n:Person)\n        |WITH n.name AS name\n        |FROM GRAPH graph3\n        |MATCH (c:Car)\n        |RETURN name, c.type AS car")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$5 = this.$outer.testGraph1();
                String x$17 = query;
                Map x$18 = qual$5.cypher$default$2();
                Option x$19 = qual$5.cypher$default$3();
                Map x$20 = qual$5.cypher$default$4();
                CypherResult result = qual$5.cypher(x$17, x$18, x$19, x$20);
                return this.$outer.convertToAnyShouldWrapper(this.$outer.RichRecords(result.records()).toMaps(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Phil"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"car"), (Object)"Toyota")})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        this.it().apply("constructs from different graphs with multiple distinct nodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                RelationalCypherGraph<SparkTable.DataFrameTable> g1 = this.$outer.initGraph(new StringOps(Predef$.MODULE$.augmentString("|CREATE (:A {v: 1})\n         |CREATE (:B {v: 100})")).stripMargin(), this.$outer.caps());
                RelationalCypherGraph<SparkTable.DataFrameTable> g2 = this.$outer.initGraph(new StringOps(Predef$.MODULE$.augmentString("|CREATE (:A {v: 2})\n         |CREATE (:B {v: 200})")).stripMargin(), this.$outer.caps());
                this.$outer.caps().catalog().store("g1", g1);
                this.$outer.caps().catalog().store("g2", g2);
                String query = new StringOps(Predef$.MODULE$.augmentString("|FROM GRAPH g1\n         |MATCH (n)\n         |FROM GRAPH g2\n         |MATCH (m)\n         |CONSTRUCT\n         |  CREATE (n)\n         |  CREATE (m)\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$6 = this.$outer.testGraph1();
                String x$21 = query;
                Map x$22 = qual$6.cypher$default$2();
                Option x$23 = qual$6.cypher$default$3();
                Map x$24 = qual$6.cypher$default$4();
                CypherResult result = qual$6.cypher(x$21, x$22, x$23, x$24);
                PropertyGraph qual$7 = result.graph();
                String x$25 = "n";
                CTNode x$26 = qual$7.nodes$default$2();
                boolean x$27 = qual$7.nodes$default$3();
                return this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)qual$7.nodes(x$25, x$26, x$27).size()), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)4));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
        this.it().apply("should construct a graph", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                String query = new StringOps(Predef$.MODULE$.augmentString("|CONSTRUCT\n         |  CREATE (:A)-[:KNOWS]->(:B)\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$8 = this.$outer.testGraph1();
                String x$28 = query;
                Map x$29 = qual$8.cypher$default$2();
                Option x$30 = qual$8.cypher$default$3();
                Map x$31 = qual$8.cypher$default$4();
                CypherResult result = qual$8.cypher(x$28, x$29, x$30, x$31);
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202), Prettifier$.MODULE$.default()).should(this.$outer.be().apply((Object)None$.MODULE$));
                this.$outer.convertToAnyShouldWrapper(result.graph().schema().labels(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B"}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result.graph().schema().relationshipTypes(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"}))), (Object)Equality$.MODULE$.default());
                PropertyGraph qual$9 = result.graph();
                String x$32 = "n";
                CTNode x$33 = qual$9.nodes$default$2();
                boolean x$34 = qual$9.nodes$default$3();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)qual$9.nodes(x$32, x$33, x$34).size()), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205), Prettifier$.MODULE$.default()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)2)), (Object)Equality$.MODULE$.default());
                PropertyGraph qual$10 = result.graph();
                String x$35 = "r";
                CTRelationship x$36 = qual$10.relationships$default$2();
                return this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)qual$10.relationships(x$35, x$36).size()), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206), Prettifier$.MODULE$.default()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        this.it().apply("should CONSTRUCT a graph with multiple connected CREATE clauses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                String query = new StringOps(Predef$.MODULE$.augmentString("|CONSTRUCT\n         |  CREATE (a:A)-[:KNOWS]->(b:B)\n         |  CREATE (b)-[:KNOWS]->(c:C)\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$11 = this.$outer.testGraph1();
                String x$37 = query;
                Map x$38 = qual$11.cypher$default$2();
                Option x$39 = qual$11.cypher$default$3();
                Map x$40 = qual$11.cypher$default$4();
                CypherResult result = qual$11.cypher(x$37, x$38, x$39, x$40);
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218), Prettifier$.MODULE$.default()).should(this.$outer.be().apply((Object)None$.MODULE$));
                this.$outer.convertToAnyShouldWrapper(result.graph().schema().labels(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B", "C"}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result.graph().schema().relationshipTypes(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"}))), (Object)Equality$.MODULE$.default());
                PropertyGraph qual$12 = result.graph();
                String x$41 = "n";
                CTNode x$42 = qual$12.nodes$default$2();
                boolean x$43 = qual$12.nodes$default$3();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)qual$12.nodes(x$41, x$42, x$43).size()), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221), Prettifier$.MODULE$.default()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)3)), (Object)Equality$.MODULE$.default());
                PropertyGraph qual$13 = result.graph();
                String x$44 = "r";
                CTRelationship x$45 = qual$13.relationships$default$2();
                return this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)qual$13.relationships(x$44, x$45).size()), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222), Prettifier$.MODULE$.default()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)2)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
        this.it().apply("should CONSTRUCT a graph with multiple unconnected CREATE clauses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                String query = new StringOps(Predef$.MODULE$.augmentString("|CONSTRUCT\n         |  CREATE (a:A)-[:KNOWS]->(b:B)\n         |  CREATE (c:C)-[:KNOWS]->(d:D)\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$14 = this.$outer.testGraph1();
                String x$46 = query;
                Map x$47 = qual$14.cypher$default$2();
                Option x$48 = qual$14.cypher$default$3();
                Map x$49 = qual$14.cypher$default$4();
                CypherResult result = qual$14.cypher(x$46, x$47, x$48, x$49);
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234), Prettifier$.MODULE$.default()).shouldBe((Object)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(result.graph().schema().labels(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B", "C", "D"}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result.graph().schema().relationshipTypes(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"}))), (Object)Equality$.MODULE$.default());
                PropertyGraph qual$15 = result.graph();
                String x$50 = "n";
                CTNode x$51 = qual$15.nodes$default$2();
                boolean x$52 = qual$15.nodes$default$3();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)qual$15.nodes(x$50, x$51, x$52).size()), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237), Prettifier$.MODULE$.default()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)4)), (Object)Equality$.MODULE$.default());
                PropertyGraph qual$16 = result.graph();
                String x$53 = "r";
                CTRelationship x$54 = qual$16.relationships$default$2();
                return this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)qual$16.relationships(x$53, x$54).size()), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238), Prettifier$.MODULE$.default()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)2)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
        this.it().apply("should CONSTRUCT a graph with multiple unconnected anonymous CREATE clauses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                String query = new StringOps(Predef$.MODULE$.augmentString("|CONSTRUCT\n         |  CREATE (:A)\n         |  CREATE (:B)\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$17 = this.$outer.testGraph1();
                String x$55 = query;
                Map x$56 = qual$17.cypher$default$2();
                Option x$57 = qual$17.cypher$default$3();
                Map x$58 = qual$17.cypher$default$4();
                CypherResult result = qual$17.cypher(x$55, x$56, x$57, x$58);
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250), Prettifier$.MODULE$.default()).shouldBe((Object)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(result.graph().schema().labels(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B"}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result.graph().schema().relationshipTypes(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().empty()), (Object)Equality$.MODULE$.default());
                PropertyGraph qual$18 = result.graph();
                String x$59 = "n";
                CTNode x$60 = qual$18.nodes$default$2();
                boolean x$61 = qual$18.nodes$default$3();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)qual$18.nodes(x$59, x$60, x$61).size()), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254), Prettifier$.MODULE$.default()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)2)), (Object)Equality$.MODULE$.default());
                PropertyGraph qual$19 = result.graph();
                String x$62 = "r";
                CTRelationship x$63 = qual$19.relationships$default$2();
                return this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)qual$19.relationships(x$62, x$63).size()), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255), Prettifier$.MODULE$.default()).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)0)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        this.it().apply("should construct a node property from a matched node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                String query = new StringOps(Predef$.MODULE$.augmentString("|MATCH (m)\n         |CONSTRUCT\n         |  CREATE (a :A { name: m.name})\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$20 = this.$outer.testGraph1();
                String x$64 = query;
                Map x$65 = qual$20.cypher$default$2();
                Option x$66 = qual$20.cypher$default$3();
                Map x$67 = qual$20.cypher$default$4();
                CypherResult result = qual$20.cypher(x$64, x$65, x$66, x$67);
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267), Prettifier$.MODULE$.default()).shouldBe((Object)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(result.graph().schema().labels(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result.graph().schema(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269), Prettifier$.MODULE$.default()).should(this.$outer.equal(Schema$.MODULE$.empty().withNodePropertyKeys((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)CTString$.MODULE$)}))), (Object)Equality$.MODULE$.default());
                PropertyGraph qual$21 = result.graph();
                String x$68 = "MATCH (a:A) RETURN a.name";
                Map x$69 = qual$21.cypher$default$2();
                Option x$70 = qual$21.cypher$default$3();
                Map x$71 = qual$21.cypher$default$4();
                return this.$outer.convertToAnyShouldWrapper(Bag$.MODULE$.IteratorToBag(qual$21.cypher(x$68, x$69, x$70, x$71).records().iterator()).toBag(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a.name"), (Object)"Mats")})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
        this.it().apply("should construct a node property from a literal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                String query = new StringOps(Predef$.MODULE$.augmentString("|CONSTRUCT\n         |  CREATE ({name: 'Donald'})\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherResult result = this.$outer.caps().cypher(query, this.$outer.caps().cypher$default$2(), this.$outer.caps().cypher$default$3(), this.$outer.caps().cypher$default$4());
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283), Prettifier$.MODULE$.default()).shouldBe((Object)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(result.graph().schema(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284), Prettifier$.MODULE$.default()).should(this.$outer.equal(Schema$.MODULE$.empty().withNodePropertyKeys((Seq)Nil$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)CTString$.MODULE$)}))), (Object)Equality$.MODULE$.default());
                RelationalCypherGraph qual$22 = (RelationalCypherGraph)result.graph();
                String x$72 = "MATCH (a) RETURN a.name";
                Map x$73 = qual$22.cypher$default$2();
                Option x$74 = qual$22.cypher$default$3();
                Map x$75 = qual$22.cypher$default$4();
                return this.$outer.convertToAnyShouldWrapper(Bag$.MODULE$.IteratorToBag(qual$22.cypher(x$72, x$73, x$74, x$75).records().iterator()).toBag(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a.name"), (Object)"Donald")})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275));
        this.it().apply("should construct a node label and a node property from a literal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                String query = new StringOps(Predef$.MODULE$.augmentString("|CONSTRUCT\n         |  CREATE (a :A {name: 'Donald'})\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$23 = this.$outer.testGraph1();
                String x$76 = query;
                Map x$77 = qual$23.cypher$default$2();
                Option x$78 = qual$23.cypher$default$3();
                Map x$79 = qual$23.cypher$default$4();
                CypherResult result = qual$23.cypher(x$76, x$77, x$78, x$79);
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298), Prettifier$.MODULE$.default()).shouldBe((Object)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(result.graph().schema().labels(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result.graph().schema(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300), Prettifier$.MODULE$.default()).should(this.$outer.equal(Schema$.MODULE$.empty().withNodePropertyKeys((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)CTString$.MODULE$)}))), (Object)Equality$.MODULE$.default());
                PropertyGraph qual$24 = result.graph();
                String x$80 = "MATCH (a:A) RETURN a.name";
                Map x$81 = qual$24.cypher$default$2();
                Option x$82 = qual$24.cypher$default$3();
                Map x$83 = qual$24.cypher$default$4();
                return this.$outer.convertToAnyShouldWrapper(Bag$.MODULE$.IteratorToBag(qual$24.cypher(x$80, x$81, x$82, x$83).records().iterator()).toBag(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a.name"), (Object)"Donald")})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
        this.it().apply("should construct multiple properties", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                String query = new StringOps(Predef$.MODULE$.augmentString("|CONSTRUCT\n         |  CREATE (a:A:B {name:'Donald', age:100})\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$25 = this.$outer.testGraph1();
                String x$84 = query;
                Map x$85 = qual$25.cypher$default$2();
                Option x$86 = qual$25.cypher$default$3();
                Map x$87 = qual$25.cypher$default$4();
                CypherResult result = qual$25.cypher(x$84, x$85, x$86, x$87);
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314), Prettifier$.MODULE$.default()).shouldBe((Object)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(result.graph().schema().labels(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B"}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result.graph().schema(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316), Prettifier$.MODULE$.default()).should(this.$outer.equal(Schema$.MODULE$.empty().withNodePropertyKeys((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B"})), PropertyKeys$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)CTString$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"age"), (Object)CTInteger$.MODULE$)})))), (Object)Equality$.MODULE$.default());
                PropertyGraph qual$26 = result.graph();
                String x$88 = "MATCH (a:A:B) RETURN a.name";
                Map x$89 = qual$26.cypher$default$2();
                Option x$90 = qual$26.cypher$default$3();
                Map x$91 = qual$26.cypher$default$4();
                return this.$outer.convertToAnyShouldWrapper(Bag$.MODULE$.IteratorToBag(qual$26.cypher(x$88, x$89, x$90, x$91).records().iterator()).toBag(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a.name"), (Object)"Donald")})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        this.it().apply("should pick up labels of the outer match", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                String query = new StringOps(Predef$.MODULE$.augmentString("|MATCH (m:Person)\n         |CONSTRUCT\n         |  CLONE m AS m\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$27 = this.$outer.testGraph1();
                String x$92 = query;
                Map x$93 = qual$27.cypher$default$2();
                Option x$94 = qual$27.cypher$default$3();
                Map x$95 = qual$27.cypher$default$4();
                CypherResult result = qual$27.cypher(x$92, x$93, x$94, x$95);
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334), Prettifier$.MODULE$.default()).shouldBe((Object)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(result.graph().schema().labels(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result.graph().schema(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336), Prettifier$.MODULE$.default()).should(this.$outer.equal(Schema$.MODULE$.empty().withNodePropertyKeys((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"})), PropertyKeys$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)CTString$.MODULE$)})))), (Object)Equality$.MODULE$.default());
                PropertyGraph qual$28 = result.graph();
                String x$96 = "MATCH (a:Person) RETURN a.name";
                Map x$97 = qual$28.cypher$default$2();
                Option x$98 = qual$28.cypher$default$3();
                Map x$99 = qual$28.cypher$default$4();
                return this.$outer.convertToAnyShouldWrapper(Bag$.MODULE$.IteratorToBag(qual$28.cypher(x$96, x$97, x$98, x$99).records().iterator()).toBag(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a.name"), (Object)"Mats")})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
        this.it().apply("should construct a relationship", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                String query = new StringOps(Predef$.MODULE$.augmentString("|CONSTRUCT\n         |  CREATE ()-[r:FOO {val : 42}]->()\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$29 = this.$outer.testGraph1();
                String x$100 = query;
                Map x$101 = qual$29.cypher$default$2();
                Option x$102 = qual$29.cypher$default$3();
                Map x$103 = qual$29.cypher$default$4();
                CypherResult result = qual$29.cypher(x$100, x$101, x$102, x$103);
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353), Prettifier$.MODULE$.default()).shouldBe((Object)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(result.graph().schema().relationshipTypes(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FOO"}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result.graph().schema(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 355), Prettifier$.MODULE$.default()).should(this.$outer.equal(Schema$.MODULE$.empty().withNodePropertyKeys((Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$).withRelationshipPropertyKeys("FOO", PropertyKeys$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"val"), (Object)CTInteger$.MODULE$)})))), (Object)Equality$.MODULE$.default());
                PropertyGraph qual$30 = result.graph();
                String x$104 = "MATCH ()-[r]->() RETURN r.val";
                Map x$105 = qual$30.cypher$default$2();
                Option x$106 = qual$30.cypher$default$3();
                Map x$107 = qual$30.cypher$default$4();
                return this.$outer.convertToAnyShouldWrapper(Bag$.MODULE$.IteratorToBag(qual$30.cypher(x$104, x$105, x$106, x$107).records().iterator()).toBag(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r.val"), (Object)BoxesRunTime.boxToInteger((int)42))})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 345));
        this.it().apply("should copy a relationship", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                String query = new StringOps(Predef$.MODULE$.augmentString("|CONSTRUCT\n         |  CREATE ()-[r:FOO {val : 42}]->()\n         |MATCH ()-[s]->()\n         |CONSTRUCT\n         |  CREATE ()-[t COPY OF s {name : 'Donald'}]->()\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$31 = this.$outer.testGraph1();
                String x$108 = query;
                Map x$109 = qual$31.cypher$default$2();
                Option x$110 = qual$31.cypher$default$3();
                Map x$111 = qual$31.cypher$default$4();
                CypherResult result = qual$31.cypher(x$108, x$109, x$110, x$111);
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374), Prettifier$.MODULE$.default()).shouldBe((Object)None$.MODULE$);
                PropertyGraph qual$32 = result.graph();
                String x$112 = "MATCH ()-[r]->() RETURN r.val, r.name, type(r) as type";
                Map x$113 = qual$32.cypher$default$2();
                Option x$114 = qual$32.cypher$default$3();
                Map x$115 = qual$32.cypher$default$4();
                return this.$outer.convertToAnyShouldWrapper(Bag$.MODULE$.IteratorToBag(qual$32.cypher(x$112, x$113, x$114, x$115).records().iterator()).toBag(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r.val"), (Object)BoxesRunTime.boxToInteger((int)42)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r.name"), (Object)"Donald"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"FOO")})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
        this.it().apply("should copy a mean relationship", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                RelationalCypherGraph<SparkTable.DataFrameTable> graph = this.$outer.initGraph(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE ()-[:FOO {val: 1, val2: 2}]->()\n        |CREATE ()-[:BAR {val: 1, val2: 3}]->()\n      ")).stripMargin(), this.$outer.caps());
                String query = new StringOps(Predef$.MODULE$.augmentString("MATCH ()-[s]->()\n        |CONSTRUCT\n        |  CREATE ()-[t COPY OF s :BAZ {val2 : 'Donald'}]->()\n        |RETURN GRAPH")).stripMargin();
                CypherResult result = graph.cypher(query, graph.cypher$default$2(), graph.cypher$default$3(), graph.cypher$default$4());
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395), Prettifier$.MODULE$.default()).shouldBe((Object)None$.MODULE$);
                PropertyGraph qual$33 = result.graph();
                String x$116 = "MATCH ()-[r]->() RETURN r.val, r.val2, type(r) as type";
                Map x$117 = qual$33.cypher$default$2();
                Option x$118 = qual$33.cypher$default$3();
                Map x$119 = qual$33.cypher$default$4();
                return this.$outer.convertToAnyShouldWrapper(Bag$.MODULE$.IteratorToBag(qual$33.cypher(x$116, x$117, x$118, x$119).records().iterator()).toBag(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r.val"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r.val2"), (Object)"Donald"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"BAZ")}))), new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r.val"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r.val2"), (Object)"Donald"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"BAZ")})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
        this.it().apply("should copy a node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                String query = new StringOps(Predef$.MODULE$.augmentString("|CONSTRUCT\n         |  CREATE (:Foo {foo: 'bar'})\n         |MATCH (a)\n         |CONSTRUCT\n         |  CREATE (COPY OF a)\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$34 = this.$outer.testGraph1();
                String x$120 = query;
                Map x$121 = qual$34.cypher$default$2();
                Option x$122 = qual$34.cypher$default$3();
                Map x$123 = qual$34.cypher$default$4();
                CypherResult result = qual$34.cypher(x$120, x$121, x$122, x$123);
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414), Prettifier$.MODULE$.default()).shouldBe((Object)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(result.graph().schema().labels(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Foo"}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result.graph().schema(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416), Prettifier$.MODULE$.default()).should(this.$outer.equal(Schema$.MODULE$.empty().withNodePropertyKeys((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Foo"}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)CTString$.MODULE$)}))), (Object)Equality$.MODULE$.default());
                PropertyGraph qual$35 = result.graph();
                String x$124 = "MATCH (a) RETURN a.foo, labels(a) as labels";
                Map x$125 = qual$35.cypher$default$2();
                Option x$126 = qual$35.cypher$default$3();
                Map x$127 = qual$35.cypher$default$4();
                return this.$outer.convertToAnyShouldWrapper(Bag$.MODULE$.IteratorToBag(qual$35.cypher(x$124, x$125, x$126, x$127).records().iterator()).toBag(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a.foo"), (Object)"bar"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labels"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Foo"})))})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403));
        this.it().apply("should copy a node with labels", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                RelationalCypherGraph<SparkTable.DataFrameTable> graph = this.$outer.initGraph(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE (:A {val: 1})\n        |CREATE (:B {val: 2})\n        |CREATE (:A:C {val: 3})\n      ")).stripMargin(), this.$outer.caps());
                String query = new StringOps(Predef$.MODULE$.augmentString("|MATCH (a)\n         |CONSTRUCT\n         |  CREATE (COPY OF a)\n         |RETURN GRAPH")).stripMargin();
                CypherResult result = graph.cypher(query, graph.cypher$default$2(), graph.cypher$default$3(), graph.cypher$default$4());
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441), Prettifier$.MODULE$.default()).shouldBe((Object)None$.MODULE$);
                PropertyGraph qual$36 = result.graph();
                String x$128 = "MATCH (a) RETURN a.val, labels(a) as labels";
                Map x$129 = qual$36.cypher$default$2();
                Option x$130 = qual$36.cypher$default$3();
                Map x$131 = qual$36.cypher$default$4();
                return this.$outer.convertToAnyShouldWrapper(Bag$.MODULE$.IteratorToBag(qual$36.cypher(x$128, x$129, x$130, x$131).records().iterator()).toBag(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a.val"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labels"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})))}))), new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a.val"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labels"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"})))}))), new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a.val"), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labels"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "C"})))})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 425));
        this.it().apply("can override in SET", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                RelationalCypherGraph<SparkTable.DataFrameTable> graph = this.$outer.initGraph(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE ({val: 1})\n      ")).stripMargin(), this.$outer.caps());
                String query = new StringOps(Predef$.MODULE$.augmentString("|MATCH (a)\n         |CONSTRUCT\n         |  CREATE (COPY OF a {val: 2})\n         |RETURN GRAPH")).stripMargin();
                CypherResult result = graph.cypher(query, graph.cypher$default$2(), graph.cypher$default$3(), graph.cypher$default$4());
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 463), Prettifier$.MODULE$.default()).shouldBe((Object)None$.MODULE$);
                PropertyGraph qual$37 = result.graph();
                String x$132 = "MATCH (a) RETURN a.val";
                Map x$133 = qual$37.cypher$default$2();
                Option x$134 = qual$37.cypher$default$3();
                Map x$135 = qual$37.cypher$default$4();
                return this.$outer.convertToAnyShouldWrapper(Bag$.MODULE$.IteratorToBag(qual$37.cypher(x$132, x$133, x$134, x$135).records().iterator()).toBag(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 464), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a.val"), (Object)BoxesRunTime.boxToInteger((int)2))})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
        this.it().apply("can override heterogeneous types in SET", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                RelationalCypherGraph<SparkTable.DataFrameTable> graph = this.$outer.initGraph(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE ({val: 1})\n      ")).stripMargin(), this.$outer.caps());
                String query = new StringOps(Predef$.MODULE$.augmentString("|MATCH (a)\n         |CONSTRUCT\n         |  CREATE (COPY OF a {val: 'foo'})\n         |RETURN GRAPH")).stripMargin();
                CypherResult result = graph.cypher(query, graph.cypher$default$2(), graph.cypher$default$3(), graph.cypher$default$4());
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483), Prettifier$.MODULE$.default()).shouldBe((Object)None$.MODULE$);
                PropertyGraph qual$38 = result.graph();
                String x$136 = "MATCH (a) RETURN a.val";
                Map x$137 = qual$38.cypher$default$2();
                Option x$138 = qual$38.cypher$default$3();
                Map x$139 = qual$38.cypher$default$4();
                return this.$outer.convertToAnyShouldWrapper(Bag$.MODULE$.IteratorToBag(qual$38.cypher(x$136, x$137, x$138, x$139).records().iterator()).toBag(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a.val"), (Object)"foo")})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
        this.it().apply("supports CLONE in CONSTRUCT", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                RelationalCypherGraph qual$39 = this.$outer.testGraph1().unionAll((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyGraph[]{this.$outer.testGraph2()}));
                String x$140 = new StringOps(Predef$.MODULE$.augmentString("\n        |MATCH (n),(m)\n        |WHERE n.name = 'Mats' AND m.name = 'Phil'\n        |CONSTRUCT\n        | CLONE n AS n, m AS m\n        | CREATE (n)-[r:KNOWS]->(m)\n        |RETURN GRAPH\n      ")).stripMargin();
                Map x$141 = qual$39.cypher$default$2();
                Option x$142 = qual$39.cypher$default$3();
                Map x$143 = qual$39.cypher$default$4();
                CypherResult res = qual$39.cypher(x$140, x$141, x$142, x$143);
                PropertyGraph qual$40 = res.graph();
                String x$144 = "n";
                CTNode x$145 = qual$40.nodes$default$2();
                boolean x$146 = qual$40.nodes$default$3();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)qual$40.nodes(x$144, x$145, x$146).collect().length), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 500), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)2));
                PropertyGraph qual$41 = res.graph();
                String x$147 = "r";
                CTRelationship x$148 = qual$41.relationships$default$2();
                return this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)qual$41.relationships(x$147, x$148).collect().length), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 489));
        this.it().apply("implicitly CLONEs in CONSTRUCT", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                RelationalCypherGraph qual$42 = this.$outer.testGraph1().unionAll((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyGraph[]{this.$outer.testGraph2()}));
                String x$149 = new StringOps(Predef$.MODULE$.augmentString("\n        |MATCH (n),(m)\n        |WHERE n.name = 'Mats' AND m.name = 'Phil'\n        |CONSTRUCT\n        | CREATE (n)-[r:KNOWS]->(m)\n        |RETURN GRAPH\n      ")).stripMargin();
                Map x$150 = qual$42.cypher$default$2();
                Option x$151 = qual$42.cypher$default$3();
                Map x$152 = qual$42.cypher$default$4();
                CypherResult res = qual$42.cypher(x$149, x$150, x$151, x$152);
                PropertyGraph qual$43 = res.graph();
                String x$153 = "n";
                CTNode x$154 = qual$43.nodes$default$2();
                boolean x$155 = qual$43.nodes$default$3();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)qual$43.nodes(x$153, x$154, x$155).collect().length), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)2));
                PropertyGraph qual$44 = res.graph();
                String x$156 = "r";
                CTRelationship x$157 = qual$44.relationships$default$2();
                return this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)qual$44.relationships(x$156, x$157).collect().length), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
        this.it().apply("constructs multiple relationships", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                RelationalCypherGraph<SparkTable.DataFrameTable> inputGraph = this.$outer.initGraph(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE (p0 {name: 'Mats'})\n        |CREATE (p1 {name: 'Phil'})\n      ")).stripMargin(), this.$outer.caps());
                CypherResult res = inputGraph.cypher(new StringOps(Predef$.MODULE$.augmentString("\n        |MATCH (n),(m)\n        |WHERE n <> m\n        |CONSTRUCT\n        | CREATE (n)-[r:KNOWS]->(m)\n        |RETURN GRAPH\n      ")).stripMargin(), inputGraph.cypher$default$2(), inputGraph.cypher$default$3(), inputGraph.cypher$default$4());
                PropertyGraph qual$45 = res.graph();
                String x$158 = "n";
                CTNode x$159 = qual$45.nodes$default$2();
                boolean x$160 = qual$45.nodes$default$3();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)qual$45.nodes(x$158, x$159, x$160).collect().length), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 534), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)2));
                PropertyGraph qual$46 = res.graph();
                String x$161 = "r";
                CTRelationship x$162 = qual$46.relationships$default$2();
                return this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)qual$46.relationships(x$161, x$162).collect().length), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 535), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)2));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 518));
        this.it().apply("implicitly clones when constructing multiple relationships", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                RelationalCypherGraph<SparkTable.DataFrameTable> inputGraph = this.$outer.initGraph(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE (p0 {name: 'Mats'})\n        |CREATE (p1 {name: 'Phil'})\n        |CREATE (p0)-[:KNOWS]->(p1)\n        |CREATE (p0)-[:KNOWS]->(p1)\n        |CREATE (p1)-[:KNOWS]->(p0)\n      ")).stripMargin(), this.$outer.caps());
                CypherResult res = inputGraph.cypher(new StringOps(Predef$.MODULE$.augmentString("\n        |MATCH (n)-[:KNOWS]->(m)\n        |WITH DISTINCT n, m\n        |CONSTRUCT\n        | CREATE (n)-[r:KNOWS]->(m)\n        |RETURN GRAPH\n      ")).stripMargin(), inputGraph.cypher$default$2(), inputGraph.cypher$default$3(), inputGraph.cypher$default$4());
                PropertyGraph qual$47 = res.graph();
                String x$163 = "n";
                CTNode x$164 = qual$47.nodes$default$2();
                boolean x$165 = qual$47.nodes$default$3();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)qual$47.nodes(x$163, x$164, x$165).collect().length), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)2));
                PropertyGraph qual$48 = res.graph();
                String x$166 = "r";
                CTRelationship x$167 = qual$48.relationships$default$2();
                return this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)qual$48.relationships(x$166, x$167).collect().length), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 558), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)2));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 538));
        this.it().apply("constructs multiple relationships 2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                RelationalCypherGraph<SparkTable.DataFrameTable> inputGraph = this.$outer.initGraph(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE (p0 {name: 'Mats'})\n        |CREATE (p1 {name: 'Phil'})\n        |CREATE (p0)-[:KNOWS]->(p1)\n        |CREATE (p0)-[:KNOWS]->(p1)\n        |CREATE (p1)-[:KNOWS]->(p0)\n      ")).stripMargin(), this.$outer.caps());
                CypherResult res = inputGraph.cypher(new StringOps(Predef$.MODULE$.augmentString("\n        |MATCH (n)-[:KNOWS]->(m)\n        |CONSTRUCT\n        | CLONE n AS n, m AS m\n        | CREATE (n)-[r:KNOWS]->(m)\n        |RETURN GRAPH\n      ")).stripMargin(), inputGraph.cypher$default$2(), inputGraph.cypher$default$3(), inputGraph.cypher$default$4());
                PropertyGraph qual$49 = res.graph();
                String x$168 = "n";
                CTNode x$169 = qual$49.nodes$default$2();
                boolean x$170 = qual$49.nodes$default$3();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)qual$49.nodes(x$168, x$169, x$170).collect().length), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 580), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)2));
                PropertyGraph qual$50 = res.graph();
                String x$171 = "r";
                CTRelationship x$172 = qual$50.relationships$default$2();
                return this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)qual$50.relationships(x$171, x$172).collect().length), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 581), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)3));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 561));
        this.it().apply("implicitly clones when constructing multiple relationships 2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                RelationalCypherGraph<SparkTable.DataFrameTable> inputGraph = this.$outer.initGraph(new StringOps(Predef$.MODULE$.augmentString("\n        |CREATE (p0 {name: 'Mats'})\n        |CREATE (p1 {name: 'Phil'})\n        |CREATE (p0)-[:KNOWS]->(p1)\n        |CREATE (p0)-[:KNOWS]->(p1)\n        |CREATE (p1)-[:KNOWS]->(p0)\n      ")).stripMargin(), this.$outer.caps());
                CypherResult res = inputGraph.cypher(new StringOps(Predef$.MODULE$.augmentString("\n        |MATCH (n)-[:KNOWS]->(m)\n        |CONSTRUCT\n        | CREATE (n)-[r:KNOWS]->(m)\n        |RETURN GRAPH\n      ")).stripMargin(), inputGraph.cypher$default$2(), inputGraph.cypher$default$3(), inputGraph.cypher$default$4());
                PropertyGraph qual$51 = res.graph();
                String x$173 = "n";
                CTNode x$174 = qual$51.nodes$default$2();
                boolean x$175 = qual$51.nodes$default$3();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)qual$51.nodes(x$173, x$174, x$175).collect().length), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 602), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)2));
                PropertyGraph qual$52 = res.graph();
                String x$176 = "r";
                CTRelationship x$177 = qual$52.relationships$default$2();
                return this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)qual$52.relationships(x$176, x$177).collect().length), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 603), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToInteger((int)3));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 584));
        this.it().apply("CONSTRUCTS ON a single graph", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                this.$outer.caps().catalog().store("one", this.$outer.testGraph1());
                String query = new StringOps(Predef$.MODULE$.augmentString("\n        |CONSTRUCT ON one\n        |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$53 = this.$outer.testGraph2();
                String x$178 = query;
                Map x$179 = qual$53.cypher$default$2();
                Option x$180 = qual$53.cypher$default$3();
                Map x$181 = qual$53.cypher$default$4();
                PropertyGraph result = qual$53.cypher(x$178, x$179, x$180, x$181).graph();
                this.$outer.convertToAnyShouldWrapper(CAPSSchema$.MODULE$.CAPSSchemaConverter(result.schema()).asCaps(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 615), Prettifier$.MODULE$.default()).should(this.$outer.equal(this.$outer.testGraph1().schema()), (Object)Equality$.MODULE$.default());
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$54 = this.$outer.testGraph1();
                String x$182 = "n";
                CTNode x$183 = qual$54.nodes$default$2();
                boolean x$184 = qual$54.nodes$default$3();
                this.$outer.convertToAnyShouldWrapper(this.$outer.RichRecords(result.nodes("n", result.nodes$default$2(), result.nodes$default$3())).toMaps(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 616), Prettifier$.MODULE$.default()).should(this.$outer.equal(this.$outer.RichRecords((CypherRecords)qual$54.nodes(x$182, x$183, x$184)).toMaps()), (Object)Equality$.MODULE$.default());
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$55 = this.$outer.testGraph1();
                String x$185 = "r";
                CTRelationship x$186 = qual$55.relationships$default$2();
                return this.$outer.convertToAnyShouldWrapper(this.$outer.RichRecords(result.relationships("r", result.relationships$default$2())).toMaps(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 617), Prettifier$.MODULE$.default()).should(this.$outer.equal(this.$outer.RichRecords((CypherRecords)qual$55.relationships(x$185, x$186)).toMaps()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 606));
        this.it().apply("CONSTRUCT ON a single graph without GraphUnionAll", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Object apply() {
                Option option;
                block7: {
                    Object object;
                    block6: {
                        block5: {
                            boolean bl;
                            this.$outer.caps().catalog().store("one", this.$outer.testGraph1());
                            String query = new StringOps(Predef$.MODULE$.augmentString("\n        |CONSTRUCT ON one\n        |MATCH (n) RETURN n")).stripMargin();
                            RelationalCypherGraph<SparkTable.DataFrameTable> qual$56 = this.$outer.testGraph2();
                            String x$187 = query;
                            Map x$188 = qual$56.cypher$default$2();
                            Option x$189 = qual$56.cypher$default$3();
                            Map x$190 = qual$56.cypher$default$4();
                            CypherResult result = qual$56.cypher(x$187, x$188, x$189, x$190);
                            option = CAPSConverters.RichCypherResult$.MODULE$.asCaps$extension(CAPSConverters$.MODULE$.RichCypherResult(result), this.$outer.caps()).maybeRelational();
                            if (!(option instanceof Some)) break block5;
                            Some some = (Some)option;
                            RelationalOperator relPlan = (RelationalOperator)some.x();
                            SwitchContext switchOp = (SwitchContext)relPlan.collectFirst((PartialFunction)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final <A1 extends RelationalOperator<SparkTable.DataFrameTable>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                    Object object;
                                    A1 A1 = x1;
                                    if (A1 instanceof SwitchContext) {
                                        SwitchContext switchContext = (SwitchContext)A1;
                                        object = switchContext;
                                    } else {
                                        object = function1.apply(x1);
                                    }
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(RelationalOperator<SparkTable.DataFrameTable> x1) {
                                    RelationalOperator<SparkTable.DataFrameTable> relationalOperator = x1;
                                    boolean bl = relationalOperator instanceof SwitchContext;
                                    return bl;
                                }
                            }).get();
                            RelationalCypherGraph relationalCypherGraph = (RelationalCypherGraph)((Tuple2)switchOp.context().queryLocalCatalog().head())._2();
                            if (relationalCypherGraph instanceof RelationalCypherGraph && relationalCypherGraph instanceof UnionGraph) {
                                UnionGraph unionGraph = (UnionGraph)relationalCypherGraph;
                                bl = unionGraph.graphs().collectFirst((PartialFunction)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final <A1 extends RelationalCypherGraph<Table>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                        Object object;
                                        A1 A1 = x2;
                                        if (A1 instanceof UnionGraph) {
                                            UnionGraph unionGraph = (UnionGraph)A1;
                                            object = unionGraph;
                                        } else {
                                            object = function1.apply(x2);
                                        }
                                        return (B1)object;
                                    }

                                    public final boolean isDefinedAt(RelationalCypherGraph<Table> x2) {
                                        RelationalCypherGraph<Table> relationalCypherGraph = x2;
                                        boolean bl = relationalCypherGraph instanceof UnionGraph;
                                        return bl;
                                    }
                                }).isDefined();
                            } else {
                                bl = false;
                            }
                            boolean containsUnionGraph = bl;
                            object = this.$outer.withClue("CONSTRUCT plans union on a single input graph", (Function0)new Serializable(this, containsUnionGraph){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$34 $outer;
                                private final boolean containsUnionGraph$1;

                                public final Assertion apply() {
                                    return this.$outer.org$opencypher$spark$impl$acceptance$MultipleGraphTests$$anonfun$$$outer().convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)this.containsUnionGraph$1), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 637), Prettifier$.MODULE$.default()).shouldBe((Object)BoxesRunTime.boxToBoolean((boolean)false));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.containsUnionGraph$1 = containsUnionGraph$1;
                                }
                            });
                            break block6;
                        }
                        if (!None$.MODULE$.equals(option)) break block7;
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                }
                throw new MatchError((Object)option);
            }

            public /* synthetic */ MultipleGraphTests org$opencypher$spark$impl$acceptance$MultipleGraphTests$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 620));
        this.it().apply("CONSTRUCTS ON two graphs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                this.$outer.caps().catalog().store("one", this.$outer.testGraph1());
                this.$outer.caps().catalog().store("two", this.$outer.testGraph2());
                String query = new StringOps(Predef$.MODULE$.augmentString("\n        |CONSTRUCT ON one, two\n        |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$57 = this.$outer.testGraph2();
                String x$191 = query;
                Map x$192 = qual$57.cypher$default$2();
                Option x$193 = qual$57.cypher$default$3();
                Map x$194 = qual$57.cypher$default$4();
                PropertyGraph result = qual$57.cypher(x$191, x$192, x$193, x$194).graph();
                this.$outer.convertToAnyShouldWrapper(result.schema(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 654), Prettifier$.MODULE$.default()).should(this.$outer.equal(this.$outer.testGraph1().schema().$plus$plus(this.$outer.testGraph2().schema())), (Object)Equality$.MODULE$.default());
                RelationalCypherGraph qual$58 = this.$outer.testGraph1().unionAll((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyGraph[]{this.$outer.testGraph2()}));
                String x$195 = "n";
                CTNode x$196 = qual$58.nodes$default$2();
                boolean x$197 = qual$58.nodes$default$3();
                this.$outer.convertToAnyShouldWrapper(this.$outer.RichRecords(result.nodes("n", result.nodes$default$2(), result.nodes$default$3())).toMaps(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 655), Prettifier$.MODULE$.default()).should(this.$outer.equal(this.$outer.RichRecords((CypherRecords)qual$58.nodes(x$195, x$196, x$197)).toMaps()), (Object)Equality$.MODULE$.default());
                RelationalCypherGraph qual$59 = this.$outer.testGraph1().unionAll((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyGraph[]{this.$outer.testGraph2()}));
                String x$198 = "r";
                CTRelationship x$199 = qual$59.relationships$default$2();
                return this.$outer.convertToAnyShouldWrapper(this.$outer.RichRecords(result.relationships("r", result.relationships$default$2())).toMaps(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 656), Prettifier$.MODULE$.default()).should(this.$outer.equal(this.$outer.RichRecords((CypherRecords)qual$59.relationships(x$198, x$199)).toMaps()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 644));
        this.it().apply("CONSTRUCTS ON two graphs and adds a relationship", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                this.$outer.caps().catalog().store("one", this.$outer.testGraph1());
                this.$outer.caps().catalog().store("two", this.$outer.testGraph2());
                String query = new StringOps(Predef$.MODULE$.augmentString("|FROM GRAPH one\n         |MATCH (m: Person)\n         |FROM GRAPH two\n         |MATCH (p: Person)\n         |CONSTRUCT ON one, two\n         |  CREATE (m)-[:KNOWS]->(p)\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph result = (RelationalCypherGraph)this.$outer.caps().cypher(query, this.$outer.caps().cypher$default$2(), this.$outer.caps().cypher$default$3(), this.$outer.caps().cypher$default$4()).graph();
                this.$outer.convertToAnyShouldWrapper(result.schema(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 673), Prettifier$.MODULE$.default()).should(this.$outer.equal(this.$outer.testGraph1().schema().$plus$plus(this.$outer.testGraph2().schema()).withRelationshipPropertyKeys("KNOWS", (Seq)Nil$.MODULE$)), (Object)Equality$.MODULE$.default());
                RelationalCypherGraph qual$60 = this.$outer.testGraph1().unionAll((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyGraph[]{this.$outer.testGraph2()}));
                String x$200 = "n";
                CTNode x$201 = qual$60.nodes$default$2();
                boolean x$202 = qual$60.nodes$default$3();
                this.$outer.convertToAnyShouldWrapper(this.$outer.RichRecords((CypherRecords)result.nodes("n", result.nodes$default$2(), result.nodes$default$3())).toMaps(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 674), Prettifier$.MODULE$.default()).should(this.$outer.equal(this.$outer.RichRecords((CypherRecords)qual$60.nodes(x$200, x$201, x$202)).toMaps()), (Object)Equality$.MODULE$.default());
                CAPSRelationship resultRelationship = (CAPSRelationship)CypherValue.CypherMap$.MODULE$.apply$extension(((CypherValue.CypherMap)((Tuple2)this.$outer.RichRecords((CypherRecords)result.relationships("r", result.relationships$default$2())).toMapsWithCollectedEntities().head())._1()).value(), "r");
                this.$outer.convertToAnyShouldWrapper(resultRelationship.startId(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 676), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.byteArrayOps(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(0L), 0)).toList()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(resultRelationship.endId(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 677), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.byteArrayOps(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(0L), 1)).toList()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(resultRelationship.id(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 678), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.byteArrayOps(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(0L), -1)).toList()), (Object)Equality$.MODULE$.default());
                return this.$outer.convertToStringShouldWrapper(resultRelationship.relType(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 679), Prettifier$.MODULE$.default()).should(this.$outer.equal("KNOWS"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 659));
        this.it().apply("implictly clones when CONSTRUCTing ON two graphs and adding a relationship", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                this.$outer.caps().catalog().store("one", this.$outer.testGraph1());
                this.$outer.caps().catalog().store("two", this.$outer.testGraph2());
                String query = new StringOps(Predef$.MODULE$.augmentString("|FROM GRAPH one\n         |MATCH (m: Person)\n         |FROM GRAPH two\n         |MATCH (p: Person)\n         |CONSTRUCT ON one, two\n         |  CREATE (m)-[:KNOWS]->(p)\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph result = (RelationalCypherGraph)this.$outer.caps().cypher(query, this.$outer.caps().cypher$default$2(), this.$outer.caps().cypher$default$3(), this.$outer.caps().cypher$default$4()).graph();
                this.$outer.convertToAnyShouldWrapper(result.schema(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 696), Prettifier$.MODULE$.default()).should(this.$outer.equal(this.$outer.testGraph1().schema().$plus$plus(this.$outer.testGraph2().schema()).withRelationshipPropertyKeys("KNOWS", (Seq)Nil$.MODULE$)), (Object)Equality$.MODULE$.default());
                RelationalCypherGraph qual$61 = this.$outer.testGraph1().unionAll((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyGraph[]{this.$outer.testGraph2()}));
                String x$203 = "n";
                CTNode x$204 = qual$61.nodes$default$2();
                boolean x$205 = qual$61.nodes$default$3();
                this.$outer.convertToAnyShouldWrapper(this.$outer.RichRecords((CypherRecords)result.nodes("n", result.nodes$default$2(), result.nodes$default$3())).toMaps(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 697), Prettifier$.MODULE$.default()).should(this.$outer.equal(this.$outer.RichRecords((CypherRecords)qual$61.nodes(x$203, x$204, x$205)).toMaps()), (Object)Equality$.MODULE$.default());
                CAPSRelationship resultRelationship = (CAPSRelationship)CypherValue.CypherMap$.MODULE$.apply$extension(((CypherValue.CypherMap)((Tuple2)this.$outer.RichRecords((CypherRecords)result.relationships("r", result.relationships$default$2())).toMapsWithCollectedEntities().head())._1()).value(), "r");
                this.$outer.convertToAnyShouldWrapper(resultRelationship.startId(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 699), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.byteArrayOps(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(0L), 0)).toList()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(resultRelationship.endId(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 700), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.byteArrayOps(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(0L), 1)).toList()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(resultRelationship.id(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 701), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.byteArrayOps(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(0L), -1)).toList()), (Object)Equality$.MODULE$.default());
                return this.$outer.convertToStringShouldWrapper(resultRelationship.relType(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 702), Prettifier$.MODULE$.default()).should(this.$outer.equal("KNOWS"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 682));
        this.it().apply("constructs a created node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                String query = new StringOps(Predef$.MODULE$.augmentString("\n        |CONSTRUCT\n        |  CREATE (a)\n        |RETURN GRAPH\n      ")).stripMargin();
                RelationalCypherGraph graph = (RelationalCypherGraph)this.$outer.caps().cypher(query, this.$outer.caps().cypher$default$2(), this.$outer.caps().cypher$default$3(), this.$outer.caps().cypher$default$4()).graph();
                this.$outer.convertToAnyShouldWrapper(graph.schema(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 715), Prettifier$.MODULE$.default()).should(this.$outer.equal(Schema$.MODULE$.empty().withNodePropertyKeys(Predef$.MODULE$.Set().empty(), Schema$.MODULE$.empty().withNodePropertyKeys$default$2())), (Object)Equality$.MODULE$.default());
                return this.$outer.convertToAnyShouldWrapper(Bag$.MODULE$.ArrayToBag((Object)graph.nodes("n", graph.nodes$default$2(), graph.nodes$default$3()).collect()).toBag(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 716), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)CAPSNode$.MODULE$.apply(0L, Predef$.MODULE$.Set().empty()))})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 705));
        this.it().apply("construct match construct", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                this.$outer.caps().catalog().store("g1", this.$outer.testGraphRels());
                String query = new StringOps(Predef$.MODULE$.augmentString("\n        |FROM GRAPH g1\n        |MATCH (a)\n        |CONSTRUCT // generated qgn\n        |  CLONE a AS a\n        |MATCH (b)\n        |CONSTRUCT\n        |  ON g1\n        |  CLONE b AS b\n        |RETURN GRAPH\n      ")).stripMargin();
                RelationalCypherGraph graph = (RelationalCypherGraph)this.$outer.caps().cypher(query, this.$outer.caps().cypher$default$2(), this.$outer.caps().cypher$default$3(), this.$outer.caps().cypher$default$4()).graph();
                this.$outer.convertToAnyShouldWrapper(CAPSSchema$.MODULE$.CAPSSchemaConverter(graph.schema()).asCaps(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 738), Prettifier$.MODULE$.default()).should(this.$outer.equal(this.$outer.testGraphRels().schema()), (Object)Equality$.MODULE$.default());
                return this.$outer.convertToAnyShouldWrapper(Bag$.MODULE$.ArrayToBag((Object)graph.nodes("n", graph.nodes$default$2(), graph.nodes$default$3()).collect()).toBag(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 739), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)new CAPSNode((Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(0L), 1)), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"})), CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Mats")}))))}))), new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)new CAPSNode((Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(1L), 1)), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"})), CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Max")}))))}))), new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)new CAPSNode((Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(0L), 0)), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"})), CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Mats")}))))}))), new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)new CAPSNode((Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(1L), 0)), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"})), CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Max")}))))})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 721));
        this.it().apply("does not clone twice when a variable is both constructed on and matched", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                this.$outer.caps().catalog().store("g1", this.$outer.testGraph1());
                this.$outer.caps().catalog().store("g2", this.$outer.testGraph2());
                String query = new StringOps(Predef$.MODULE$.augmentString("\n        |FROM GRAPH g1\n        |MATCH (a:Person)\n        |FROM GRAPH g2\n        |MATCH (b:Person)\n        |CONSTRUCT\n        |  ON g2\n        |  CLONE a AS a, b AS b\n        |RETURN GRAPH\n      ")).stripMargin();
                RelationalCypherGraph graph = (RelationalCypherGraph)this.$outer.caps().cypher(query, this.$outer.caps().cypher$default$2(), this.$outer.caps().cypher$default$3(), this.$outer.caps().cypher$default$4()).graph();
                this.$outer.convertToAnyShouldWrapper(CAPSSchema$.MODULE$.CAPSSchemaConverter(graph.schema()).asCaps(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 764), Prettifier$.MODULE$.default()).should(this.$outer.equal(this.$outer.testGraph1().schema()), (Object)Equality$.MODULE$.default());
                return this.$outer.convertToAnyShouldWrapper(Bag$.MODULE$.ArrayToBag((Object)graph.nodes("n", graph.nodes$default$2(), graph.nodes$default$3()).collect()).toBag(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 765), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)new CAPSNode((Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(0L), 1)), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"})), CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Mats")}))))}))), new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)new CAPSNode((Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(0L), 0)), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"})), CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Phil")}))))})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 747));
        this.it().apply("allows CONSTRUCT ON with relationships", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                this.$outer.caps().catalog().store("testGraphRels1", this.$outer.testGraphRels());
                this.$outer.caps().catalog().store("testGraphRels2", this.$outer.testGraphRels());
                String query = new StringOps(Predef$.MODULE$.augmentString("|FROM GRAPH testGraphRels1\n         |MATCH (p1 :Person)-[r1]->(p2 :Person)\n         |CONSTRUCT ON testGraphRels2\n         |  CLONE p1 AS p1, r1 AS r1, p2 AS p2\n         |  CREATE (p1)-[r1]->( p2)\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph result = (RelationalCypherGraph)this.$outer.caps().cypher(query, this.$outer.caps().cypher$default$2(), this.$outer.caps().cypher$default$3(), this.$outer.caps().cypher$default$4()).graph();
                this.$outer.convertToAnyShouldWrapper(result.schema(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 784), Prettifier$.MODULE$.default()).should(this.$outer.equal(this.$outer.testGraph1().schema().$plus$plus(this.$outer.testGraph2().schema()).withRelationshipPropertyKeys("HAS_SIMILAR_NAME", (Seq)Nil$.MODULE$)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.RichRecords((CypherRecords)result.nodes("n", result.nodes$default$2(), result.nodes$default$3())).toMapsWithCollectedEntities(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 786), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)new CAPSNode((Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(0L), 0)), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"})), CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Mats")}))))}))), new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)new CAPSNode((Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(1L), 0)), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"})), CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Max")}))))}))), new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)new CAPSNode((Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(0L), 1)), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"})), CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Mats")}))))}))), new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)new CAPSNode((Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(1L), 1)), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"})), CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Max")}))))})))}))), (Object)Equality$.MODULE$.default());
                return this.$outer.convertToAnyShouldWrapper(this.$outer.RichRecords((CypherRecords)result.relationships("r", result.relationships$default$2())).toMapsWithCollectedEntities(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 793), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r"), (Object)new CAPSRelationship((Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(2L), 0)), (Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(1L), 0)), (Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(0L), 0)), "HAS_SIMILAR_NAME", CAPSRelationship$.MODULE$.apply$default$5()))}))), new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r"), (Object)new CAPSRelationship((Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(2L), 1)), (Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(1L), 1)), (Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(0L), 1)), "HAS_SIMILAR_NAME", CAPSRelationship$.MODULE$.apply$default$5()))})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 771));
        this.it().apply("allows cloning from different graphs with nodes and relationships", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                this.$outer.caps().catalog().store("testGraphRels1", (PropertyGraph)this.testGraphRels$1());
                this.$outer.caps().catalog().store("testGraphRels2", (PropertyGraph)this.testGraphRels$1());
                String query = new StringOps(Predef$.MODULE$.augmentString("|FROM GRAPH testGraphRels1\n         |MATCH (p1 :Person)-[r1]->(p2 :Person)\n         |FROM GRAPH testGraphRels2\n         |MATCH (p3 :Person)-[r2]->(p4 :Person)\n         |CONSTRUCT\n         |  CLONE p1 AS p1, p2 AS p2, p3 AS p3, p4 AS p4, r1 AS r1, r2 AS r2\n         |  CREATE (p1)-[r1]->(p2)\n         |  CREATE (p3)-[r2]->(p4)\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph result = (RelationalCypherGraph)this.$outer.caps().cypher(query, this.$outer.caps().cypher$default$2(), this.$outer.caps().cypher$default$3(), this.$outer.caps().cypher$default$4()).graph();
                this.$outer.convertToAnyShouldWrapper(CAPSSchema$.MODULE$.CAPSSchemaConverter(result.schema()).asCaps(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 822), Prettifier$.MODULE$.default()).shouldEqual((Object)this.testGraphRels$1().schema(), Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(this.$outer.RichRecords((CypherRecords)result.nodes("n", result.nodes$default$2(), result.nodes$default$3())).toMapsWithCollectedEntities(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 824), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)new CAPSNode((Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(0L), 0)), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"})), CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Mats")}))))}))), new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)new CAPSNode((Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(1L), 0)), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"})), CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Max")}))))}))), new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)new CAPSNode((Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(0L), 1)), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"})), CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Mats")}))))}))), new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)new CAPSNode((Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(1L), 1)), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"})), CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"Max")}))))})))}))), (Object)Equality$.MODULE$.default());
                return this.$outer.convertToAnyShouldWrapper(this.$outer.RichRecords((CypherRecords)result.relationships("r", result.relationships$default$2())).toMapsWithCollectedEntities(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 831), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r"), (Object)new CAPSRelationship((Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(2L), 0)), (Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(1L), 0)), (Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(0L), 0)), "HAS_SIMILAR_NAME", CAPSRelationship$.MODULE$.apply$default$5()))}))), new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"r"), (Object)new CAPSRelationship((Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(2L), 1)), (Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(1L), 1)), (Seq)Predef$.MODULE$.wrapByteArray(CAPSEntity.LongIdEncoding$.MODULE$.withPrefix$extension(CAPSEntity$.MODULE$.LongIdEncoding(0L), 1)), "HAS_SIMILAR_NAME", CAPSRelationship$.MODULE$.apply$default$5()))})))}))), (Object)Equality$.MODULE$.default());
            }

            private final RelationalCypherGraph testGraphRels$1() {
                return this.$outer.initGraph(new StringOps(Predef$.MODULE$.augmentString("|CREATE (mats:Person {name: 'Mats'})\n         |CREATE (max:Person {name: 'Max'})\n         |CREATE (max)-[:HAS_SIMILAR_NAME]->(mats)\n      ")).stripMargin(), this.$outer.caps());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 800));
        this.it().apply("allows consecutive construction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                String query = new StringOps(Predef$.MODULE$.augmentString("|CONSTRUCT\n         |  CREATE (a:A)-[r:FOO]->(b:B)\n         |MATCH (a)-->(b)\n         |CONSTRUCT\n         |  CLONE a AS a, b AS b\n         |  CREATE (a)-[:KNOWS]->(b)\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$62 = this.$outer.testGraph1();
                String x$206 = query;
                Map x$207 = qual$62.cypher$default$2();
                Option x$208 = qual$62.cypher$default$3();
                Map x$209 = qual$62.cypher$default$4();
                CypherResult result = qual$62.cypher(x$206, x$207, x$208, x$209);
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 849), Prettifier$.MODULE$.default()).shouldBe((Object)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(result.graph().schema().relationshipTypes(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 850), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result.graph().schema().labels(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 851), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B"}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result.graph().schema(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 852), Prettifier$.MODULE$.default()).should(this.$outer.equal(Schema$.MODULE$.empty().withNodePropertyKeys((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"}), (Seq)Nil$.MODULE$).withNodePropertyKeys((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"}), (Seq)Nil$.MODULE$).withRelationshipPropertyKeys("KNOWS", (Seq)Nil$.MODULE$)), (Object)Equality$.MODULE$.default());
                PropertyGraph qual$63 = result.graph();
                String x$210 = "MATCH ()-[r]->() RETURN type(r)";
                Map x$211 = qual$63.cypher$default$2();
                Option x$212 = qual$63.cypher$default$3();
                Map x$213 = qual$63.cypher$default$4();
                return this.$outer.convertToAnyShouldWrapper(Bag$.MODULE$.IteratorToBag(qual$63.cypher(x$210, x$211, x$212, x$213).records().iterator()).toBag(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 857), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type(r)"), (Object)"KNOWS")})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 837));
        this.it().apply("implictly clones when doing consecutive construction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                String query = new StringOps(Predef$.MODULE$.augmentString("|CONSTRUCT\n         |  CREATE (a:A)-[r:FOO]->(b:B)\n         |MATCH (a)-->(b)\n         |CONSTRUCT\n         |  CREATE (a)-[:KNOWS]->(b)\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$64 = this.$outer.testGraph1();
                String x$214 = query;
                Map x$215 = qual$64.cypher$default$2();
                Option x$216 = qual$64.cypher$default$3();
                Map x$217 = qual$64.cypher$default$4();
                CypherResult result = qual$64.cypher(x$214, x$215, x$216, x$217);
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 873), Prettifier$.MODULE$.default()).shouldBe((Object)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(result.graph().schema().relationshipTypes(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 874), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result.graph().schema().labels(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 875), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B"}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result.graph().schema(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 876), Prettifier$.MODULE$.default()).should(this.$outer.equal(Schema$.MODULE$.empty().withNodePropertyKeys((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"}), (Seq)Nil$.MODULE$).withNodePropertyKeys((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"}), (Seq)Nil$.MODULE$).withRelationshipPropertyKeys("KNOWS", (Seq)Nil$.MODULE$)), (Object)Equality$.MODULE$.default());
                PropertyGraph qual$65 = result.graph();
                String x$218 = "MATCH ()-[r]->() RETURN type(r)";
                Map x$219 = qual$65.cypher$default$2();
                Option x$220 = qual$65.cypher$default$3();
                Map x$221 = qual$65.cypher$default$4();
                return this.$outer.convertToAnyShouldWrapper(Bag$.MODULE$.IteratorToBag(qual$65.cypher(x$218, x$219, x$220, x$221).records().iterator()).toBag(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 880), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type(r)"), (Object)"KNOWS")})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 862));
        this.it().apply("can construct a copy of a node with matched label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                this.$outer.caps().cypher("CATALOG CREATE GRAPH foo { CONSTRUCT CREATE (:A) RETURN GRAPH }", this.$outer.caps().cypher$default$2(), this.$outer.caps().cypher$default$3(), this.$outer.caps().cypher$default$4());
                RelationalCypherGraph graph = (RelationalCypherGraph)this.$outer.caps().cypher("FROM GRAPH foo RETURN GRAPH", this.$outer.caps().cypher$default$2(), this.$outer.caps().cypher$default$3(), this.$outer.caps().cypher$default$4()).graph();
                return this.$outer.convertToAnyShouldWrapper(Bag$.MODULE$.IteratorToBag(graph.cypher(new StringOps(Predef$.MODULE$.augmentString("MATCH (a:A)\n        |CONSTRUCT\n        |  CREATE (COPY OF a)\n        |MATCH (n)\n        |RETURN labels(n)\n      ")).stripMargin(), graph.cypher$default$2(), graph.cypher$default$3(), graph.cypher$default$4()).records().iterator()).toBag(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 896), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labels(n)"), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})))})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 885));
        this.it().apply("can construct with an input table expanded by unwind", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                this.$outer.caps().cypher("CATALOG CREATE GRAPH foo { CONSTRUCT CREATE (:A) RETURN GRAPH }", this.$outer.caps().cypher$default$2(), this.$outer.caps().cypher$default$3(), this.$outer.caps().cypher$default$4());
                RelationalCypherGraph qual$66 = (RelationalCypherGraph)this.$outer.caps().cypher("FROM GRAPH foo RETURN GRAPH", this.$outer.caps().cypher$default$2(), this.$outer.caps().cypher$default$3(), this.$outer.caps().cypher$default$4()).graph();
                String x$222 = new StringOps(Predef$.MODULE$.augmentString("MATCH (a:A)\n        |UNWIND [1, 2, 3] AS i\n        |CONSTRUCT\n        |  CREATE (f COPY OF a)-[:FOO]->(g COPY OF a)\n        |  CREATE (:B {name: 'foo'})\n        |MATCH (n)\n        |RETURN n.name\n      ")).stripMargin();
                Map x$223 = qual$66.cypher$default$2();
                Option x$224 = qual$66.cypher$default$3();
                Map x$225 = qual$66.cypher$default$4();
                CypherRecords data = qual$66.cypher(x$222, x$223, x$224, x$225).records();
                Map nullRow = CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n.name"), null)}));
                Map fooRow = CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n.name"), (Object)"foo")}));
                return this.$outer.convertToAnyShouldWrapper(Bag$.MODULE$.IteratorToBag(data.iterator()).toBag(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 916), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(nullRow), new CypherValue.CypherMap(nullRow), new CypherValue.CypherMap(nullRow), new CypherValue.CypherMap(nullRow), new CypherValue.CypherMap(nullRow), new CypherValue.CypherMap(nullRow), new CypherValue.CypherMap(fooRow), new CypherValue.CypherMap(fooRow), new CypherValue.CypherMap(fooRow)}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 901));
        this.it().apply("should set a node property from a matched node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                String query = new StringOps(Predef$.MODULE$.augmentString("|MATCH (m)\n         |CONSTRUCT\n         |  CREATE (a :A)\n         |  SET a.name = m.name\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$67 = this.$outer.testGraph1();
                String x$226 = query;
                Map x$227 = qual$67.cypher$default$2();
                Option x$228 = qual$67.cypher$default$3();
                Map x$229 = qual$67.cypher$default$4();
                CypherResult result = qual$67.cypher(x$226, x$227, x$228, x$229);
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 939), Prettifier$.MODULE$.default()).shouldBe((Object)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(result.graph().schema().labels(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 940), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result.graph().schema(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 941), Prettifier$.MODULE$.default()).should(this.$outer.equal(Schema$.MODULE$.empty().withNodePropertyKeys((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)CTString$.MODULE$)}))), (Object)Equality$.MODULE$.default());
                PropertyGraph qual$68 = result.graph();
                String x$230 = "MATCH (a:A) RETURN a.name";
                Map x$231 = qual$68.cypher$default$2();
                Option x$232 = qual$68.cypher$default$3();
                Map x$233 = qual$68.cypher$default$4();
                return this.$outer.convertToAnyShouldWrapper(this.$outer.RichRecords(qual$68.cypher(x$230, x$231, x$232, x$233).records()).toMaps(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 942), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a.name"), (Object)"Mats")})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 929));
        this.it().apply("should set a node property from a literal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                String query = new StringOps(Predef$.MODULE$.augmentString("|CONSTRUCT\n         |  CREATE (a :A)\n         |  SET a.name = 'Donald'\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$69 = this.$outer.testGraph1();
                String x$234 = query;
                Map x$235 = qual$69.cypher$default$2();
                Option x$236 = qual$69.cypher$default$3();
                Map x$237 = qual$69.cypher$default$4();
                CypherResult result = qual$69.cypher(x$234, x$235, x$236, x$237);
                this.$outer.convertToAnyShouldWrapper(result.getRecords(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 956), Prettifier$.MODULE$.default()).shouldBe((Object)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(result.graph().schema().labels(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 957), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result.graph().schema(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 958), Prettifier$.MODULE$.default()).should(this.$outer.equal(Schema$.MODULE$.empty().withNodePropertyKeys((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"}), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)CTString$.MODULE$)}))), (Object)Equality$.MODULE$.default());
                PropertyGraph qual$70 = result.graph();
                String x$238 = "MATCH (a:A) RETURN a.name";
                Map x$239 = qual$70.cypher$default$2();
                Option x$240 = qual$70.cypher$default$3();
                Map x$241 = qual$70.cypher$default$4();
                return this.$outer.convertToAnyShouldWrapper(this.$outer.RichRecords(qual$70.cypher(x$238, x$239, x$240, x$241).records()).toMaps(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 959), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a.name"), (Object)"Donald")})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 947));
        this.it().apply("should set a node label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                String query = new StringOps(Predef$.MODULE$.augmentString("|CONSTRUCT\n         |  CREATE (a)\n         |  SET a: FOO\n         |MATCH (n)\n         |RETURN n")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$71 = this.$outer.testGraph1();
                String x$242 = query;
                Map x$243 = qual$71.cypher$default$2();
                Option x$244 = qual$71.cypher$default$3();
                Map x$245 = qual$71.cypher$default$4();
                CypherResult result = qual$71.cypher(x$242, x$243, x$244, x$245);
                return this.$outer.convertToAnyShouldWrapper(this.$outer.RichRecords(result.records()).toMapsWithCollectedEntities(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 974), Prettifier$.MODULE$.default()).shouldBe((Object)Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"n"), (Object)CAPSNode$.MODULE$.apply(0L, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FOO"}))))})))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 964));
        this.ignore("should set multiple properties", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MultipleGraphTests $outer;

            public final Assertion apply() {
                String query = new StringOps(Predef$.MODULE$.augmentString("|MATCH (a)\n         |CONSTRUCT\n         |  CLONE a as newA\n         |  CREATE (newA :A:B)\n         |  SET newA.name = 'Donald'\n         |  SET newA.age = 100\n         |RETURN GRAPH")).stripMargin();
                RelationalCypherGraph<SparkTable.DataFrameTable> qual$72 = this.$outer.testGraph1();
                String x$246 = query;
                Map x$247 = qual$72.cypher$default$2();
                Option x$248 = qual$72.cypher$default$3();
                Map x$249 = qual$72.cypher$default$4();
                CypherResult result = qual$72.cypher(x$246, x$247, x$248, x$249);
                this.$outer.convertToAnyShouldWrapper(this.$outer.RichRecords(result.records()).toMaps(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 992), Prettifier$.MODULE$.default()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfAnyRefWithParameterlessIsEmptyMethod());
                this.$outer.convertToAnyShouldWrapper(result.graph().schema().labels(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 993), Prettifier$.MODULE$.default()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B"}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result.graph().schema(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 994), Prettifier$.MODULE$.default()).should(this.$outer.equal(Schema$.MODULE$.empty().withNodePropertyKeys((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B"})), PropertyKeys$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)CTString$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"age"), (Object)CTInteger$.MODULE$)})))), (Object)Equality$.MODULE$.default());
                PropertyGraph qual$73 = result.graph();
                String x$250 = "MATCH (a:A:B) RETURN a.name";
                Map x$251 = qual$73.cypher$default$2();
                Option x$252 = qual$73.cypher$default$3();
                Map x$253 = qual$73.cypher$default$4();
                return this.$outer.convertToAnyShouldWrapper(this.$outer.RichRecords(qual$73.cypher(x$250, x$251, x$252, x$253).records()).toMaps(), new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 997), Prettifier$.MODULE$.default()).should(this.$outer.equal(Bag$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new CypherValue.CypherMap[]{new CypherValue.CypherMap(CypherValue.CypherMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a.name"), (Object)"Donald")})))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("MultipleGraphTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 980));
    }
}

