/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.FixedHelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.libj.util.Classes;
import org.openjax.cli.Option;
import org.openjax.cli_1_1_7.Cli;
import org.openjax.cli_1_1_7.Use;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class Options {
    private static final Logger logger = LoggerFactory.getLogger(Options.class);
    private static Schema schema;
    private final Map<String, Option> optionNameToOption = new HashMap<String, Option>();
    private final Class<?> mainClass;
    private final String[] args;
    private final Collection<Option> options;
    private final String[] arguments;

    private static String formatArgumentName(String label, int maxOccurs, char valueSeparator) {
        if (maxOccurs == 1) {
            return label;
        }
        StringBuilder buffer = new StringBuilder(label);
        buffer.append(1).append(valueSeparator);
        if (maxOccurs == 2) {
            return buffer.append(label).append(2).toString();
        }
        if (maxOccurs == Integer.MAX_VALUE) {
            return buffer.append(label).append(2).append("...").toString();
        }
        return buffer.append("...").append(valueSeparator).append(label).append(maxOccurs).toString();
    }

    private static void printHelp(org.apache.commons.cli.Options apacheOptions, Cli.Arguments cliArguments, PrintStream ps) {
        FixedHelpFormatter formatter = new FixedHelpFormatter();
        PrintWriter pw = new PrintWriter(ps);
        StringBuilder args = new StringBuilder(apacheOptions.getOptions().size() > 0 ? " [options]" : "");
        if (cliArguments != null) {
            for (short i = 1; i <= cliArguments.getMinOccurs(); i = (short)(i + 1)) {
                args.append(" <").append(cliArguments.getLabel()).append(i != 1 ? Short.valueOf(i) : "").append('>');
            }
            boolean maxUnbounded = "unbounded".equals(cliArguments.getMaxOccurs());
            int argsMax = maxUnbounded ? 2 + cliArguments.getMinOccurs() : Short.parseShort(cliArguments.getMaxOccurs());
            for (int i = cliArguments.getMinOccurs() + 1; i <= argsMax; ++i) {
                args.append(" [").append(cliArguments.getLabel()).append(i != 1 ? Integer.valueOf(i) : "").append(']');
            }
            if (maxUnbounded) {
                args.append(" [...]");
            }
        }
        formatter.printHelp(pw, 74, " ", args.substring(1), apacheOptions, 1, 3, null, false);
        pw.flush();
    }

    private static void trapPrintHelp(org.apache.commons.cli.Options apacheOptions, Cli.Arguments cliArguments, String message, PrintStream ps) {
        if (message != null) {
            ps.println(message);
        }
        Options.printHelp(apacheOptions, cliArguments, ps);
        System.exit(1);
    }

    public static Options parse(File cliFile, String[] args) throws IOException {
        try {
            return Options.parse(cliFile.toURI().toURL(), args);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Options parse(URL cliURL, String[] args) throws IOException {
        try {
            Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])new Class[]{Cli.class}).createUnmarshaller();
            unmarshaller.setSchema(schema == null ? (schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(Thread.currentThread().getContextClassLoader().getResource("cli.xsd"))) : schema);
            try (InputStream in = cliURL.openStream();){
                JAXBElement element = unmarshaller.unmarshal(XMLInputFactory.newInstance().createXMLStreamReader(in), Cli.class);
                Options options = Options.parse((Cli)element.getValue(), args);
                return options;
            }
        }
        catch (FactoryConfigurationError e) {
            throw new UnsupportedOperationException(e);
        }
        catch (JAXBException | XMLStreamException | SAXException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Options parse(Cli binding, String[] args) {
        Object builder;
        List arguments;
        HashSet<String> specifiedLongNames;
        Cli.Arguments cliArguments;
        HashSet<String> requiredNames = new HashSet<String>();
        HashMap<String, String> nameToAltName = new HashMap<String, String>();
        org.apache.commons.cli.Options apacheOptions = new org.apache.commons.cli.Options();
        apacheOptions.addOption(null, "help", false, "Print help and usage.");
        short argumentsMinOccurs = 0;
        short argumentsMaxOccurs = 0;
        if (binding != null) {
            cliArguments = binding.getArguments();
            if (cliArguments != null) {
                argumentsMinOccurs = cliArguments.getMinOccurs();
                short s = argumentsMaxOccurs = "unbounded".equals(cliArguments.getMaxOccurs()) ? (short)Short.MAX_VALUE : (short)Short.parseShort(cliArguments.getMaxOccurs());
                if (argumentsMaxOccurs < argumentsMinOccurs) {
                    logger.error("minOccurs > maxOccurs on <arguments> element");
                    System.exit(1);
                }
            }
            if (binding.getOption() != null) {
                for (Cli.Option option : binding.getOption()) {
                    String name;
                    Cli.Option.Name optionName = option.getName();
                    String longName = optionName.getLong();
                    String shortName = optionName.getShort();
                    String string = name = longName != null ? longName : shortName;
                    if (longName == null && shortName == null) {
                        logger.error("both [long] and [short] option names are null in cli spec");
                        System.exit(1);
                    }
                    nameToAltName.put(name, shortName != null ? shortName : longName);
                    OptionBuilder.withLongOpt((String)(name == longName ? longName : null));
                    if (option.getArgument() != null) {
                        int maxOccurs;
                        boolean isRequired;
                        Cli.Option.Argument argument = option.getArgument();
                        boolean bl = isRequired = Use.REQUIRED == argument.getUse();
                        if (isRequired) {
                            OptionBuilder.isRequired();
                            requiredNames.add(longName);
                        }
                        int n = argument.getMaxOccurs() == null ? 1 : (maxOccurs = "unbounded".equals(argument.getMaxOccurs()) ? Integer.MAX_VALUE : Integer.parseInt(argument.getMaxOccurs()));
                        if (maxOccurs == 1) {
                            if (isRequired) {
                                OptionBuilder.hasArgs((int)1);
                            } else {
                                OptionBuilder.hasOptionalArgs((int)1);
                            }
                        } else if (maxOccurs == Integer.MAX_VALUE) {
                            if (isRequired) {
                                OptionBuilder.hasArgs();
                            } else {
                                OptionBuilder.hasOptionalArgs();
                            }
                        } else if (isRequired) {
                            OptionBuilder.hasArgs((int)maxOccurs);
                        } else {
                            OptionBuilder.hasOptionalArgs((int)maxOccurs);
                        }
                        char valueSeparator = argument.getValueSeparator() != null ? (char)argument.getValueSeparator().charAt(0) : (char)' ';
                        OptionBuilder.withArgName((String)Options.formatArgumentName(argument.getLabel(), maxOccurs, valueSeparator));
                        OptionBuilder.withValueSeparator((char)valueSeparator);
                        if (option.getDescription() == null) {
                            logger.error("missing <description> for " + name + " option");
                            System.exit(1);
                        }
                        StringBuilder description = new StringBuilder(option.getDescription());
                        if (option.getArgument().getDefault() != null) {
                            description.append("\nDefault: ").append(option.getArgument().getDefault());
                        }
                        OptionBuilder.withDescription((String)description.toString());
                    }
                    apacheOptions.addOption(OptionBuilder.create((String)shortName));
                }
            }
        } else {
            cliArguments = null;
        }
        HashMap<String, Option> optionsMap = new HashMap<String, Option>();
        CommandLine commandLine = null;
        if (args != null && args.length != 0) {
            specifiedLongNames = new HashSet<String>();
            PosixParser parser = new PosixParser();
            do {
                try {
                    commandLine = parser.parse(apacheOptions, args);
                }
                catch (UnrecognizedOptionException e) {
                    if (e.getMessage().startsWith("Unrecognized option: ")) {
                        String unrecognizedOption = e.getMessage().substring(21);
                        logger.error("Unrecognized option: " + unrecognizedOption);
                        for (int i = 0; i < args.length; ++i) {
                            if (!args[i].equals(unrecognizedOption)) continue;
                            args[i] = "--help";
                        }
                        continue;
                    }
                    throw new IllegalArgumentException(e);
                }
                catch (ParseException e) {
                    Options.trapPrintHelp(apacheOptions, cliArguments, null, System.err);
                }
            } while (commandLine == null);
        } else {
            specifiedLongNames = null;
        }
        List list = arguments = commandLine != null ? commandLine.getArgList() : null;
        if (arguments != null && arguments.size() > 0) {
            if (argumentsMaxOccurs < arguments.size() || arguments.size() < argumentsMinOccurs) {
                Options.trapPrintHelp(apacheOptions, cliArguments, null, System.err);
            }
        } else if (argumentsMinOccurs > 0) {
            Options.trapPrintHelp(apacheOptions, cliArguments, null, System.err);
        }
        if (commandLine != null) {
            for (org.apache.commons.cli.Option option : commandLine.getOptions()) {
                specifiedLongNames.add(option.getLongOpt());
                if ("help".equals(option.getLongOpt())) {
                    Options.trapPrintHelp(apacheOptions, cliArguments, null, System.out);
                }
                String optionName = option.getLongOpt() != null ? option.getLongOpt() : option.getOpt();
                optionsMap.put(optionName, option.getValue() != null ? new Option(optionName, option.getValueSeparator(), option.getValues()) : new Option(optionName, option.getValueSeparator(), "true"));
            }
        }
        if (requiredNames.size() != 0) {
            if (specifiedLongNames != null) {
                requiredNames.removeAll(specifiedLongNames);
            }
            if (requiredNames.size() != 0) {
                builder = new StringBuilder();
                for (String longName : requiredNames) {
                    String shortName = (String)nameToAltName.get(longName);
                    if (shortName.equals(longName)) {
                        ((StringBuilder)builder).append("\nMissing argument: -").append(shortName);
                        continue;
                    }
                    ((StringBuilder)builder).append("\nMissing argument: -").append(shortName).append(",--").append(longName);
                }
                Options.trapPrintHelp(apacheOptions, cliArguments, ((StringBuilder)builder).substring(1), System.out);
            }
        }
        if (binding.getOption() != null) {
            for (Cli.Option option : binding.getOption()) {
                String optionName;
                if (option.getArgument() == null || option.getArgument().getDefault() == null || optionsMap.containsKey(optionName = option.getName().getLong() != null ? option.getName().getLong() : option.getName().getShort())) continue;
                String valueSeparator = option.getArgument().getValueSeparator();
                String defaultValue = option.getArgument().getDefault();
                optionsMap.put(optionName, valueSeparator != null ? new Option(optionName, valueSeparator.charAt(0), defaultValue) : new Option(optionName, defaultValue));
            }
        }
        if (binding.getOption() != null) {
            builder = new StringBuilder();
            for (Cli.Option option : binding.getOption()) {
                String optionName;
                Option opt;
                if (option.getArgument() == null || option.getArgument().getPattern() == null || (opt = (Option)optionsMap.get(optionName = option.getName().getLong() != null ? option.getName().getLong() : option.getName().getShort())) == null) continue;
                for (String value : opt.getValues()) {
                    if (value.matches(option.getArgument().getPattern())) continue;
                    if (option.getName().getLong() == null || option.getName().getShort() == null) {
                        ((StringBuilder)builder).append("\nIncorrect argument form: -").append(optionName);
                    } else {
                        ((StringBuilder)builder).append("\nIncorrect argument form: -").append(option.getName().getShort()).append(",--").append(option.getName().getLong());
                    }
                    ((StringBuilder)builder).append(' ').append(value).append("\n  Required: ").append(option.getArgument().getPattern());
                }
            }
            if (((StringBuilder)builder).length() > 0) {
                Options.trapPrintHelp(apacheOptions, cliArguments, ((StringBuilder)builder).substring(1), System.out);
            }
        }
        Class[] executionStack = Classes.getExecutionStack();
        Class mainClass = null;
        for (int i = 0; i < executionStack.length && mainClass == null; ++i) {
            if (executionStack[i] == Options.class) continue;
            mainClass = executionStack[i];
        }
        if (mainClass == null) {
            throw new IllegalStateException("Could not determine main class");
        }
        return new Options(mainClass, args, optionsMap.values(), arguments == null || arguments.size() == 0 ? null : arguments.toArray(new String[arguments.size()]));
    }

    private Options(Class<?> mainClass, String[] args, Collection<Option> options, String[] arguments) {
        this.mainClass = mainClass;
        this.args = args;
        this.options = options == null ? Collections.emptyList() : Collections.unmodifiableCollection(options);
        this.arguments = arguments;
        for (Option option : options) {
            this.optionNameToOption.put(option.getName(), option);
        }
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public Collection<Option> getOptions() {
        return this.options;
    }

    public String getOption(String name) {
        Option options = this.optionNameToOption.get(name);
        if (options == null || options.getValues().length == 0) {
            return null;
        }
        if (options.getValues().length == 1) {
            return options.getValues()[0];
        }
        return Arrays.stream(options.getValues()).reduce(String.valueOf(options.getValueSeparator()), String::concat);
    }

    public String[] getOptions(String name) {
        Option reqOption = this.optionNameToOption.get(name);
        return reqOption != null ? reqOption.getValues() : null;
    }

    public void printCommand(PrintStream ps, Class<?> callerClass) {
        ps.print("java " + callerClass.getName());
        for (String arg : this.args) {
            ps.print(" " + arg);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.mainClass.getName());
        if (this.args.length == 0) {
            return buffer.toString();
        }
        for (String arg : this.args) {
            buffer.append(' ').append(arg);
        }
        return buffer.toString();
    }
}

