/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class ForbiddenUsesRecipe
extends Recipe {
    @Option(displayName="Additional dangerous actions", description="Additional actions to flag as dangerous, beyond the built-in list. These will be merged with the default dangerous actions.", required=false, example="[\"some-org/dangerous-action@v1\", \"another-org/risky-action@v2\"]")
    private final @Nullable List<String> additionalDangerousActions;
    @Option(displayName="Additional suspicious patterns", description="Additional patterns to flag as suspicious, beyond the built-in patterns. These will be merged with the default suspicious patterns.", required=false, example="[\"malware\", \"crypto-miner\", \"backdoor\"]")
    private final @Nullable List<String> additionalSuspiciousPatterns;
    private static final Set<String> KNOWN_DANGEROUS_ACTIONS = new HashSet<String>(Arrays.asList("actions/checkout@v1", "actions/checkout@v2", "actions/setup-node@v1", "actions/setup-node@v2", "actions/cache@v1", "actions/cache@v2"));
    private static final Set<String> SUSPICIOUS_ACTION_PATTERNS = new HashSet<String>(Arrays.asList("run", "exec", "eval", "malicious-org/", "download-and-run", "execute-script"));
    private final Set<String> allDangerousActions;
    private final Set<String> allSuspiciousPatterns;

    public ForbiddenUsesRecipe() {
        this(null, null);
    }

    @JsonCreator
    public ForbiddenUsesRecipe(@Nullable List<String> additionalDangerousActions, @Nullable List<String> additionalSuspiciousPatterns) {
        this.additionalDangerousActions = additionalDangerousActions;
        this.additionalSuspiciousPatterns = additionalSuspiciousPatterns;
        this.allDangerousActions = new HashSet<String>(KNOWN_DANGEROUS_ACTIONS);
        if (additionalDangerousActions != null) {
            this.allDangerousActions.addAll(additionalDangerousActions);
        }
        this.allSuspiciousPatterns = new HashSet<String>(SUSPICIOUS_ACTION_PATTERNS);
        if (additionalSuspiciousPatterns != null) {
            this.allSuspiciousPatterns.addAll(additionalSuspiciousPatterns);
        }
    }

    public String getDisplayName() {
        return "Find forbidden action usage";
    }

    public String getDescription() {
        return "Find usage of forbidden or dangerous GitHub Actions that have known security vulnerabilities or follow suspicious patterns. Based on [zizmor's forbidden-uses audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/forbidden_uses.rs).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindSourceFiles(".github/workflows/*.yml"), (TreeVisitor)new ForbiddenUsesVisitor(this.allDangerousActions, this.allSuspiciousPatterns));
    }

    @Generated
    public @Nullable List<String> getAdditionalDangerousActions() {
        return this.additionalDangerousActions;
    }

    @Generated
    public @Nullable List<String> getAdditionalSuspiciousPatterns() {
        return this.additionalSuspiciousPatterns;
    }

    @Generated
    public Set<String> getAllDangerousActions() {
        return this.allDangerousActions;
    }

    @Generated
    public Set<String> getAllSuspiciousPatterns() {
        return this.allSuspiciousPatterns;
    }

    @Generated
    public String toString() {
        return "ForbiddenUsesRecipe(additionalDangerousActions=" + this.getAdditionalDangerousActions() + ", additionalSuspiciousPatterns=" + this.getAdditionalSuspiciousPatterns() + ", allDangerousActions=" + this.getAllDangerousActions() + ", allSuspiciousPatterns=" + this.getAllSuspiciousPatterns() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ForbiddenUsesRecipe)) {
            return false;
        }
        ForbiddenUsesRecipe other = (ForbiddenUsesRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List<String> this$additionalDangerousActions = this.getAdditionalDangerousActions();
        List<String> other$additionalDangerousActions = other.getAdditionalDangerousActions();
        if (this$additionalDangerousActions == null ? other$additionalDangerousActions != null : !((Object)this$additionalDangerousActions).equals(other$additionalDangerousActions)) {
            return false;
        }
        List<String> this$additionalSuspiciousPatterns = this.getAdditionalSuspiciousPatterns();
        List<String> other$additionalSuspiciousPatterns = other.getAdditionalSuspiciousPatterns();
        if (this$additionalSuspiciousPatterns == null ? other$additionalSuspiciousPatterns != null : !((Object)this$additionalSuspiciousPatterns).equals(other$additionalSuspiciousPatterns)) {
            return false;
        }
        Set<String> this$allDangerousActions = this.getAllDangerousActions();
        Set<String> other$allDangerousActions = other.getAllDangerousActions();
        if (this$allDangerousActions == null ? other$allDangerousActions != null : !((Object)this$allDangerousActions).equals(other$allDangerousActions)) {
            return false;
        }
        Set<String> this$allSuspiciousPatterns = this.getAllSuspiciousPatterns();
        Set<String> other$allSuspiciousPatterns = other.getAllSuspiciousPatterns();
        return !(this$allSuspiciousPatterns == null ? other$allSuspiciousPatterns != null : !((Object)this$allSuspiciousPatterns).equals(other$allSuspiciousPatterns));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ForbiddenUsesRecipe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $additionalDangerousActions = this.getAdditionalDangerousActions();
        result = result * 59 + ($additionalDangerousActions == null ? 43 : ((Object)$additionalDangerousActions).hashCode());
        List<String> $additionalSuspiciousPatterns = this.getAdditionalSuspiciousPatterns();
        result = result * 59 + ($additionalSuspiciousPatterns == null ? 43 : ((Object)$additionalSuspiciousPatterns).hashCode());
        Set<String> $allDangerousActions = this.getAllDangerousActions();
        result = result * 59 + ($allDangerousActions == null ? 43 : ((Object)$allDangerousActions).hashCode());
        Set<String> $allSuspiciousPatterns = this.getAllSuspiciousPatterns();
        result = result * 59 + ($allSuspiciousPatterns == null ? 43 : ((Object)$allSuspiciousPatterns).hashCode());
        return result;
    }

    private static class ForbiddenUsesVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private final Set<String> dangerousActions;
        private final Set<String> suspiciousPatterns;

        public ForbiddenUsesVisitor(Set<String> dangerousActions, Set<String> suspiciousPatterns) {
            this.dangerousActions = dangerousActions;
            this.suspiciousPatterns = suspiciousPatterns;
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            String violation;
            String usesValue;
            Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
            if (this.isUsesEntry(mappingEntry) && (usesValue = this.getUsesValue(mappingEntry)) != null && (violation = this.checkForForbiddenAction(usesValue)) != null) {
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)mappingEntry, (String)violation);
            }
            return mappingEntry;
        }

        private boolean isUsesEntry(Yaml.Mapping.Entry entry) {
            return entry.getKey() instanceof Yaml.Scalar && "uses".equals(((Yaml.Scalar)entry.getKey()).getValue());
        }

        private @Nullable String getUsesValue(Yaml.Mapping.Entry entry) {
            if (entry.getValue() instanceof Yaml.Scalar) {
                return ((Yaml.Scalar)entry.getValue()).getValue();
            }
            return null;
        }

        private @Nullable String checkForForbiddenAction(String usesValue) {
            String owner;
            String[] stringArray;
            if (usesValue.startsWith("./") || usesValue.startsWith("docker://")) {
                return null;
            }
            for (String string : this.dangerousActions) {
                if (!usesValue.equals(string)) continue;
                return "Action '" + usesValue + "' is known to have security vulnerabilities. Consider upgrading to a more recent version or using an alternative.";
            }
            String longestMatch = null;
            for (String pattern : this.suspiciousPatterns) {
                if (!usesValue.toLowerCase().contains(pattern.toLowerCase()) || longestMatch != null && pattern.length() <= longestMatch.length()) continue;
                longestMatch = pattern;
            }
            if (longestMatch != null) {
                return "Action '" + usesValue + "' contains suspicious pattern '" + longestMatch + "'. Review this action carefully for potential security risks.";
            }
            if (usesValue.contains("/") && !usesValue.startsWith("actions/") && (stringArray = usesValue.split("/", 2)).length == 2 && (owner = stringArray[0]).length() == 1) {
                return "Action '" + usesValue + "' is from a single-character organization '" + owner + "' which may be suspicious. Verify the action's authenticity.";
            }
            return null;
        }
    }
}

