/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.dependencies;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.UpgradeDependencyVersion;
import org.openrewrite.maven.UpgradeDependencyVersion;

public class UpgradeDependencyVersion
extends ScanningRecipe<Accumulator> {
    @Option(displayName="Group ID", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact ID", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    private final String artifactId;
    @Option(displayName="New version", description="An exact version number or node-style semver selector used to select the version number. ", example="29.X")
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    private final @Nullable String versionPattern;
    @Option(displayName="Override managed version", description="For Maven project only, This flag can be set to explicitly override a managed dependency's version. The default for this flag is `false`.", required=false)
    private final @Nullable Boolean overrideManagedVersion;
    @Option(displayName="Retain versions", description="For Maven project only, accepts a list of GAVs. For each GAV, if it is a project direct dependency, and it is removed from dependency management after the changes from this recipe, then it will be retained with an explicit version. The version can be omitted from the GAV to use the old value from dependency management.", example="com.jcraft:jsch", required=false)
    private final @Nullable List<String> retainVersions;

    public String getDisplayName() {
        return "Upgrade Gradle or Maven dependency versions";
    }

    public String getDescription() {
        return "For Gradle projects, upgrade the version of a dependency in a `build.gradle` file. Supports updating dependency declarations of various forms:\n * `String` notation: `\"group:artifact:version\"` \n * `Map` notation: `group: 'group', name: 'artifact', version: 'version'`\nIt is possible to update version numbers which are defined earlier in the same file in variable declarations.\n\nFor Maven projects, upgrade the version of a dependency by specifying a group ID and (optionally) an artifact ID using Node Semver advanced range selectors, allowing more precise control over version updates to patch or minor releases.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator(this.getUpgradeMavenDependencyVersion().getInitialValue(ctx), this.getUpgradeGradleDependencyVersion().getInitialValue(ctx));
    }

    public TreeVisitor<?, ExecutionContext> getScanner(Accumulator acc) {
        final TreeVisitor mavenScanner = this.getUpgradeMavenDependencyVersion().getScanner(acc.mavenAccumulator);
        final TreeVisitor gradleScanner = this.getUpgradeGradleDependencyVersion().getScanner(acc.gradleAccumulator);
        return new TreeVisitor<Tree, ExecutionContext>(){

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                return mavenScanner.isAcceptable(sourceFile, (Object)ctx) || gradleScanner.isAcceptable(sourceFile, (Object)ctx);
            }

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (mavenScanner.isAcceptable((SourceFile)Objects.requireNonNull(tree), (Object)ctx)) {
                    return mavenScanner.visit(tree, (Object)ctx);
                }
                if (gradleScanner.isAcceptable((SourceFile)tree, (Object)ctx)) {
                    return gradleScanner.visit(tree, (Object)ctx);
                }
                return tree;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(Accumulator acc) {
        final TreeVisitor mavenVisitor = this.getUpgradeMavenDependencyVersion().getVisitor(acc.mavenAccumulator);
        final TreeVisitor gradleVisitor = this.getUpgradeGradleDependencyVersion().getVisitor(acc.gradleAccumulator);
        return new TreeVisitor<Tree, ExecutionContext>(){

            public boolean isAcceptable(SourceFile sourceFile, ExecutionContext ctx) {
                return mavenVisitor.isAcceptable(sourceFile, (Object)ctx) || gradleVisitor.isAcceptable(sourceFile, (Object)ctx);
            }

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                Tree t = tree;
                assert (tree != null);
                if (mavenVisitor.isAcceptable((SourceFile)tree, (Object)ctx)) {
                    t = mavenVisitor.visit(tree, (Object)ctx);
                } else if (gradleVisitor.isAcceptable((SourceFile)tree, (Object)ctx)) {
                    t = gradleVisitor.visit(t, (Object)ctx);
                }
                return t;
            }
        };
    }

    org.openrewrite.maven.UpgradeDependencyVersion getUpgradeMavenDependencyVersion() {
        return new org.openrewrite.maven.UpgradeDependencyVersion(this.groupId, this.artifactId, this.newVersion, this.versionPattern, this.overrideManagedVersion, this.retainVersions);
    }

    public org.openrewrite.gradle.UpgradeDependencyVersion getUpgradeGradleDependencyVersion() {
        return new org.openrewrite.gradle.UpgradeDependencyVersion(this.groupId, this.artifactId, this.newVersion, this.versionPattern);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeDependencyVersion)) {
            return false;
        }
        UpgradeDependencyVersion other = (UpgradeDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$overrideManagedVersion = this.getOverrideManagedVersion();
        Boolean other$overrideManagedVersion = other.getOverrideManagedVersion();
        if (this$overrideManagedVersion == null ? other$overrideManagedVersion != null : !((Object)this$overrideManagedVersion).equals(other$overrideManagedVersion)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        if (this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern)) {
            return false;
        }
        List<String> this$retainVersions = this.getRetainVersions();
        List<String> other$retainVersions = other.getRetainVersions();
        return !(this$retainVersions == null ? other$retainVersions != null : !((Object)this$retainVersions).equals(other$retainVersions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UpgradeDependencyVersion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $overrideManagedVersion = this.getOverrideManagedVersion();
        result = result * 59 + ($overrideManagedVersion == null ? 43 : ((Object)$overrideManagedVersion).hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        List<String> $retainVersions = this.getRetainVersions();
        result = result * 59 + ($retainVersions == null ? 43 : ((Object)$retainVersions).hashCode());
        return result;
    }

    @Generated
    public String getGroupId() {
        return this.groupId;
    }

    @Generated
    public String getArtifactId() {
        return this.artifactId;
    }

    @Generated
    public String getNewVersion() {
        return this.newVersion;
    }

    @Generated
    public @Nullable String getVersionPattern() {
        return this.versionPattern;
    }

    @Generated
    public @Nullable Boolean getOverrideManagedVersion() {
        return this.overrideManagedVersion;
    }

    @Generated
    public @Nullable List<String> getRetainVersions() {
        return this.retainVersions;
    }

    @ConstructorProperties(value={"groupId", "artifactId", "newVersion", "versionPattern", "overrideManagedVersion", "retainVersions"})
    @Generated
    public UpgradeDependencyVersion(String groupId, String artifactId, String newVersion, @Nullable String versionPattern, @Nullable Boolean overrideManagedVersion, @Nullable List<String> retainVersions) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
        this.overrideManagedVersion = overrideManagedVersion;
        this.retainVersions = retainVersions;
    }

    public static final class Accumulator {
        private final UpgradeDependencyVersion.Accumulator mavenAccumulator;
        private final UpgradeDependencyVersion.DependencyVersionState gradleAccumulator;

        @ConstructorProperties(value={"mavenAccumulator", "gradleAccumulator"})
        @Generated
        public Accumulator(UpgradeDependencyVersion.Accumulator mavenAccumulator, UpgradeDependencyVersion.DependencyVersionState gradleAccumulator) {
            this.mavenAccumulator = mavenAccumulator;
            this.gradleAccumulator = gradleAccumulator;
        }

        @Generated
        public UpgradeDependencyVersion.Accumulator getMavenAccumulator() {
            return this.mavenAccumulator;
        }

        @Generated
        public UpgradeDependencyVersion.DependencyVersionState getGradleAccumulator() {
            return this.gradleAccumulator;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            UpgradeDependencyVersion.Accumulator this$mavenAccumulator = this.getMavenAccumulator();
            UpgradeDependencyVersion.Accumulator other$mavenAccumulator = other.getMavenAccumulator();
            if (this$mavenAccumulator == null ? other$mavenAccumulator != null : !this$mavenAccumulator.equals(other$mavenAccumulator)) {
                return false;
            }
            UpgradeDependencyVersion.DependencyVersionState this$gradleAccumulator = this.getGradleAccumulator();
            UpgradeDependencyVersion.DependencyVersionState other$gradleAccumulator = other.getGradleAccumulator();
            return !(this$gradleAccumulator == null ? other$gradleAccumulator != null : !this$gradleAccumulator.equals(other$gradleAccumulator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UpgradeDependencyVersion.Accumulator $mavenAccumulator = this.getMavenAccumulator();
            result = result * 59 + ($mavenAccumulator == null ? 43 : $mavenAccumulator.hashCode());
            UpgradeDependencyVersion.DependencyVersionState $gradleAccumulator = this.getGradleAccumulator();
            result = result * 59 + ($gradleAccumulator == null ? 43 : $gradleAccumulator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UpgradeDependencyVersion.Accumulator(mavenAccumulator=" + this.getMavenAccumulator() + ", gradleAccumulator=" + this.getGradleAccumulator() + ")";
        }
    }
}

