/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class NoGuavaFunctionsCompose
extends Recipe {
    private static final MethodMatcher FUNCTIONS_COMPOSE = new MethodMatcher("com.google.common.base.Functions compose(com.google.common.base.Function, com.google.common.base.Function)");

    public String getDisplayName() {
        return "Prefer `Function.compose(Function)`";
    }

    public String getDescription() {
        return "Prefer `Function.compose(Function)` over `Functions.compose(Function, Function)`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("guava");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(FUNCTIONS_COMPOSE), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (FUNCTIONS_COMPOSE.matches((MethodCall)method)) {
                    this.maybeRemoveImport("com.google.common.base.Function");
                    this.maybeRemoveImport("com.google.common.base.Functions");
                    this.maybeAddImport("java.util.function.Function");
                    return (J.MethodInvocation)JavaTemplate.builder((String)"#{any(java.util.function.Function)}.compose(#{any(java.util.function.Function)})").build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getArguments().get(0), method.getArguments().get(1)});
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }
}

