/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class NoGuavaMapsNewHashMap
extends Recipe {
    private static final MethodMatcher NEW_HASH_MAP = new MethodMatcher("com.google.common.collect.Maps newHashMap()");
    private static final MethodMatcher NEW_HASH_MAP_WITH_MAP = new MethodMatcher("com.google.common.collect.Maps newHashMap(java.util.Map)");

    public String getDisplayName() {
        return "Prefer `new HashMap<>()`";
    }

    public String getDescription() {
        return "Prefer the Java standard library over third-party usage of Guava in simple cases like this.";
    }

    public Set<String> getTags() {
        return Collections.singleton("guava");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(NEW_HASH_MAP), new UsesMethod(NEW_HASH_MAP_WITH_MAP)}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (NEW_HASH_MAP.matches((MethodCall)method)) {
                    this.maybeRemoveImport("com.google.common.collect.Maps");
                    this.maybeAddImport("java.util.HashMap");
                    return JavaTemplate.builder((String)"new HashMap<>()").contextSensitive().imports(new String[]{"java.util.HashMap"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[0]);
                }
                if (NEW_HASH_MAP_WITH_MAP.matches((MethodCall)method)) {
                    this.maybeRemoveImport("com.google.common.collect.Maps");
                    this.maybeAddImport("java.util.HashMap");
                    return JavaTemplate.builder((String)"new HashMap<>(#{any(java.util.Map)})").contextSensitive().imports(new String[]{"java.util.HashMap"}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getArguments().get(0)});
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }
}

