/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.SearchResult;

public class NoGuavaPredicate
extends Recipe {
    public String getDisplayName() {
        return "Change Guava's `Predicate` into `java.util.function.Predicate` where possible";
    }

    public String getDescription() {
        return "Change the type only where no methods are used that explicitly require a Guava `Predicate`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.not(new UsesPredicateMethod()), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J preVisit(J java, ExecutionContext ctx) {
                J j = (J)new ChangeMethodName("com.google.common.base.Predicate apply(..)", "test", Boolean.valueOf(true), Boolean.valueOf(false)).getVisitor().visitNonNull((Tree)java, (Object)ctx, this.getCursor().getParentOrThrow());
                return (J)new ChangeType("com.google.common.base.Predicate", "java.util.function.Predicate", Boolean.valueOf(false)).getVisitor().visitNonNull((Tree)j, (Object)ctx, this.getCursor().getParentOrThrow());
            }
        });
    }

    private static class UsesPredicateMethod<P>
    extends JavaIsoVisitor<P> {
        private static final MethodMatcher PREDICATE_METHOD_MATCHER = new MethodMatcher("*..* *(.., com.google.common.base.Predicate)");
        private static final MethodMatcher NOT_MATCHER = new MethodMatcher("*..* not(com.google.common.base.Predicate)");

        private UsesPredicateMethod() {
        }

        public J preVisit(J tree, P p) {
            this.stopAfterPreVisit();
            if (tree instanceof JavaSourceFile) {
                JavaSourceFile cu = (JavaSourceFile)tree;
                for (JavaType.Method type : cu.getTypesInUse().getUsedMethods()) {
                    if (!PREDICATE_METHOD_MATCHER.matches(type) || NOT_MATCHER.matches(type)) continue;
                    return (J)SearchResult.found((Tree)cu);
                }
            }
            return tree;
        }
    }
}

