/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.migrate.guava.PreferJavaStringJoinVisitor;
import org.openrewrite.java.search.UsesMethod;

public class PreferJavaStringJoin
extends Recipe {
    static final MethodMatcher JOIN_METHOD_MATCHER = new MethodMatcher("com.google.common.base.Joiner join(..)");

    public String getDisplayName() {
        return "Prefer `String#join()` over Guava `Joiner#join()`";
    }

    public String getDescription() {
        return "Replaces supported calls to `com.google.common.base.Joiner#join()` with `java.lang.String#join()`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("guava");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(JOIN_METHOD_MATCHER), (TreeVisitor)new PreferJavaStringJoinVisitor());
    }
}

