/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang;

import com.google.errorprone.refaster.Refaster;
import org.openrewrite.java.template.RecipeDescriptor;

@RecipeDescriptor(name="A collection of `String` rules", description="A collection of rules for refactoring methods called on `String` instances in Java code.")
public class StringRules {

    @RecipeDescriptor(name="Replace lower and upper case `String` comparisons with `String.equalsIgnoreCase(String)`", description="Replace `String` equality comparisons involving `.toLowerCase()` or `.toUpperCase()` with `String.equalsIgnoreCase(String anotherString)`.")
    public static class UseEqualsIgnoreCase {
        public boolean bothLowerCase(String string, String test) {
            return string.toLowerCase().equals(test.toLowerCase());
        }

        public boolean bothUpperCase(String string, String test) {
            return string.toUpperCase().equals(test.toUpperCase());
        }

        public boolean equalsIgnoreCase(String string, String test) {
            return string.equalsIgnoreCase(test);
        }
    }

    @RecipeDescriptor(name="Replace `String.indexOf(char, 0)` with `String.indexOf(char)`", description="Replace `String.indexOf(char ch, int fromIndex)` with `String.indexOf(char)`.")
    public static class IndexOfChar {
        public int indexOfZero(String string, char test) {
            return string.indexOf(test, 0);
        }

        public int indexOf(String string, char test) {
            return string.indexOf(test);
        }
    }

    @RecipeDescriptor(name="Replace `String.indexOf(String, 0)` with `String.indexOf(String)`", description="Replace `String.indexOf(String str, int fromIndex)` with `String.indexOf(String)`.")
    public static class IndexOfString {
        public int indexOfZero(String string, String test) {
            return string.indexOf(test, 0);
        }

        public int indexOf(String string, String test) {
            return string.indexOf(test);
        }
    }

    @RecipeDescriptor(name="Replace redundant `String` method calls with self", description="Replace redundant `substring(..)` and `toString()` method calls with the `String` self.")
    public static class RedundantCall {
        public String before(String string) {
            return (String)Refaster.anyOf((Object[])new String[]{string.substring(0, string.length()), string.substring(0), string.toString()});
        }

        public String after(String string) {
            return string;
        }
    }
}

