/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang.var;

import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.migrate.lang.var.DeclarationCheck;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;

public class UseVarForGenericsConstructors
extends Recipe {
    public String getDisplayName() {
        return "Apply `var` to Generic Constructors";
    }

    public String getDescription() {
        return "Apply `var` to generics variables initialized by constructor calls.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesJavaVersion(10), (TreeVisitor)new UseVarForGenericsConstructorsVisitor());
    }

    static final class UseVarForGenericsConstructorsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        UseVarForGenericsConstructorsVisitor() {
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations vd, ExecutionContext ctx) {
            vd = super.visitVariableDeclarations(vd, (Object)ctx);
            boolean isGeneralApplicable = DeclarationCheck.isVarApplicable(this.getCursor(), vd);
            if (!isGeneralApplicable) {
                return vd;
            }
            boolean isPrimitive = DeclarationCheck.isPrimitive(vd);
            boolean usesNoGenerics = !DeclarationCheck.useGenerics(vd);
            boolean usesTernary = DeclarationCheck.initializedByTernary(vd);
            if (isPrimitive || usesTernary || usesNoGenerics) {
                return vd;
            }
            J.VariableDeclarations.NamedVariable variable = (J.VariableDeclarations.NamedVariable)vd.getVariables().get(0);
            List<JavaType> leftTypes = this.extractTypeParameters(variable.getVariableType());
            List<JavaType> rightTypes = this.extractTypeParameters(variable.getInitializer());
            if (rightTypes == null || leftTypes.isEmpty() && rightTypes.isEmpty()) {
                return vd;
            }
            boolean genericHasBounds = UseVarForGenericsConstructorsVisitor.anyTypeHasBounds(leftTypes);
            if (genericHasBounds) {
                return vd;
            }
            if (vd.getType() instanceof JavaType.FullyQualified) {
                this.maybeRemoveImport((JavaType.FullyQualified)vd.getType());
            }
            J.VariableDeclarations finalVd = vd;
            return DeclarationCheck.transformToVar(vd, it -> {
                if (rightTypes.isEmpty() && !leftTypes.isEmpty() && finalVd.getTypeExpression() instanceof J.ParameterizedType && it.getClazz() instanceof J.ParameterizedType) {
                    J.ParameterizedType typedInitializerClazz = ((J.ParameterizedType)it.getClazz()).withTypeParameters(((J.ParameterizedType)finalVd.getTypeExpression()).getTypeParameters());
                    return it.withClazz((TypeTree)typedInitializerClazz);
                }
                return it;
            });
        }

        private static Boolean anyTypeHasBounds(List<JavaType> leftTypes) {
            for (JavaType type : leftTypes) {
                if (type instanceof JavaType.Parameterized) {
                    return UseVarForGenericsConstructorsVisitor.anyTypeHasBounds(((JavaType.Parameterized)type).getTypeParameters());
                }
                if (!(type instanceof JavaType.GenericTypeVariable)) continue;
                return !((JavaType.GenericTypeVariable)type).getBounds().isEmpty();
            }
            return false;
        }

        private @Nullable List<JavaType> extractTypeParameters(@Nullable Expression initializer) {
            TypeTree clazz;
            if (initializer instanceof J.NewClass && (clazz = ((J.NewClass)initializer).getClazz()) instanceof J.ParameterizedType) {
                List typeParameters = ((J.ParameterizedType)clazz).getTypeParameters();
                ArrayList<JavaType> params = new ArrayList<JavaType>();
                if (typeParameters != null) {
                    for (Expression curType : typeParameters) {
                        JavaType type = curType.getType();
                        if (type == null) continue;
                        params.add(type);
                    }
                }
                return params;
            }
            return null;
        }

        private List<JavaType> extractTypeParameters(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable JavaType.Variable variable) {
            if (variable != null && variable.getType() instanceof JavaType.Parameterized) {
                return ((JavaType.Parameterized)variable.getType()).getTypeParameters();
            }
            return new ArrayList<JavaType>();
        }
    }
}

