/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lombok;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.ChangeMethodName;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.migrate.lombok.LombokUtils;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public final class AdoptLombokGetterMethodNames
extends ScanningRecipe<List<RenameRecord>> {
    private static final String DO_NOT_RENAME = "DO_NOT_RENAME";

    public String getDisplayName() {
        return "Rename getter methods to fit Lombok";
    }

    public String getDescription() {
        return "Rename methods that are effectively getter to the name Lombok would give them.\n\nLimitations:\n - If two methods in a class are effectively the same getter then one's name will be corrected and the others name will be left as it is.\n - If the correct name for a method is already taken by another method then the name will not be corrected.\n - Method name swaps or circular renaming within a class cannot be performed because the names block each other.\nE.g. `int getFoo() { return ba; } int getBa() { return foo; }` stays as it is.";
    }

    public List<RenameRecord> getInitialValue(ExecutionContext ctx) {
        return new ArrayList<RenameRecord>();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final List<RenameRecord> renameRecords) {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                Set declaredMethods = cu.getTypesInUse().getDeclaredMethods();
                ArrayList<String> existingMethodNames = new ArrayList<String>();
                for (JavaType.Method method : declaredMethods) {
                    existingMethodNames.add(method.getName());
                }
                this.getCursor().putMessage(AdoptLombokGetterMethodNames.DO_NOT_RENAME, existingMethodNames);
                return super.visitCompilationUnit(cu, (Object)ctx);
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                String simpleName;
                if (method.getMethodType() == null || method.getBody() == null || !LombokUtils.isEffectivelyGetter(method) || TypeUtils.isOverride((JavaType.Method)method.getMethodType())) {
                    return method;
                }
                Expression returnExpression = ((J.Return)method.getBody().getStatements().get(0)).getExpression();
                if (returnExpression instanceof J.Identifier) {
                    simpleName = ((J.Identifier)returnExpression).getSimpleName();
                } else if (returnExpression instanceof J.FieldAccess) {
                    simpleName = ((J.FieldAccess)returnExpression).getSimpleName();
                } else {
                    return method;
                }
                String expectedMethodName = LombokUtils.deriveGetterMethodName(returnExpression.getType(), simpleName);
                if (expectedMethodName.equals(method.getSimpleName())) {
                    return method;
                }
                List doNotRename = (List)this.getCursor().getNearestMessage(AdoptLombokGetterMethodNames.DO_NOT_RENAME);
                assert (doNotRename != null);
                if (doNotRename.contains(expectedMethodName)) {
                    return method;
                }
                renameRecords.add(new RenameRecord(MethodMatcher.methodPattern((J.MethodDeclaration)method), expectedMethodName));
                doNotRename.remove(method.getSimpleName());
                doNotRename.add(expectedMethodName);
                return method;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(final List<RenameRecord> renameRecords) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                for (RenameRecord rr : renameRecords) {
                    tree = new ChangeMethodName(rr.methodPattern, rr.newMethodName, Boolean.valueOf(true), null).getVisitor().visit(tree, (Object)ctx);
                }
                return tree;
            }
        };
    }

    @Generated
    public AdoptLombokGetterMethodNames() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "AdoptLombokGetterMethodNames()";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdoptLombokGetterMethodNames)) {
            return false;
        }
        AdoptLombokGetterMethodNames other = (AdoptLombokGetterMethodNames)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AdoptLombokGetterMethodNames;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public static final class RenameRecord {
        private final String methodPattern;
        private final String newMethodName;

        @ConstructorProperties(value={"methodPattern", "newMethodName"})
        @Generated
        public RenameRecord(String methodPattern, String newMethodName) {
            this.methodPattern = methodPattern;
            this.newMethodName = newMethodName;
        }

        @Generated
        public String getMethodPattern() {
            return this.methodPattern;
        }

        @Generated
        public String getNewMethodName() {
            return this.newMethodName;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RenameRecord)) {
                return false;
            }
            RenameRecord other = (RenameRecord)o;
            String this$methodPattern = this.getMethodPattern();
            String other$methodPattern = other.getMethodPattern();
            if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
                return false;
            }
            String this$newMethodName = this.getNewMethodName();
            String other$newMethodName = other.getNewMethodName();
            return !(this$newMethodName == null ? other$newMethodName != null : !this$newMethodName.equals(other$newMethodName));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $methodPattern = this.getMethodPattern();
            result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
            String $newMethodName = this.getNewMethodName();
            result = result * 59 + ($newMethodName == null ? 43 : $newMethodName.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "AdoptLombokGetterMethodNames.RenameRecord(methodPattern=" + this.getMethodPattern() + ", newMethodName=" + this.getNewMethodName() + ")";
        }
    }
}

