/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.net;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class MigrateMulticastSocketSetTTLToSetTimeToLive
extends Recipe {
    private static final MethodMatcher MATCHER = new MethodMatcher("java.net.MulticastSocket setTTL(byte)");

    public String getDisplayName() {
        return "Use `java.net.MulticastSocket#setTimeToLive(int)`";
    }

    public String getDescription() {
        return "Use `java.net.MulticastSocket#setTimeToLive(int)` instead of the deprecated `java.net.MulticastSocket#setTTL(byte)` in Java 1.2 or higher.";
    }

    public Set<String> getTags() {
        return Collections.singleton("deprecated");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = method;
                if (MATCHER.matches((MethodCall)m)) {
                    m = m.withName(m.getName().withSimpleName("setTimeToLive"));
                    m = (J.MethodInvocation)JavaTemplate.builder((String)"Byte.valueOf(#{any(byte)}).intValue()").build().apply(this.updateCursor((Tree)m), m.getCoordinates().replaceArguments(), new Object[]{m.getArguments().get(0)});
                }
                return super.visitMethodInvocation(m, (Object)ctx);
            }
        });
    }
}

