/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.util;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class MigrateCollectionsUnmodifiableList
extends Recipe {
    private static final MethodMatcher UNMODIFIABLE_LIST = new MethodMatcher("java.util.Collections unmodifiableList(java.util.List)", true);
    private static final MethodMatcher ARRAYS_AS_LIST = new MethodMatcher("java.util.Arrays asList(..)", true);

    public String getDisplayName() {
        return "Prefer `List.of(..)`";
    }

    public String getDescription() {
        return "Prefer `List.Of(..)` instead of using `unmodifiableList(java.util.Arrays asList(<args>))` in Java 9 or higher.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor check = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesJavaVersion(9), new UsesMethod(UNMODIFIABLE_LIST)});
        return Preconditions.check((TreeVisitor)check, (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (UNMODIFIABLE_LIST.matches((MethodCall)method) && m.getArguments().get(0) instanceof J.MethodInvocation && ARRAYS_AS_LIST.matches((MethodCall)((J.MethodInvocation)m.getArguments().get(0)))) {
                    J.MethodInvocation arraysInvocation = (J.MethodInvocation)m.getArguments().get(0);
                    this.maybeRemoveImport("java.util.Collections");
                    this.maybeRemoveImport("java.util.Arrays");
                    this.maybeAddImport("java.util.List");
                    J.MethodInvocation listOf = (J.MethodInvocation)JavaTemplate.builder((String)"List.of()").imports(new String[]{"java.util.List"}).build().apply(this.updateCursor((Tree)m), m.getCoordinates().replace(), new Object[0]);
                    return listOf.withArguments(arraysInvocation.getArguments()).getPadding().withArguments(arraysInvocation.getPadding().getArguments());
                }
                return m;
            }
        });
    }
}

