/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.jmockit;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.ShortenFullyQualifiedTypeReferences;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.testing.jmockit.JMockitUtils;
import org.openrewrite.java.testing.mockito.MockitoUtils;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.staticanalysis.LambdaBlockToExpression;
import org.openrewrite.staticanalysis.VariableReferences;

public class JMockitMockUpToMockito
extends Recipe {
    private static final String JMOCKIT_MOCKUP_IMPORT = "mockit.MockUp";
    private static final String JMOCKIT_MOCK_IMPORT = "mockit.Mock";
    private static final String MOCKITO_MATCHER_IMPORT = "org.mockito.ArgumentMatchers.*";
    private static final String MOCKITO_DELEGATEANSWER_IMPORT = "org.mockito.AdditionalAnswers.delegatesTo";
    private static final String MOCKITO_STATIC_PREFIX = "mockStatic";
    private static final String MOCKITO_STATIC_IMPORT = "org.mockito.MockedStatic";
    private static final String MOCKITO_MOCK_PREFIX = "mock";
    private static final String MOCKITO_CONSTRUCTION_PREFIX = "mockCons";
    private static final String MOCKITO_CONSTRUCTION_IMPORT = "org.mockito.MockedConstruction";

    public String getDisplayName() {
        return "Rewrite JMockit MockUp to Mockito statements";
    }

    public String getDescription() {
        return "Rewrites JMockit `MockUp` blocks to Mockito statements. This recipe will not rewrite private methods in MockUp.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(JMOCKIT_MOCKUP_IMPORT, Boolean.valueOf(false)), (TreeVisitor)new JMockitMockUpToMockitoVisitor());
    }

    private static class JMockitMockUpToMockitoVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final Map<String, J.Identifier> tearDownMocks = new HashMap<String, J.Identifier>();

        private JMockitMockUpToMockitoVisitor() {
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            Set<J.MethodDeclaration> mds = ((HashSet)TreeVisitor.collect((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration md, ExecutionContext ctx) {
                    if (this.isSetUpMethod(md)) {
                        return (J.MethodDeclaration)SearchResult.found((Tree)md);
                    }
                    return super.visitMethodDeclaration(md, (Object)ctx);
                }
            }, (Tree)classDecl, new HashSet())).stream().filter(J.MethodDeclaration.class::isInstance).map(J.MethodDeclaration.class::cast).collect(Collectors.toSet());
            if (mds.isEmpty()) {
                return super.visitClassDeclaration(classDecl, (Object)ctx);
            }
            AtomicReference<J.ClassDeclaration> cdRef = new AtomicReference<J.ClassDeclaration>(classDecl);
            mds.forEach(md -> md.getBody().getStatements().stream().filter(this::isMockUpStatement).map(J.NewClass.class::cast).forEach(newClass -> {
                J.Identifier mockFieldId;
                J.VariableDeclarations mockField;
                String className = ((Expression)((J.ParameterizedType)newClass.getClazz()).getTypeParameters().get(0)).toString();
                Map<J.MethodDeclaration, JavaType.Method> mockedMethods = this.getMockUpMethods((J.NewClass)newClass);
                if (mockedMethods.values().stream().anyMatch(m -> m.getFlags().contains(Flag.Static))) {
                    cdRef.set((J.ClassDeclaration)JavaTemplate.builder((String)"private MockedStatic #{};").contextSensitive().javaParser(JMockitUtils.getJavaParser(ctx)).imports(new String[]{JMockitMockUpToMockito.MOCKITO_STATIC_IMPORT}).staticImports(new String[]{"org.mockito.Mockito.*"}).build().apply(new Cursor(this.getCursor().getParentOrThrow(), cdRef.get()), ((J.ClassDeclaration)cdRef.get()).getBody().getCoordinates().firstStatement(), new Object[]{JMockitMockUpToMockito.MOCKITO_STATIC_PREFIX + className}));
                    mockField = (J.VariableDeclarations)((J.ClassDeclaration)cdRef.get()).getBody().getStatements().get(0);
                    mockFieldId = ((J.VariableDeclarations.NamedVariable)mockField.getVariables().get(0)).getName();
                    this.tearDownMocks.put(JMockitMockUpToMockito.MOCKITO_STATIC_PREFIX + className, mockFieldId);
                }
                if (mockedMethods.values().stream().anyMatch(m -> !m.getFlags().contains(Flag.Static))) {
                    cdRef.set((J.ClassDeclaration)JavaTemplate.builder((String)"private MockedConstruction #{};").contextSensitive().javaParser(JMockitUtils.getJavaParser(ctx)).imports(new String[]{JMockitMockUpToMockito.MOCKITO_CONSTRUCTION_IMPORT}).staticImports(new String[]{"org.mockito.Mockito.*"}).build().apply(this.updateCursor((Tree)((J)cdRef.get())), ((J.ClassDeclaration)cdRef.get()).getBody().getCoordinates().firstStatement(), new Object[]{JMockitMockUpToMockito.MOCKITO_CONSTRUCTION_PREFIX + className}));
                    mockField = (J.VariableDeclarations)((J.ClassDeclaration)cdRef.get()).getBody().getStatements().get(0);
                    mockFieldId = ((J.VariableDeclarations.NamedVariable)mockField.getVariables().get(0)).getName();
                    this.tearDownMocks.put(JMockitMockUpToMockito.MOCKITO_CONSTRUCTION_PREFIX + className, mockFieldId);
                }
            }));
            J.ClassDeclaration cd = MockitoUtils.maybeAddMethodWithAnnotation((JavaVisitor)this, cdRef.get(), ctx, true, "tearDown", "@org.junit.After", "@After", "junit-4", "org.junit.After", "");
            return super.visitClassDeclaration(cd, (Object)ctx);
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDecl, ExecutionContext ctx) {
            J.MethodDeclaration md = methodDecl;
            if (md.getBody() == null) {
                return md;
            }
            if (this.isTearDownMethod(md)) {
                for (J.Identifier id : this.tearDownMocks.values()) {
                    md = (J.MethodDeclaration)JavaTemplate.builder((String)"#{any()}.closeOnDemand();").javaParser(JMockitUtils.getJavaParser(ctx)).imports(new String[]{JMockitMockUpToMockito.MOCKITO_STATIC_IMPORT, JMockitMockUpToMockito.MOCKITO_CONSTRUCTION_IMPORT}).staticImports(new String[]{"org.mockito.Mockito.*"}).build().apply(this.updateCursor((Tree)md), md.getBody().getCoordinates().lastStatement(), new Object[]{id});
                }
                return md;
            }
            boolean isBeforeTest = this.isSetUpMethod(md);
            ArrayList<String> varDeclarationInTry = new ArrayList<String>();
            ArrayList<String> mockStaticMethodInTry = new ArrayList<String>();
            ArrayList<String> mockConstructionMethodInTry = new ArrayList<String>();
            ArrayList<Statement> encloseStatements = new ArrayList<Statement>();
            ArrayList residualStatements = new ArrayList();
            for (Statement statement : md.getBody().getStatements()) {
                Map<J.MethodDeclaration, JavaType.Method> mockedPublicMethods;
                if (!this.isMockUpStatement((Tree)statement)) {
                    encloseStatements.add(statement);
                    continue;
                }
                J.NewClass newClass = (J.NewClass)statement;
                residualStatements.addAll(newClass.getBody().getStatements().stream().filter(s -> {
                    if (s instanceof J.MethodDeclaration) {
                        return ((J.MethodDeclaration)s).getLeadingAnnotations().stream().noneMatch(o -> TypeUtils.isOfClassType((JavaType)o.getType(), (String)JMockitMockUpToMockito.JMOCKIT_MOCK_IMPORT));
                    }
                    return true;
                }).collect(Collectors.toList()));
                JavaType mockType = ((Expression)((J.ParameterizedType)newClass.getClazz()).getTypeParameters().get(0)).getType();
                String className = ((Expression)((J.ParameterizedType)newClass.getClazz()).getTypeParameters().get(0)).toString();
                Map<J.MethodDeclaration, JavaType.Method> mockedMethods = this.getMockUpMethods(newClass);
                Map<J.MethodDeclaration, JavaType.Method> mockedPublicStaticMethods = mockedMethods.entrySet().stream().filter(m -> ((JavaType.Method)m.getValue()).getFlags().contains(Flag.Static)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                if (!mockedPublicStaticMethods.isEmpty()) {
                    if (isBeforeTest) {
                        String tpl = this.getMockStaticDeclarationInBefore(className) + this.getMockStaticMethods((JavaType.Class)mockType, className, mockedPublicStaticMethods);
                        md = (J.MethodDeclaration)JavaTemplate.builder((String)tpl).contextSensitive().javaParser(JMockitUtils.getJavaParser(ctx)).imports(new String[]{JMockitMockUpToMockito.MOCKITO_STATIC_IMPORT}).staticImports(new String[]{"org.mockito.Mockito.*"}).build().apply(this.updateCursor((Tree)md), statement.getCoordinates().after(), new Object[]{this.tearDownMocks.get(JMockitMockUpToMockito.MOCKITO_STATIC_PREFIX + className)});
                    } else {
                        varDeclarationInTry.add(this.getMockStaticDeclarationInTry(className));
                        mockStaticMethodInTry.add(this.getMockStaticMethods((JavaType.Class)mockType, className, mockedPublicStaticMethods));
                    }
                    this.maybeAddImport(JMockitMockUpToMockito.MOCKITO_STATIC_IMPORT);
                }
                if (!(mockedPublicMethods = mockedMethods.entrySet().stream().filter(m -> !((JavaType.Method)m.getValue()).getFlags().contains(Flag.Static)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).isEmpty()) {
                    if (isBeforeTest) {
                        String tpl = this.getMockConstructionMethods(className, mockedPublicMethods) + this.getMockConstructionDeclarationInBefore(className);
                        md = (J.MethodDeclaration)JavaTemplate.builder((String)tpl).contextSensitive().javaParser(JMockitUtils.getJavaParser(ctx)).imports(new String[]{JMockitMockUpToMockito.MOCKITO_STATIC_IMPORT}).staticImports(new String[]{"org.mockito.Mockito.*", JMockitMockUpToMockito.MOCKITO_DELEGATEANSWER_IMPORT}).build().apply(this.updateCursor((Tree)md), statement.getCoordinates().after(), new Object[]{this.tearDownMocks.get(JMockitMockUpToMockito.MOCKITO_CONSTRUCTION_PREFIX + className)});
                    } else {
                        varDeclarationInTry.add(this.getMockConstructionDeclarationInTry(className));
                        mockConstructionMethodInTry.add(this.getMockConstructionMethods(className, mockedPublicMethods));
                    }
                    this.maybeAddImport(JMockitMockUpToMockito.MOCKITO_CONSTRUCTION_IMPORT);
                    this.maybeAddImport("org.mockito.Answers", "CALLS_REAL_METHODS", false);
                    this.maybeAddImport("org.mockito.AdditionalAnswers", "delegatesTo", false);
                }
                List statements = md.getBody().getStatements();
                statements.remove(statement);
                md = md.withBody(md.getBody().withStatements(statements));
            }
            if (!varDeclarationInTry.isEmpty()) {
                String tpl = String.join((CharSequence)"", mockConstructionMethodInTry) + "try (" + String.join((CharSequence)";", varDeclarationInTry) + ") {" + String.join((CharSequence)";", mockStaticMethodInTry) + "}";
                J.MethodDeclaration residualMd = md.withBody(md.getBody().withStatements(residualStatements));
                residualMd = (J.MethodDeclaration)JavaTemplate.builder((String)tpl).contextSensitive().javaParser(JMockitUtils.getJavaParser(ctx)).imports(new String[]{JMockitMockUpToMockito.MOCKITO_STATIC_IMPORT, JMockitMockUpToMockito.MOCKITO_CONSTRUCTION_IMPORT}).staticImports(new String[]{"org.mockito.Mockito.*", JMockitMockUpToMockito.MOCKITO_MATCHER_IMPORT, JMockitMockUpToMockito.MOCKITO_MATCHER_IMPORT, JMockitMockUpToMockito.MOCKITO_DELEGATEANSWER_IMPORT}).build().apply(this.updateCursor((Tree)residualMd), residualMd.getBody().getCoordinates().lastStatement(), new Object[0]);
                List mdStatements = residualMd.getBody().getStatements();
                J.Try try_ = (J.Try)mdStatements.get(mdStatements.size() - 1);
                List tryStatements = try_.getBody().getStatements();
                tryStatements.addAll(encloseStatements);
                try_ = try_.withBody(try_.getBody().withStatements(tryStatements));
                mdStatements.set(mdStatements.size() - 1, try_);
                md = md.withBody(residualMd.getBody().withStatements(mdStatements));
            }
            this.maybeAddImport("org.mockito.Mockito.*".replace(".*", ""), "*", false);
            this.maybeRemoveImport(JMockitMockUpToMockito.JMOCKIT_MOCK_IMPORT);
            this.maybeRemoveImport(JMockitMockUpToMockito.JMOCKIT_MOCKUP_IMPORT);
            this.doAfterVisit(new LambdaBlockToExpression().getVisitor());
            this.doAfterVisit((TreeVisitor)ShortenFullyQualifiedTypeReferences.modifyOnly((J)md));
            return (J.MethodDeclaration)this.maybeAutoFormat((J)methodDecl, (J)md, ctx);
        }

        private String getMatcher(JavaType s) {
            this.maybeAddImport(JMockitMockUpToMockito.MOCKITO_MATCHER_IMPORT.replace(".*", ""), "*", false);
            if (s instanceof JavaType.Primitive) {
                switch (s.toString()) {
                    case "int": {
                        return "anyInt()";
                    }
                    case "long": {
                        return "anyLong()";
                    }
                    case "double": {
                        return "anyDouble()";
                    }
                    case "float": {
                        return "anyFloat()";
                    }
                    case "short": {
                        return "anyShort()";
                    }
                    case "byte": {
                        return "anyByte()";
                    }
                    case "char": {
                        return "anyChar()";
                    }
                    case "boolean": {
                        return "anyBoolean()";
                    }
                }
            } else if (s instanceof JavaType.Array) {
                String elem = TypeUtils.asArray((JavaType)s).getElemType().toString();
                return "nullable(" + elem + "[].class)";
            }
            return "nullable(" + TypeUtils.asFullyQualified((JavaType)s).getFullyQualifiedName() + ".class)";
        }

        private String getAnswerBody(J.MethodDeclaration md) {
            HashSet usedVariables = new HashSet();
            new JavaIsoVisitor<Set<String>>(){

                public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, Set<String> ctx) {
                    Cursor scope = this.getCursor().dropParentUntil(is -> is instanceof J.ClassDeclaration || is instanceof J.Block || is instanceof J.MethodDeclaration || is instanceof J.ForLoop || is instanceof J.ForEachLoop || is instanceof J.ForLoop.Control || is instanceof J.ForEachLoop.Control || is instanceof J.Case || is instanceof J.Try || is instanceof J.Try.Resource || is instanceof J.Try.Catch || is instanceof J.MultiCatch || is instanceof J.Lambda || is instanceof JavaSourceFile);
                    if (!VariableReferences.findRhsReferences((J)((J)scope.getValue()), (J.Identifier)variable.getName()).isEmpty()) {
                        ctx.add(variable.getSimpleName());
                    }
                    return super.visitVariable(variable, ctx);
                }
            }.visit((Tree)md, usedVariables);
            StringBuilder sb = new StringBuilder();
            List parameters = md.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                if (!(parameters.get(i) instanceof J.VariableDeclarations)) continue;
                J.VariableDeclarations vd = (J.VariableDeclarations)parameters.get(i);
                String className = vd.getType() instanceof JavaType.Primitive ? vd.getType().toString() : vd.getTypeAsFullyQualified().getClassName();
                String varName = ((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getName().getSimpleName();
                if (!usedVariables.contains(varName)) continue;
                sb.append(className).append(" ").append(varName).append(" = invocation.getArgument(").append(i).append(");");
            }
            boolean hasReturn = false;
            for (Statement s : md.getBody().getStatements()) {
                hasReturn |= s instanceof J.Return;
                sb.append(s.print(this.getCursor())).append(";");
            }
            if (!hasReturn) {
                sb.append("return null;");
            }
            return sb.toString();
        }

        private String getCallRealMethod(JavaType.Method m) {
            return "(" + m.getParameterTypes().stream().map(this::getMatcher).collect(Collectors.joining(", ")) + ")).thenCallRealMethod();";
        }

        private String getMockStaticDeclarationInBefore(String className) {
            return "#{any(org.mockito.MockedStatic)} = mockStatic(" + className + ".class);";
        }

        private String getMockStaticDeclarationInTry(String className) {
            return "MockedStatic mockStatic" + className + " = mockStatic(" + className + ".class)";
        }

        private String getMockStaticMethods(JavaType.Class clazz, String className, Map<J.MethodDeclaration, JavaType.Method> mockedMethods) {
            StringBuilder tpl = new StringBuilder();
            List keys = mockedMethods.keySet().stream().sorted(Comparator.comparing(o -> o.print(this.getCursor()))).collect(Collectors.toList());
            for (J.MethodDeclaration m2 : keys) {
                tpl.append(JMockitMockUpToMockito.MOCKITO_STATIC_PREFIX).append(className).append(".when(() -> ").append(className).append(".").append(m2.getSimpleName()).append("(").append(m2.getParameters().stream().filter(J.VariableDeclarations.class::isInstance).map(J.VariableDeclarations.class::cast).map(J.VariableDeclarations::getType).map(this::getMatcher).collect(Collectors.joining(", "))).append(")).thenAnswer(invocation -> {").append(this.getAnswerBody(m2)).append("});");
            }
            clazz.getMethods().stream().filter(m -> !m.isConstructor()).filter(m -> !m.getFlags().contains(Flag.Private)).filter(m -> m.getFlags().contains(Flag.Static)).filter(m -> !mockedMethods.containsValue(m)).forEach(m -> tpl.append(JMockitMockUpToMockito.MOCKITO_STATIC_PREFIX).append(className).append(".when(() -> ").append(className).append(".").append(m.getName()).append(this.getCallRealMethod((JavaType.Method)m)));
            return tpl.toString();
        }

        private String getMockConstructionDeclarationInBefore(String className) {
            return "#{any(org.mockito.MockedConstruction)} = mockConstructionWithAnswer(" + className + ".class, delegatesTo(" + JMockitMockUpToMockito.MOCKITO_MOCK_PREFIX + className + "));";
        }

        private String getMockConstructionDeclarationInTry(String className) {
            return "MockedConstruction mockCons" + className + " = mockConstructionWithAnswer(" + className + ".class, delegatesTo(" + JMockitMockUpToMockito.MOCKITO_MOCK_PREFIX + className + "))";
        }

        private String getMockConstructionMethods(String className, Map<J.MethodDeclaration, JavaType.Method> mockedMethods) {
            StringBuilder tpl = new StringBuilder().append(className).append(" ").append(JMockitMockUpToMockito.MOCKITO_MOCK_PREFIX).append(className).append(" = mock(").append(className).append(".class, CALLS_REAL_METHODS);");
            mockedMethods.keySet().stream().sorted(Comparator.comparing(o -> o.print(this.getCursor()))).forEach(m -> tpl.append("doAnswer(invocation -> {").append(this.getAnswerBody((J.MethodDeclaration)m)).append("}).when(").append(JMockitMockUpToMockito.MOCKITO_MOCK_PREFIX).append(className).append(").").append(m.getSimpleName()).append("(").append(m.getParameters().stream().filter(J.VariableDeclarations.class::isInstance).map(J.VariableDeclarations.class::cast).map(J.VariableDeclarations::getType).map(this::getMatcher).collect(Collectors.joining(", "))).append(");"));
            return tpl.toString();
        }

        private boolean isMockUpStatement(Tree tree) {
            return tree instanceof J.NewClass && ((J.NewClass)tree).getClazz() != null && TypeUtils.isOfClassType((JavaType)((J.NewClass)tree).getClazz().getType(), (String)JMockitMockUpToMockito.JMOCKIT_MOCKUP_IMPORT);
        }

        private boolean isSetUpMethod(J.MethodDeclaration md) {
            return md.getLeadingAnnotations().stream().anyMatch(o -> TypeUtils.isOfClassType((JavaType)o.getType(), (String)"org.junit.Before"));
        }

        private boolean isTearDownMethod(J.MethodDeclaration md) {
            return md.getLeadingAnnotations().stream().anyMatch(o -> TypeUtils.isOfClassType((JavaType)o.getType(), (String)"org.junit.After"));
        }

        private Map<J.MethodDeclaration, JavaType.Method> getMockUpMethods(J.NewClass newClass) {
            JavaType mockType = ((Expression)((J.ParameterizedType)newClass.getClazz()).getTypeParameters().get(0)).getType();
            return newClass.getBody().getStatements().stream().filter(J.MethodDeclaration.class::isInstance).map(J.MethodDeclaration.class::cast).filter(s -> s.getLeadingAnnotations().stream().anyMatch(o -> TypeUtils.isOfClassType((JavaType)o.getType(), (String)JMockitMockUpToMockito.JMOCKIT_MOCK_IMPORT))).map(method -> {
                JavaType.Method m;
                Optional found = TypeUtils.findDeclaredMethod((JavaType.FullyQualified)TypeUtils.asFullyQualified((JavaType)mockType), (String)method.getSimpleName(), (List)method.getMethodType().getParameterTypes());
                if (found.isPresent() && !(m = (JavaType.Method)found.get()).getFlags().contains(Flag.Private)) {
                    return new AbstractMap.SimpleEntry<J.MethodDeclaration, JavaType.Method>((J.MethodDeclaration)method, (JavaType.Method)found.get());
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }
}

