/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class URLConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLConnectionFactory.class);
    private final Settings settings;

    public URLConnectionFactory(Settings settings) {
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(justification="yes, there is a redundant null check in the catch - to suppress warnings we are leaving the null check", value={"RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE"})
    public HttpURLConnection createHttpURLConnection(URL url) throws URLConnectionFailureException {
        HttpURLConnection conn = null;
        final String proxyHost = this.settings.getString("proxy.server");
        try {
            if (proxyHost != null && !this.matchNonProxy(url)) {
                int proxyPort = this.settings.getInt("proxy.port");
                InetSocketAddress address = new InetSocketAddress(proxyHost, proxyPort);
                final String username = this.settings.getString("proxy.username");
                final String password = this.settings.getString("proxy.password");
                if (username != null && password != null) {
                    Authenticator auth = new Authenticator(){

                        @Override
                        public PasswordAuthentication getPasswordAuthentication() {
                            if (proxyHost.equals(this.getRequestingHost()) || this.getRequestorType().equals((Object)Authenticator.RequestorType.PROXY)) {
                                LOGGER.debug("Using the configured proxy username and password");
                                if (URLConnectionFactory.this.settings.getBoolean("proxy.disableSchemas", true)) {
                                    System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
                                }
                                return new PasswordAuthentication(username, password.toCharArray());
                            }
                            return super.getPasswordAuthentication();
                        }
                    };
                    Authenticator.setDefault(auth);
                }
                Proxy proxy = new Proxy(Proxy.Type.HTTP, address);
                conn = (HttpURLConnection)url.openConnection(proxy);
            } else {
                conn = (HttpURLConnection)url.openConnection();
            }
            int connectionTimeout = this.settings.getInt("connection.timeout", 10000);
            int readTimeout = this.settings.getInt("connection.read.timeout", 60000);
            conn.setConnectTimeout(connectionTimeout);
            conn.setReadTimeout(readTimeout);
            conn.setInstanceFollowRedirects(true);
        }
        catch (IOException ex) {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                finally {
                    conn = null;
                }
            }
            throw new URLConnectionFailureException("Error getting connection.", ex);
        }
        this.addAuthenticationIfPresent(conn);
        return conn;
    }

    private void addAuthenticationIfPresent(HttpURLConnection conn) {
        String userInfo = conn.getURL().getUserInfo();
        if (userInfo != null) {
            String basicAuth = "Basic " + Base64.getEncoder().encodeToString(userInfo.getBytes(StandardCharsets.UTF_8));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Adding user info as basic authorization");
            }
            conn.addRequestProperty("Authorization", basicAuth);
        }
    }

    public void addBasicAuthentication(HttpURLConnection conn, String userKey, String passwordKey) {
        if (StringUtils.isNotEmpty((CharSequence)this.settings.getString(userKey)) && StringUtils.isNotEmpty((CharSequence)this.settings.getString(passwordKey))) {
            String user = this.settings.getString(userKey);
            String password = this.settings.getString(passwordKey);
            if (user.isEmpty() || password.isEmpty()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Skip authentication as user and/or password is empty");
                }
            } else {
                String userColonPassword = user + ":" + password;
                String basicAuth = "Basic " + Base64.getEncoder().encodeToString(userColonPassword.getBytes(StandardCharsets.UTF_8));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Adding user/password from settings.xml as basic authorization");
                }
                conn.addRequestProperty("Authorization", basicAuth);
            }
        }
    }

    private boolean matchNonProxy(URL url) {
        String host = url.getHost();
        String nonProxyHosts = this.settings.getString("proxy.nonproxyhosts");
        if (null != nonProxyHosts) {
            String[] nonProxies;
            for (String nonProxyHost : nonProxies = nonProxyHosts.split("(,)|(;)|(\\|)")) {
                if (null != nonProxyHost && nonProxyHost.contains("*")) {
                    int pos = nonProxyHost.indexOf(42);
                    String nonProxyHostPrefix = nonProxyHost.substring(0, pos);
                    String nonProxyHostSuffix = nonProxyHost.substring(pos + 1);
                    if (!StringUtils.isBlank((CharSequence)nonProxyHostPrefix) && host.startsWith(nonProxyHostPrefix) && StringUtils.isBlank((CharSequence)nonProxyHostSuffix)) {
                        return true;
                    }
                    if (StringUtils.isBlank((CharSequence)nonProxyHostPrefix) && !StringUtils.isBlank((CharSequence)nonProxyHostSuffix) && host.endsWith(nonProxyHostSuffix)) {
                        return true;
                    }
                    if (StringUtils.isBlank((CharSequence)nonProxyHostPrefix) || !host.startsWith(nonProxyHostPrefix) || StringUtils.isBlank((CharSequence)nonProxyHostSuffix) || !host.endsWith(nonProxyHostSuffix)) continue;
                    return true;
                }
                if (!host.equals(nonProxyHost)) continue;
                return true;
            }
        }
        return false;
    }

    public HttpURLConnection createHttpURLConnection(URL url, boolean proxy) throws URLConnectionFailureException {
        HttpURLConnection conn;
        if (proxy) {
            return this.createHttpURLConnection(url);
        }
        try {
            conn = (HttpURLConnection)url.openConnection();
            int timeout = this.settings.getInt("connection.timeout", 10000);
            conn.setConnectTimeout(timeout);
            conn.setInstanceFollowRedirects(true);
        }
        catch (IOException ioe) {
            throw new URLConnectionFailureException("Error getting connection.", ioe);
        }
        this.addAuthenticationIfPresent(conn);
        return conn;
    }
}

