/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public final class XmlUtils {
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    private XmlUtils() {
    }

    public static SAXParser buildSecureSaxParser(InputStream ... schemaStream) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        Object accessExternalSchema = System.getProperty("javax.xml.accessExternalSchema");
        if (accessExternalSchema == null) {
            accessExternalSchema = "file, https";
        } else if (!"ALL".equalsIgnoreCase((String)accessExternalSchema)) {
            if (!((String)accessExternalSchema).contains("file")) {
                accessExternalSchema = (String)accessExternalSchema + ", file";
            }
            if (!((String)accessExternalSchema).contains("https")) {
                accessExternalSchema = (String)accessExternalSchema + ", https";
            }
        }
        System.setProperty("javax.xml.accessExternalSchema", (String)accessExternalSchema);
        SAXParser saxParser = factory.newSAXParser();
        saxParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        saxParser.setProperty(JAXP_SCHEMA_SOURCE, schemaStream);
        return saxParser;
    }

    public static boolean parseBoolean(String lexicalXSDBoolean) {
        boolean result;
        switch (lexicalXSDBoolean) {
            case "true": 
            case "1": {
                result = true;
                break;
            }
            case "false": 
            case "0": {
                result = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("'" + lexicalXSDBoolean + "' is not a valid xs:boolean value");
            }
        }
        return result;
    }

    public static SAXParser buildSecureSaxParser() throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        return factory.newSAXParser();
    }

    public static DocumentBuilder buildSecureDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        return factory.newDocumentBuilder();
    }

    public static String getPrettyParseExceptionInfo(SAXParseException ex) {
        StringBuilder sb = new StringBuilder();
        if (ex.getSystemId() != null) {
            sb.append("systemId=").append(ex.getSystemId()).append(", ");
        }
        if (ex.getPublicId() != null) {
            sb.append("publicId=").append(ex.getPublicId()).append(", ");
        }
        if (ex.getLineNumber() > 0) {
            sb.append("Line=").append(ex.getLineNumber());
        }
        if (ex.getColumnNumber() > 0) {
            sb.append(", Column=").append(ex.getColumnNumber());
        }
        sb.append(": ").append(ex.getMessage());
        return sb.toString();
    }
}

