/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.InvalidAlgorithmParameterException;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.utils.DownloadFailedException;
import org.owasp.dependencycheck.utils.InvalidSettingException;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.owasp.dependencycheck.utils.URLConnectionFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Downloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(Downloader.class);
    private static final int MAX_REDIRECT_ATTEMPTS = 5;
    private static final String HEAD = "HEAD";
    private static final String GET = "GET";
    private final Settings settings;
    private final URLConnectionFactory connFactory;

    public Downloader(Settings settings) {
        this.settings = settings;
        this.connFactory = new URLConnectionFactory(settings);
    }

    public void fetchFile(URL url, File outputPath) throws DownloadFailedException {
        this.fetchFile(url, outputPath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchFile(URL url, File outputPath, boolean useProxy) throws DownloadFailedException {
        HttpURLConnection conn;
        block62: {
            if ("file".equalsIgnoreCase(url.getProtocol())) {
                File file;
                try {
                    file = new File(url.toURI());
                }
                catch (URISyntaxException ex) {
                    String msg = String.format("Download failed, unable to locate '%s'", url.toString());
                    throw new DownloadFailedException(msg);
                }
                if (file.exists()) {
                    try {
                        FileUtils.copyFile((File)file, (File)outputPath);
                    }
                    catch (IOException ex) {
                        String msg = String.format("Download failed, unable to copy '%s' to '%s'", url.toString(), outputPath.getAbsolutePath());
                        throw new DownloadFailedException(msg, ex);
                    }
                }
                String msg = String.format("Download failed, file ('%s') does not exist", url.toString());
                throw new DownloadFailedException(msg);
            }
            conn = null;
            try {
                LOGGER.debug("Attempting download of {}", (Object)url.toString());
                conn = this.connFactory.createHttpURLConnection(url, useProxy);
                conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
                conn.connect();
                int status = conn.getResponseCode();
                int redirectCount = 0;
                while ((status == 302 || status == 301 || status == 303) && 5 > redirectCount++) {
                    String location = conn.getHeaderField("Location");
                    try {
                        conn.disconnect();
                    }
                    finally {
                        conn = null;
                    }
                    LOGGER.debug("Download is being redirected from {} to {}", (Object)url.toString(), (Object)location);
                    conn = this.connFactory.createHttpURLConnection(new URL(location), useProxy);
                    conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
                    conn.connect();
                    status = conn.getResponseCode();
                }
                if (status == 200) break block62;
                try {
                    conn.disconnect();
                }
                finally {
                    conn = null;
                }
                String msg = String.format("Error downloading file %s; received response code %s.", url.toString(), status);
                throw new DownloadFailedException(msg);
            }
            catch (IOException ex) {
                try {
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
                finally {
                    conn = null;
                }
                if ("Connection reset".equalsIgnoreCase(ex.getMessage())) {
                    String msg = String.format("TLS Connection Reset%nPlease see http://jeremylong.github.io/DependencyCheck/data/tlsfailure.html for more information regarding how to resolve the issue.", new Object[0]);
                    LOGGER.error(msg);
                    throw new DownloadFailedException(msg, ex);
                }
                String msg = String.format("Error downloading file %s; unable to connect.", url.toString());
                throw new DownloadFailedException(msg, ex);
            }
        }
        String encoding = conn.getContentEncoding();
        InputStream reader = null;
        try (FileOutputStream out = new FileOutputStream(outputPath);
             BufferedOutputStream writer = new BufferedOutputStream(out);){
            int bytesRead;
            reader = encoding != null && "gzip".equalsIgnoreCase(encoding) ? new GZIPInputStream(conn.getInputStream()) : (encoding != null && "deflate".equalsIgnoreCase(encoding) ? new InflaterInputStream(conn.getInputStream()) : conn.getInputStream());
            byte[] buffer = new byte[4096];
            while ((bytesRead = reader.read(buffer)) > 0) {
                writer.write(buffer, 0, bytesRead);
            }
            LOGGER.debug("Download of {} complete", (Object)url.toString());
        }
        catch (IOException ex) {
            this.checkForCommonExceptionTypes(ex);
            String msg = String.format("Error saving '%s' to file '%s'%nConnection Timeout: %d%nEncoding: %s%n", url.toString(), outputPath.getAbsolutePath(), conn.getConnectTimeout(), encoding);
            throw new DownloadFailedException(msg, ex);
        }
        catch (Exception ex) {
            String msg = String.format("Unexpected exception saving '%s' to file '%s'%nConnection Timeout: %d%nEncoding: %s%n", url.toString(), outputPath.getAbsolutePath(), conn.getConnectTimeout(), encoding);
            throw new DownloadFailedException(msg, ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    LOGGER.trace("Error closing the reader in Downloader.", (Throwable)ex);
                }
            }
            try {
                conn.disconnect();
            }
            finally {
                conn = null;
            }
        }
    }

    public long getLastModified(URL url) throws DownloadFailedException {
        return this.getLastModified(url, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLastModified(URL url, boolean isRetry) throws DownloadFailedException {
        long timestamp;
        block24: {
            timestamp = 0L;
            if ("file".equalsIgnoreCase(url.getProtocol())) {
                File lastModifiedFile;
                try {
                    lastModifiedFile = new File(url.toURI());
                }
                catch (URISyntaxException ex) {
                    String msg = String.format("Unable to locate '%s'", url.toString());
                    throw new DownloadFailedException(msg, ex);
                }
                timestamp = lastModifiedFile.lastModified();
            } else {
                String httpMethod = this.determineHttpMethod();
                HttpURLConnection conn = null;
                try {
                    conn = this.connFactory.createHttpURLConnection(url);
                    conn.setRequestMethod(httpMethod);
                    conn.connect();
                    int t = conn.getResponseCode();
                    if (t >= 200 && t < 300) {
                        timestamp = conn.getLastModified();
                        break block24;
                    }
                    throw new DownloadFailedException(String.format("%s request returned a non-200 status code", httpMethod));
                }
                catch (URLConnectionFailureException ex) {
                    throw new DownloadFailedException(String.format("Error creating URL Connection for HTTP %s request.", httpMethod), ex);
                }
                catch (IOException ex) {
                    this.checkForCommonExceptionTypes(ex);
                    LOGGER.error("IO Exception: " + ex.getMessage());
                    LOGGER.debug("Exception details", (Throwable)ex);
                    if (ex.getCause() != null) {
                        LOGGER.debug("IO Exception cause: " + ex.getCause().getMessage(), ex.getCause());
                    }
                    try {
                        if (!isRetry && this.settings.getBoolean("downloader.quick.query.timestamp")) {
                            this.settings.setBoolean("downloader.quick.query.timestamp", false);
                            long l = this.getLastModified(url, true);
                            return l;
                        }
                    }
                    catch (InvalidSettingException ex1) {
                        LOGGER.debug("invalid setting?", (Throwable)ex1);
                    }
                    throw new DownloadFailedException(String.format("Error making HTTP %s request.", httpMethod), ex);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.disconnect();
                        }
                        finally {
                            conn = null;
                        }
                    }
                }
            }
        }
        return timestamp;
    }

    protected synchronized void checkForCommonExceptionTypes(IOException ex) throws DownloadFailedException {
        for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
            if (cause instanceof UnknownHostException) {
                String msg = String.format("Unable to resolve domain '%s'", cause.getMessage());
                LOGGER.error(msg);
                throw new DownloadFailedException(msg);
            }
            if (!(cause instanceof InvalidAlgorithmParameterException)) continue;
            String keystore = System.getProperty("javax.net.ssl.keyStore");
            String version = System.getProperty("java.version");
            String vendor = System.getProperty("java.vendor");
            LOGGER.info("Error making HTTPS request - InvalidAlgorithmParameterException");
            LOGGER.info("There appears to be an issue with the installation of Java and the cacerts.See closed issue #177 here: https://github.com/jeremylong/DependencyCheck/issues/177");
            LOGGER.info("Java Info:\njavax.net.ssl.keyStore='{}'\njava.version='{}'\njava.vendor='{}'", new Object[]{keystore, version, vendor});
            throw new DownloadFailedException("Error making HTTPS request. Please see the log for more details.");
        }
    }

    private String determineHttpMethod() {
        return this.isQuickQuery() ? HEAD : GET;
    }

    private boolean isQuickQuery() {
        boolean quickQuery;
        try {
            quickQuery = this.settings.getBoolean("downloader.quick.query.timestamp", true);
        }
        catch (InvalidSettingException e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Invalid settings : {}", (Object)e.getMessage(), (Object)e);
            }
            quickQuery = true;
        }
        return quickQuery;
    }
}

