/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.resolver;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.raml.parser.completion.KeySuggestion;
import org.raml.parser.completion.Suggestion;
import org.raml.parser.resolver.TupleHandler;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class EnumHandler
implements TupleHandler {
    private Class<? extends Enum> enumClass;

    public EnumHandler(Class<? extends Node> tupleValueType, Class<? extends Enum> enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public boolean handles(NodeTuple tuple) {
        if (tuple.getKeyNode() instanceof ScalarNode) {
            String enumValue = ((ScalarNode)tuple.getKeyNode()).getValue();
            try {
                Enum.valueOf(this.enumClass, enumValue.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public List<Suggestion> getSuggestions() {
        Field[] declaredFields;
        ArrayList<Suggestion> result = new ArrayList<Suggestion>();
        for (Field declaredField : declaredFields = this.enumClass.getDeclaredFields()) {
            if (!declaredField.isEnumConstant()) continue;
            result.add(new KeySuggestion(declaredField.getName().toLowerCase()));
        }
        return result;
    }
}

