/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.tagresolver;

import java.util.ArrayDeque;
import java.util.Deque;
import org.raml.parser.visitor.IncludeInfo;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public class ContextPath {
    private Deque<IncludeInfo> includeStack = new ArrayDeque<IncludeInfo>();

    public ContextPath() {
    }

    public ContextPath(ContextPath contextPath) {
        this.includeStack = new ArrayDeque<IncludeInfo>(contextPath.includeStack);
    }

    public ContextPath(IncludeInfo includeInfo) {
        this.includeStack.add(includeInfo);
    }

    public void pushRoot(String absoluteFile) {
        if (this.includeStack.size() > 0) {
            throw new IllegalStateException("Non empty stack");
        }
        this.includeStack.add(new IncludeInfo(absoluteFile));
    }

    public static String resolveAbsolutePath(String relativeFile, String parentPath) {
        if (relativeFile.startsWith("classpath:")) {
            return relativeFile.substring(relativeFile.indexOf(":") + 1);
        }
        if (relativeFile.startsWith("http:") || relativeFile.startsWith("https:") || relativeFile.startsWith("file:")) {
            return relativeFile;
        }
        return parentPath + relativeFile;
    }

    public String resolveAbsolutePath(String relativeFile) {
        return ContextPath.resolveAbsolutePath(relativeFile, this.getPartentPath());
    }

    public String resolveRelativePath(Tag tag) {
        if (tag == null || !tag.startsWith("!include-applied_")) {
            throw new IllegalArgumentException("Tag must be an include applied");
        }
        String partentPath = this.getPartentPath();
        String includePath = new IncludeInfo(tag).getIncludeName();
        if (includePath.startsWith(partentPath)) {
            includePath = includePath.substring(partentPath.length());
        }
        return includePath;
    }

    public static String getPartentPath(String path) {
        int idx = path.lastIndexOf("/") + 1;
        return path.substring(0, idx);
    }

    private String getPartentPath() {
        return ContextPath.getPartentPath(this.includeStack.peek().getIncludeName());
    }

    public IncludeInfo peek() {
        return this.includeStack.peek();
    }

    public IncludeInfo pop() {
        return this.includeStack.pop();
    }

    public void push(IncludeInfo includeInfo) {
        this.includeStack.push(includeInfo);
    }

    public void push(ScalarNode node) {
        this.push(new IncludeInfo(node, this.getPartentPath()));
    }

    public void push(Tag tag) {
        this.push(new IncludeInfo(tag));
    }

    public int size() {
        return this.includeStack.size();
    }
}

