/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.plugins.cache.memcached;

import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.GetCompletionListener;
import net.spy.memcached.internal.GetFuture;
import net.spy.memcached.internal.OperationCompletionListener;
import net.spy.memcached.internal.OperationFuture;
import org.rapidoid.cls.Cls;
import org.rapidoid.concurrent.Callback;
import org.rapidoid.concurrent.Callbacks;
import org.rapidoid.plugins.cache.AbstractCache;
import org.rapidoid.u.U;

public class MemcachedCache<K, V>
extends AbstractCache<K, V> {
    private final MemcachedClient client;

    public MemcachedCache(MemcachedClient client, String cacheName, long timeToLiveMs, boolean resetTimeToLiveWhenAccessed) {
        super(cacheName, timeToLiveMs, false);
        this.client = client;
    }

    protected void doSet(K key, V value, long timeToLiveMs, final Callback<Void> callback) {
        try {
            int timeToLiveSec = (int)Math.min(timeToLiveMs / 1000L, 2592000L);
            OperationFuture future = this.client.set(this.key(key), timeToLiveSec, value);
            future.addListener(new OperationCompletionListener(){

                public void onComplete(OperationFuture<?> future) throws Exception {
                    boolean success = (Boolean)future.get();
                    if (success) {
                        Callbacks.success((Callback)callback, null);
                    } else {
                        Callbacks.error((Callback)callback, (Throwable)U.rte((String)"Couldn't write the value to the cache!"));
                    }
                }
            });
        }
        catch (Exception e) {
            Callbacks.error(callback, (Throwable)e);
        }
    }

    protected void doGet(K key, final Callback<V> callback) {
        try {
            GetFuture future = this.client.asyncGet(this.key(key));
            future.addListener(new GetCompletionListener(){

                public void onComplete(GetFuture<?> future) throws Exception {
                    Object value = future.get();
                    Callbacks.success((Callback)callback, (Object)value);
                }
            });
        }
        catch (Exception e) {
            Callbacks.error(callback, (Throwable)e);
        }
    }

    private String key(K key) {
        String skey = Cls.str(key);
        return !U.isEmpty((String)this.name) ? this.name + ":::" + skey : skey;
    }
}

