/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.json;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.OutputStream;
import java.util.Map;
import org.rapidoid.beany.Beany;
import org.rapidoid.log.Log;
import org.rapidoid.util.Cls;
import org.rapidoid.util.U;

public class JSON {
    public static final ObjectMapper MAPPER = JSON.mapper();

    private static ObjectMapper mapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    public static String stringify(Object value) {
        try {
            return MAPPER.writeValueAsString(Beany.serialize((Object)value));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void stringify(Object value, OutputStream out) {
        try {
            MAPPER.writeValue(out, Beany.serialize((Object)value));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(String json, Class<T> valueType) {
        try {
            return (T)MAPPER.readValue(json, valueType);
        }
        catch (Exception e) {
            Log.error((String)"Cannot parse JSON!", (String)"json", (Object)json, (String)"error", (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> parseMap(String json) {
        return JSON.parse(json, Map.class);
    }

    public static void warmup() {
        JSON.stringify(123);
        JSON.parse("{}", Map.class);
    }

    public static String save(Object value) {
        try {
            Object ser = Beany.serialize((Object)value);
            Class<?> cls = value != null ? value.getClass() : null;
            Map map = U.map((Object)"_", (Object)cls.getCanonicalName(), (Object)"v", (Object)ser);
            return MAPPER.writeValueAsString((Object)map);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object load(String json) {
        Map<String, Object> map = JSON.parseMap(json);
        String clsName = (String)map.get("_");
        Class type = Cls.getClassIfExists((String)clsName);
        if (type == null) {
            return null;
        }
        Object ser = map.get("v");
        if (ser instanceof Map) {
            Object value = Cls.newInstance((Class)type);
            Map props = (Map)ser;
            Beany.update((Object)value, (Map)props, (boolean)false);
            return value;
        }
        return ser;
    }
}

