/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.render;

import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rapidoid.RapidoidThing;
import org.rapidoid.render.XNode;
import org.rapidoid.u.U;

public class TemplateParser
extends RapidoidThing {
    private static final String NL = "(\\r?\\n?)";
    private static final String SP = "([\\t ]*)";
    static final String EXPR = "(\\$|@)\\{([^\\}]+?)\\}";
    static final String STAT = "(\\r?\\n?)([\\t ]*)\\{\\{([\\^!#\\?/>][^\\}]+?)\\}\\}([\\t ]*)(\\r?\\n?)";
    static final String TAG = "</?\\s*(\\w+(-\\w+)*)(\\s+\\w+=\"[^\"]+?\")*?\\s*/?>";
    static final Pattern TOKENIZER = Pattern.compile("(?s)(.*?)(?:" + U.join((String)"|", (Object[])new String[]{"(\\$|@)\\{([^\\}]+?)\\}", "(\\r?\\n?)([\\t ]*)\\{\\{([\\^!#\\?/>][^\\}]+?)\\}\\}([\\t ]*)(\\r?\\n?)"}) + ")");

    public static XNode parse(String s) {
        U.notNull((Object)s, (String)"template source", (Object[])new Object[0]);
        Stack<XNode> stack = new Stack<XNode>();
        XNode root = new XNode(XNode.OP.OP_ROOT, null);
        stack.push(root);
        Matcher m = TOKENIZER.matcher(s);
        int pos = 0;
        while (m.find()) {
            String txt;
            char prefix;
            String whole = m.group(0);
            String g1 = m.group(1);
            if (!U.isEmpty((String)g1)) {
                TemplateParser.addText(stack, g1);
            }
            String g2 = m.group(2);
            String g4 = m.group(6);
            if (!U.isEmpty((String)g2)) {
                prefix = g2.charAt(0);
                txt = m.group(3);
                TemplateParser.expression(stack, prefix, txt, whole);
            } else if (!U.isEmpty((String)g4)) {
                prefix = g4.charAt(0);
                txt = g4.substring(1);
                String nl1 = m.group(4);
                assert (nl1.matches(NL));
                String sp1 = m.group(5);
                assert (sp1.matches(SP));
                String sp2 = m.group(7);
                assert (sp2.matches(SP));
                String nl2 = m.group(8);
                assert (nl2.matches(NL));
                if (prefix == XNode.OP.OP_INCLUDE.code) {
                    TemplateParser.addText(stack, nl1);
                    TemplateParser.addText(stack, sp1);
                    TemplateParser.expression(stack, prefix, txt, whole);
                    TemplateParser.addText(stack, sp2);
                    TemplateParser.addText(stack, nl2);
                } else {
                    char ch;
                    boolean hasNl2;
                    boolean hasNl1;
                    boolean bl = hasNl1 = !nl1.isEmpty();
                    if (!hasNl1) {
                        if (m.start() > 0) {
                            char ch2 = s.charAt(m.start() - 1);
                            if (ch2 == '\n' || ch2 == '\r') {
                                hasNl1 = true;
                            }
                        } else {
                            hasNl1 = true;
                        }
                    }
                    boolean bl2 = hasNl2 = !nl2.isEmpty();
                    if (!(hasNl2 || m.end() + 1 >= s.length() || (ch = s.charAt(m.end() + 1)) != '\n' && ch != '\r')) {
                        hasNl2 = true;
                    }
                    boolean wholeLine = hasNl1 && hasNl2;
                    TemplateParser.addText(stack, nl1);
                    if (!wholeLine) {
                        TemplateParser.addText(stack, sp1);
                    }
                    TemplateParser.block(stack, prefix, txt, whole);
                    if (!wholeLine) {
                        TemplateParser.addText(stack, sp2);
                    }
                    if (!hasNl1 && hasNl2) {
                        TemplateParser.addText(stack, nl2);
                    }
                }
            } else {
                throw U.rte((String)"Unknown tag!");
            }
            pos = m.end();
        }
        TemplateParser.addText(stack, s.substring(pos));
        XNode last = stack.pop();
        U.must((last == root ? 1 : 0) != 0, (String)"The tag '%s' was not closed!", (Object)last.text);
        return root;
    }

    private static void addText(Stack<XNode> stack, String g1) {
        stack.peek().children.add(new XNode(XNode.OP.OP_TEXT, g1));
    }

    private static void expression(Stack<XNode> stack, char prefix, String expr, String whole) {
        U.must((!expr.isEmpty() ? 1 : 0) != 0, (String)"Empty expression!");
        switch (prefix) {
            case '$': {
                stack.peek().children.add(new XNode(XNode.OP.OP_PRINT, expr));
                break;
            }
            case '@': {
                stack.peek().children.add(new XNode(XNode.OP.OP_PRINT_RAW, expr));
                break;
            }
            case '>': {
                stack.peek().children.add(new XNode(XNode.OP.OP_INCLUDE, expr));
                break;
            }
            default: {
                throw U.rte((String)"Invalid expression: %s", (Object[])new Object[]{expr});
            }
        }
    }

    private static void block(Stack<XNode> stack, char prefix, String stat, String whole) {
        U.must((!stat.isEmpty() ? 1 : 0) != 0, (String)"Empty block!");
        switch (prefix) {
            case '#': {
                stack.push(new XNode(XNode.OP.OP_FOREACH, stat));
                break;
            }
            case '?': {
                stack.push(new XNode(XNode.OP.OP_IF, stat));
                break;
            }
            case '!': 
            case '^': {
                stack.push(new XNode(XNode.OP.OP_IF_NOT, stat));
                break;
            }
            case '/': {
                TemplateParser.close(stack, stat);
                break;
            }
            default: {
                throw U.rte((String)"Invalid block: %s", (Object[])new Object[]{stat});
            }
        }
    }

    private static void close(Stack<XNode> stack, String text) {
        U.must((!stack.isEmpty() ? 1 : 0) != 0, (String)"Empty stack!");
        XNode x = stack.pop();
        U.must((x.op != XNode.OP.OP_ROOT ? 1 : 0) != 0, (String)"Cannot close a tag that wasn't open: %s", (Object)text);
        if (!U.eq((Object)x.text, (Object)text)) {
            throw U.rte((String)"Expected block: %s, but found: %s", (Object[])new Object[]{x.text, text});
        }
        stack.peek().children.add(x);
    }
}

