/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.render.retriever;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.beany.BeanProp;
import org.rapidoid.beany.Beany;
import org.rapidoid.beany.Prop;
import org.rapidoid.render.Getter;
import org.rapidoid.render.retriever.CachedPropRetriever;
import org.rapidoid.render.retriever.ValueRetriever;
import org.rapidoid.u.U;

public class GenericValueRetriever
extends RapidoidThing
implements ValueRetriever {
    private final String property;
    private volatile CachedPropRetriever cachedPropRetriever;

    public GenericValueRetriever(String property) {
        this.property = property;
    }

    @Override
    public Object retrieve(List<Object> model) {
        if (U.isEmpty(model)) {
            return null;
        }
        return this.getProp(model);
    }

    private Object getProp(List<Object> model) {
        Prop prop;
        Object target = U.last(model);
        Class<?> cls = target.getClass();
        CachedPropRetriever cachedProp = this.cachedPropRetriever;
        if (cachedProp != null && cachedProp.canRetrieve(cls)) {
            return cachedProp.retrieve(target);
        }
        if (!(target instanceof Map) && (prop = Beany.property((Object)target, (String)this.property, (boolean)false)) != null && prop instanceof BeanProp) {
            this.cachedPropRetriever = new CachedPropRetriever(cls, prop);
            return prop.getFast(target);
        }
        return GenericValueRetriever.propOf(this.property, model);
    }

    public static Object self(List<Object> model) {
        return model.get(model.size() - 1);
    }

    public static Object propOf(String name, List<Object> scope) {
        int p = name.indexOf(".");
        if (p == 0) {
            U.must((name.length() == 1 ? 1 : 0) != 0, (String)"Invalid expression!");
            return GenericValueRetriever.self(scope);
        }
        if (p > 0) {
            Object first = GenericValueRetriever.propOf(name.substring(0, p), scope);
            return GenericValueRetriever.propOf(name.substring(p + 1), Collections.singletonList(first));
        }
        for (int i = scope.size() - 1; i >= 0; --i) {
            Object value;
            Object x = scope.get(i);
            if (x == null || (value = GenericValueRetriever.singleModelProp(name, x)) == null) continue;
            return value;
        }
        return null;
    }

    public static Object singleModelProp(String name, Object model) {
        if (model instanceof Map) {
            Map map = (Map)model;
            return map.get(name);
        }
        if (model instanceof Getter) {
            Getter getter = (Getter)model;
            return getter.get(name);
        }
        Prop prop = Beany.property((Object)model, (String)name, (boolean)false);
        if (prop != null) {
            return prop.get(model);
        }
        return null;
    }
}

