/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.sql;

import org.rapidoid.config.Conf;
import org.rapidoid.u.U;

public class JDBCConfig {
    public static String url() {
        return (String)Conf.nested((String[])new String[]{"jdbc", "url"});
    }

    public static String driver() {
        String driver = (String)Conf.nested((String[])new String[]{"jdbc", "driver"});
        if (driver == null && !U.isEmpty((String)JDBCConfig.url())) {
            driver = JDBCConfig.inferDriverFromUrl(JDBCConfig.url());
        }
        return driver;
    }

    public static String username() {
        return (String)Conf.nested((String[])new String[]{"jdbc", "username"});
    }

    public static String password() {
        return (String)Conf.nested((String[])new String[]{"jdbc", "password"});
    }

    public static String inferDriverFromUrl(String url) {
        if (url.startsWith("jdbc:mysql:")) {
            return "com.mysql.jdbc.Driver";
        }
        if (url.startsWith("jdbc:h2:")) {
            return "org.hibernate.dialect.H2Dialect";
        }
        if (url.startsWith("jdbc:hsqldb:")) {
            return "org.hsqldb.jdbc.JDBCDriver";
        }
        return null;
    }
}

