/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.rapidoid.log.Log;
import org.rapidoid.sql.ConnectionPool;
import org.rapidoid.sql.JDBCConfig;
import org.rapidoid.sql.SQLAPI;
import org.rapidoid.u.U;

public class SQL {
    private static SQLAPI DEFAULT;

    public static SQLAPI newInstance() {
        return new SQLAPI();
    }

    public static synchronized SQLAPI defaultInstance() {
        if (DEFAULT == null) {
            DEFAULT = new SQLAPI();
            String url = JDBCConfig.url();
            String driver = JDBCConfig.driver();
            String username = JDBCConfig.username();
            String password = JDBCConfig.password();
            DEFAULT.url(url);
            DEFAULT.driver(driver);
            DEFAULT.user(username);
            DEFAULT.password(password);
            DEFAULT.pooled();
            String maskedPassword = U.isEmpty((String)password) ? "<empty>" : "<specified>";
            Log.info((String)"Initialized the default JDBC/SQL API", (String)"url", (Object)url, (String)"driver", (Object)driver, (String)"username", (Object)username, (String)"password", (Object)maskedPassword);
        }
        return DEFAULT;
    }

    public static SQLAPI user(String user) {
        return SQL.defaultInstance().user(user);
    }

    public static SQLAPI password(String password) {
        return SQL.defaultInstance().password(password);
    }

    public static SQLAPI driver(String driver) {
        return SQL.defaultInstance().driver(driver);
    }

    public static SQLAPI connectionPool(ConnectionPool connectionPool) {
        return SQL.defaultInstance().connectionPool(connectionPool);
    }

    public static SQLAPI host(String host) {
        return SQL.defaultInstance().host(host);
    }

    public static SQLAPI port(int port) {
        return SQL.defaultInstance().port(port);
    }

    public static SQLAPI db(String databaseName) {
        return SQL.defaultInstance().db(databaseName);
    }

    public static SQLAPI url(String url) {
        return SQL.defaultInstance().url(url);
    }

    public static SQLAPI mysql() {
        return SQL.defaultInstance().mysql();
    }

    public static SQLAPI h2() {
        return SQL.defaultInstance().h2();
    }

    public static SQLAPI hsql() {
        return SQL.defaultInstance().hsql();
    }

    public static SQLAPI pooled() {
        return SQL.defaultInstance().pooled();
    }

    public static void execute(String sql, Object ... args) {
        SQL.defaultInstance().execute(sql, args);
    }

    public static void tryToExecute(String sql, Object ... args) {
        SQL.defaultInstance().tryToExecute(sql, args);
    }

    public static PreparedStatement statement(Connection conn, String sql, Object ... args) {
        return SQLAPI.createStatement(conn, sql, args);
    }

    public static <T> List<Map<String, Object>> get(String sql, Object ... args) {
        return SQL.defaultInstance().query(sql, args);
    }

    public static List<Map<String, Object>> rows(ResultSet rs) throws SQLException {
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        while (rs.next()) {
            rows.add(SQL.row(rs));
        }
        return rows;
    }

    public static Map<String, Object> row(ResultSet rs) throws SQLException {
        LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
        ResultSetMetaData meta = rs.getMetaData();
        int columnsNumber = meta.getColumnCount();
        for (int i = 1; i <= columnsNumber; ++i) {
            Object obj = rs.getObject(i);
            row.put(meta.getColumnLabel(i), obj);
        }
        return row;
    }

    public static Connection getConnection() {
        return SQL.defaultInstance().getConnection();
    }

    public static void release(Connection connection) {
        SQL.defaultInstance().release(connection);
    }
}

