/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.rapidoid.log.Log;
import org.rapidoid.sql.C3P0ConnectionPool;
import org.rapidoid.sql.ConnectionPool;
import org.rapidoid.sql.JDBCConfig;
import org.rapidoid.sql.NoConnectionPool;
import org.rapidoid.sql.SQL;
import org.rapidoid.u.U;

public class SQLAPI {
    private boolean initialized;
    private String user;
    private String password;
    private String driver;
    private String db = "";
    private String url;
    private String completeUrl;
    private String host = "localhost";
    private int port;
    private ConnectionPool connectionPool = new NoConnectionPool();

    public synchronized SQLAPI user(String user) {
        this.user = user;
        this.initialized = false;
        return this;
    }

    public synchronized SQLAPI password(String password) {
        this.password = password;
        this.initialized = false;
        return this;
    }

    public synchronized SQLAPI driver(String driver) {
        this.driver = driver;
        this.initialized = false;
        return this;
    }

    public synchronized SQLAPI connectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
        this.initialized = false;
        return this;
    }

    public synchronized SQLAPI host(String host) {
        this.host = host;
        this.initialized = false;
        return this;
    }

    public synchronized SQLAPI port(int port) {
        this.port = port;
        this.initialized = false;
        return this;
    }

    public synchronized SQLAPI db(String databaseName) {
        this.db = databaseName;
        this.initialized = false;
        return this;
    }

    public synchronized SQLAPI url(String url) {
        this.url = url;
        this.initialized = false;
        return this;
    }

    public SQLAPI mysql() {
        return this.driver("com.mysql.jdbc.Driver").url("jdbc:mysql://<host>:<port>/<db>");
    }

    public SQLAPI h2() {
        return this.driver("org.h2.Driver").url("jdbc:h2:mem:<db>;DB_CLOSE_DELAY=-1").user("sa").password("");
    }

    public SQLAPI hsql() {
        return this.driver("org.hsqldb.jdbc.JDBCDriver").url("jdbc:hsqldb:mem:<db>").user("sa").password("");
    }

    private String jdbcUrl() {
        return this.completeUrl;
    }

    private void registerJDBCDriver() {
        if (this.driver == null) {
            this.driver = JDBCConfig.driver();
        }
        this.validateArgNotNull("driver", this.driver);
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find JDBC driver class: " + this.driver);
        }
    }

    private void validateArgNotNull(String argName, String argValue) {
        if (argValue == null) {
            throw new RuntimeException("The JDBC parameter '" + argName + "' must be configured!");
        }
    }

    private synchronized void ensureIsInitialized() {
        if (!this.initialized) {
            this.registerJDBCDriver();
            this.setupCompleteUrl();
            this.initialized = true;
        }
    }

    private void setupCompleteUrl() {
        U.notNull((Object)this.url, (String)"JDBC URL", (Object[])new Object[0]);
        this.completeUrl = this.url.replace("<db>", U.safe((String)this.db)).replace("<user>", U.safe((String)this.user)).replace("<password>", U.safe((String)this.password)).replace("<host>", U.safe((String)this.host));
        this.completeUrl = this.port > 0 ? this.completeUrl.replace("<port>", "" + this.port) : this.completeUrl.replace(":<port>", "").replace("<port>", "");
    }

    public Connection getConnection() {
        this.ensureIsInitialized();
        return this.provideConnection();
    }

    private static void close(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error occured while closing the connection!", e);
        }
    }

    private static void close(PreparedStatement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error occured while closing the statement!", e);
        }
    }

    private static void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error occured while closing the ResultSet!", e);
        }
    }

    static PreparedStatement createStatement(Connection conn, String sql, Object[] args) {
        try {
            PreparedStatement stmt = conn.prepareStatement(sql);
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                stmt.setObject(i + 1, arg);
            }
            return stmt;
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot create prepared statement!", e);
        }
    }

    public void execute(String sql, Object ... args) {
        this.ensureIsInitialized();
        Connection conn = this.provideConnection();
        PreparedStatement stmt = null;
        try {
            stmt = SQLAPI.createStatement(conn, sql, args);
            stmt.execute();
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                SQLAPI.close(stmt);
                SQLAPI.close(conn);
                throw throwable;
            }
        }
        SQLAPI.close(stmt);
        SQLAPI.close(conn);
    }

    public void tryToExecute(String sql, Object ... args) {
        try {
            this.execute(sql, args);
        }
        catch (Exception e) {
            Log.warn((String)"Ignoring exception", (String)"error", (Object)U.safe((String)e.getMessage()));
        }
    }

    public <T> List<Map<String, Object>> query(String sql, Object ... args) {
        List<Map<String, Object>> list;
        this.ensureIsInitialized();
        Connection conn = this.provideConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = SQLAPI.createStatement(conn, sql, args);
            rs = stmt.executeQuery();
            list = SQL.rows(rs);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                SQLAPI.close(rs);
                SQLAPI.close(stmt);
                SQLAPI.close(conn);
                throw throwable;
            }
        }
        SQLAPI.close(rs);
        SQLAPI.close(stmt);
        SQLAPI.close(conn);
        return list;
    }

    private Connection provideConnection() {
        try {
            Connection conn;
            if (this.user != null) {
                String pass = U.safe((String)this.password);
                conn = this.connectionPool.getConnection(this.jdbcUrl(), this.user, pass);
                if (conn == null) {
                    conn = DriverManager.getConnection(this.jdbcUrl(), this.user, pass);
                }
            } else {
                conn = this.connectionPool.getConnection(this.jdbcUrl());
                if (conn == null) {
                    conn = DriverManager.getConnection(this.jdbcUrl());
                }
            }
            return conn;
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot create JDBC connection!", e);
        }
    }

    public void release(Connection connection) {
        try {
            this.connectionPool.releaseConnection(connection);
        }
        catch (SQLException e) {
            Log.error((String)"Error while releasing a JDBC connection!", (Throwable)e);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String user() {
        return this.user;
    }

    public String password() {
        return this.password;
    }

    public String driver() {
        return this.driver;
    }

    public String db() {
        return this.db;
    }

    public String url() {
        return this.url;
    }

    public String getCompleteUrl() {
        return this.completeUrl;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public SQLAPI pooled() {
        new C3P0ConnectionPool(this);
        return this;
    }
}

