/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import org.rapidoid.cls.Cls;
import org.rapidoid.concurrent.Callback;
import org.rapidoid.concurrent.Callbacks;
import org.rapidoid.config.Conf;
import org.rapidoid.config.Config;
import org.rapidoid.datamodel.Results;
import org.rapidoid.datamodel.impl.ResultsImpl;
import org.rapidoid.group.AutoManageable;
import org.rapidoid.group.ManageableBean;
import org.rapidoid.io.Res;
import org.rapidoid.jdbc.C3P0Factory;
import org.rapidoid.jdbc.HikariFactory;
import org.rapidoid.jdbc.JdbcData;
import org.rapidoid.jdbc.JdbcUtil;
import org.rapidoid.jdbc.JdbcWorkers;
import org.rapidoid.jdbc.ReadWriteMode;
import org.rapidoid.lambda.Mapper;
import org.rapidoid.lambda.Operation;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;
import org.rapidoid.util.LazyInit;
import org.rapidoid.util.Msc;
import org.rapidoid.util.MscOpts;

@ManageableBean(kind="jdbc")
public class JdbcClient
extends AutoManageable<JdbcClient> {
    private static final String DEFAULT_POOL_PROVIDER = "hikari";
    private volatile boolean initialized;
    private volatile String username;
    private volatile String password;
    private volatile String driver;
    private volatile String url;
    private volatile boolean usePool = true;
    private volatile DataSource dataSource;
    private volatile String poolProvider = "hikari";
    private volatile ReadWriteMode mode = ReadWriteMode.READ_WRITE;
    private final Config config;
    private final LazyInit<JdbcWorkers> workers = new LazyInit((Callable)new Callable<JdbcWorkers>(){

        @Override
        public JdbcWorkers call() throws Exception {
            return new JdbcWorkers(JdbcClient.this);
        }
    });

    public JdbcClient(String name) {
        super(name);
        this.config = Conf.JDBC.defaultOrCustom(name);
        this.configure();
    }

    public void configure() {
        this.url((String)this.config.entry("url").str().getOrNull());
        this.username((String)this.config.entry("username").str().getOrNull());
        this.password((String)this.config.entry("password").str().getOrNull());
        this.driver((String)this.config.entry("driver").str().getOrNull());
        this.poolProvider((String)this.config.entry("poolProvider").or((Object)DEFAULT_POOL_PROVIDER));
        if (U.isEmpty((String)this.driver) && U.notEmpty((String)this.url)) {
            this.driver(JdbcClient.inferDriverFromUrl(this.url));
        }
    }

    private static String inferDriverFromUrl(String url) {
        if (url.startsWith("jdbc:mysql:")) {
            return "com.mysql.jdbc.Driver";
        }
        if (url.startsWith("jdbc:h2:")) {
            return "org.hibernate.dialect.H2Dialect";
        }
        if (url.startsWith("jdbc:hsqldb:")) {
            return "org.hsqldb.jdbc.JDBCDriver";
        }
        return null;
    }

    public synchronized JdbcClient username(String username) {
        if (U.neq((Object)this.username, (Object)username)) {
            this.username = username;
            this.initialized = false;
        }
        return this;
    }

    public synchronized JdbcClient password(String password) {
        if (U.neq((Object)this.password, (Object)password)) {
            this.password = password;
            this.initialized = false;
        }
        return this;
    }

    public synchronized JdbcClient driver(String driver) {
        if (U.neq((Object)this.driver, (Object)driver)) {
            this.driver = driver;
            this.initialized = false;
        }
        return this;
    }

    @Deprecated
    public synchronized JdbcClient pool(DataSource pool) {
        return this.dataSource(pool);
    }

    public synchronized JdbcClient dataSource(DataSource dataSource) {
        if (U.neq((Object)this.dataSource, (Object)dataSource)) {
            this.dataSource = dataSource;
            this.usePool = dataSource != null;
            this.initialized = false;
        }
        return this;
    }

    public synchronized JdbcClient url(String url) {
        if (U.neq((Object)this.url, (Object)url)) {
            this.url = url;
            this.initialized = false;
        }
        return this;
    }

    public synchronized JdbcClient usePool(boolean usePool) {
        if (U.neq((Object)this.usePool, (Object)usePool)) {
            this.usePool = usePool;
            this.initialized = false;
        }
        return this;
    }

    public synchronized JdbcClient mode(ReadWriteMode mode) {
        if (U.neq((Object)((Object)this.mode), (Object)((Object)mode))) {
            this.mode = mode;
            this.initialized = false;
        }
        return this;
    }

    public JdbcClient poolProvider(String poolProvider) {
        if (U.neq((Object)this.poolProvider, (Object)poolProvider)) {
            this.poolProvider = poolProvider;
            this.initialized = false;
        }
        return this;
    }

    @Deprecated
    public JdbcClient pooled() {
        this.usePool(true);
        return this;
    }

    public JdbcClient mysql(String host, int port, String databaseName) {
        return this.driver("com.mysql.jdbc.Driver").url(U.frmt((String)"jdbc:mysql://%s:%s/%s", (Object[])new Object[]{host, port, databaseName}));
    }

    public JdbcClient h2(String databaseName) {
        return this.driver("org.h2.Driver").url("jdbc:h2:mem:" + databaseName + ";DB_CLOSE_DELAY=-1").username("sa").password("");
    }

    public JdbcClient hsql(String databaseName) {
        return this.driver("org.hsqldb.jdbc.JDBCDriver").url("jdbc:hsqldb:mem:" + databaseName).username("sa").password("");
    }

    private void registerJDBCDriver() {
        if (this.driver == null && this.url != null) {
            this.driver = JdbcClient.inferDriverFromUrl(this.url);
        }
        this.validateArgNotNull("driver", this.driver);
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            throw U.rte((String)("Cannot find JDBC driver class: " + this.driver));
        }
    }

    private void validateArgNotNull(String argName, String argValue) {
        if (argValue == null) {
            throw U.rte((String)("The JDBC parameter '" + argName + "' must be configured!"));
        }
    }

    private synchronized void ensureIsInitialized() {
        if (!this.initialized) {
            this.validate();
            this.registerJDBCDriver();
            if (this.dataSource == null) {
                this.dataSource = this.usePool ? this.createPool() : null;
            }
            String ds = this.dataSource != null ? Cls.of((Object)this.dataSource).getSimpleName() : null;
            Log.info((String)"Initialized JDBC API", (String)"!url", (Object)this.url, (String)"!driver", (Object)this.driver, (String)"!username", (Object)this.username, (String)"!password", (Object)this.maskedPassword(), (String)"!dataSource", (Object)ds);
            this.initialized = true;
        }
    }

    private String maskedPassword() {
        return U.isEmpty((String)this.password) ? "<empty>" : "<specified>";
    }

    private DataSource createPool() {
        String provider;
        switch (provider = U.safe((String)this.poolProvider)) {
            case "hikari": {
                U.must((boolean)MscOpts.hasHikari(), (String)"Couldn't find Hikari!");
                Log.info((String)"Initializing JDBC connection pool with Hikari", (String)"!url", (Object)this.url, (String)"!driver", (Object)this.driver, (String)"!username", (Object)this.username, (String)"!password", (Object)this.maskedPassword());
                return HikariFactory.createDataSourceFor(this);
            }
            case "c3p0": {
                U.must((boolean)MscOpts.hasC3P0(), (String)"Couldn't find C3P0!");
                Log.info((String)"Initializing JDBC connection pool with C3P0", (String)"!url", (Object)this.url, (String)"!driver", (Object)this.driver, (String)"!username", (Object)this.username, (String)"!password", (Object)this.maskedPassword());
                return C3P0Factory.createDataSourceFor(this);
            }
        }
        throw U.rte((String)"Unknown pool provider: '%s'!", (Object[])new Object[]{provider});
    }

    private void validate() {
        U.must((boolean)U.notEmpty((Object)(this.username != null ? 1 : 0)), (String)"The database username must be specified!");
        U.must((boolean)U.notEmpty((Object)(this.password != null ? 1 : 0)), (String)"The database password must be specified!");
        U.must((boolean)U.notEmpty((Object)(this.url != null ? 1 : 0)), (String)"The database connection URL must be specified!");
        U.must((boolean)U.notEmpty((Object)(this.driver != null ? 1 : 0)), (String)"The database driver must be specified!");
    }

    public Connection getConnection() {
        this.ensureIsInitialized();
        return this.provideConnection();
    }

    private static void close(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw U.rte((String)"Error occurred while closing the connection!", (Throwable)e);
        }
    }

    private static void close(PreparedStatement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            throw U.rte((String)"Error occurred while closing the statement!", (Throwable)e);
        }
    }

    private static void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            throw U.rte((String)"Error occurred while closing the ResultSet!", (Throwable)e);
        }
    }

    public int execute(String sql, Object ... args) {
        return this.doExecute(sql, null, args);
    }

    public int execute(String sql, Map<String, ?> namedArgs) {
        return this.doExecute(sql, namedArgs, null);
    }

    /*
     * Exception decompiling
     */
    private int doExecute(String sql, Map<String, ?> namedArgs, Object[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int tryToExecute(String sql, Object ... args) {
        return this.doTryToExecute(sql, null, args);
    }

    public int tryToExecute(String sql, Map<String, ?> namedArgs) {
        return this.doTryToExecute(sql, namedArgs, null);
    }

    private int doTryToExecute(String sql, Map<String, ?> namedArgs, Object[] args) {
        try {
            return this.doExecute(sql, namedArgs, args);
        }
        catch (Exception e) {
            Log.warn((String)"Ignoring JDBC error", (String)"error", (Object)Msc.errorMsg((Throwable)e));
            return 0;
        }
    }

    public <T> Results<T> query(Class<T> resultType, String sql, Object ... args) {
        return this.doQuery(resultType, null, sql, null, args);
    }

    public <T> Results<T> query(Class<T> resultType, String sql, Map<String, ?> namedArgs) {
        return this.doQuery(resultType, null, sql, namedArgs, null);
    }

    public <T> Results<T> query(Mapper<ResultSet, T> resultMapper, String sql, Object ... args) {
        return this.doQuery(null, resultMapper, sql, null, args);
    }

    public <T> Results<T> query(Mapper<ResultSet, T> resultMapper, String sql, Map<String, ?> namedArgs) {
        return this.doQuery(null, resultMapper, sql, namedArgs, null);
    }

    private <T> Results<T> doQuery(Class<T> resultType, Mapper<ResultSet, T> resultMapper, String sql, Map<String, ?> namedArgs, Object[] args) {
        sql = JdbcClient.toSql(sql);
        JdbcData<T> data = new JdbcData<T>(this, resultType, resultMapper, sql, namedArgs, args);
        return new ResultsImpl(data);
    }

    /*
     * Exception decompiling
     */
    <T> List<T> runQuery(Class<T> resultType, Mapper<ResultSet, T> resultMapper, String sql, Map<String, ?> namedArgs, Object[] args, long skip, long limit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    long getQueryCount(String sql, Map<String, ?> namedArgs, Object[] args) {
        return -1L;
    }

    private static String toSql(String sql) {
        if (sql.endsWith(".sql")) {
            sql = Res.from((String)sql, (String[])new String[0]).mustExist().getContent();
        }
        return sql;
    }

    public Results<Map<String, Object>> query(String sql, Object ... args) {
        return (Results)U.cast(this.query(Map.class, sql, args));
    }

    public Results<Map<String, Object>> query(String sql, Map<String, ?> namedArgs) {
        return (Results)U.cast(this.query(Map.class, sql, namedArgs));
    }

    private Connection provideConnection() {
        try {
            if (this.dataSource != null) {
                Connection conn = this.dataSource.getConnection();
                U.notNull((Object)conn, (String)"JDBC connection", (Object[])new Object[0]);
                return conn;
            }
            U.must((!this.usePool ? 1 : 0) != 0, (String)"Expecting connection pool, but the data source is null!");
            return this.getConnectionFromDriver();
        }
        catch (SQLException e) {
            throw U.rte((String)"Cannot create JDBC connection!", (Throwable)e);
        }
    }

    private Connection getConnectionFromDriver() throws SQLException {
        if (this.username != null) {
            String pass = U.safe((String)this.password);
            return DriverManager.getConnection(this.url, this.username, pass);
        }
        return DriverManager.getConnection(this.url);
    }

    public void release(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException e) {
            Log.error((String)"Error while releasing a JDBC connection!", (Throwable)e);
        }
    }

    public String username() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public String driver() {
        return this.driver;
    }

    public String url() {
        return this.url;
    }

    @Deprecated
    public DataSource pool() {
        return this.dataSource();
    }

    public String poolProvider() {
        return this.poolProvider;
    }

    public DataSource dataSource() {
        return this.dataSource;
    }

    public boolean usePool() {
        return this.usePool;
    }

    public ReadWriteMode mode() {
        return this.mode;
    }

    public JdbcClient init() {
        this.ensureIsInitialized();
        return this;
    }

    public String toString() {
        return "JdbcClient{initialized=" + this.initialized + ", username='" + this.username + '\'' + ", password='*" + '\'' + ", driver='" + this.driver + '\'' + ", url='" + this.url + '\'' + ", usePool=" + this.usePool + ", pool=" + this.dataSource + ", poolProvider=" + this.poolProvider + ", mode=" + (Object)((Object)this.mode) + '}';
    }

    public void execute(Operation<Connection> operation) {
        ((JdbcWorkers)((Object)this.workers.get())).execute(operation);
    }

    public void execute(final Callback<Void> callback, final Operation<Connection> operation) {
        this.execute(new Operation<Connection>(){

            public void execute(Connection conn) {
                try {
                    operation.execute((Object)conn);
                }
                catch (Throwable e) {
                    Callbacks.done((Callback)callback, null, (Throwable)e);
                    return;
                }
                Callbacks.done((Callback)callback, null, null);
            }
        });
    }

    public <T> void execute(final Mapper<ResultSet, T> resultMapper, final Callback<List<T>> callback, final String sql, final Object ... args) {
        this.execute(new Operation<Connection>(){

            public void execute(Connection conn) throws Exception {
                List results = U.list();
                try (PreparedStatement stmt = JdbcUtil.prepare(conn, sql, null, args);){
                    ResultSet rs = stmt.executeQuery();
                    while (rs.next()) {
                        results.add(resultMapper.map((Object)rs));
                    }
                }
                catch (Throwable e) {
                    Callbacks.done((Callback)callback, null, (Throwable)e);
                    return;
                }
                Callbacks.done((Callback)callback, (Object)results, null);
            }
        });
    }

    public DataSource bootstrapDatasource() {
        this.init();
        DataSource dataSource = this.dataSource();
        U.notNull((Object)dataSource, (String)"data source", (Object[])new Object[0]);
        return dataSource;
    }
}

