/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.rapidoid.log.Log;
import org.rapidoid.util.Constants;
import org.rapidoid.util.Dates;
import org.rapidoid.util.InterceptorProxy;
import org.rapidoid.util.TypeKind;
import org.rapidoid.util.U;
import org.rapidoid.var.Var;
import org.rapidoid.var.Vars;

public class Cls {
    private static Pattern JRE_CLASS_PATTERN = Pattern.compile("^(java|javax|javafx|com\\.sun|sun|com\\.oracle|oracle|jdk|org\\.omg|org\\.w3c).*");
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPERS = U.map((Object[])new Object[]{Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class, Void.TYPE, Void.class});
    private static final Map<String, TypeKind> KINDS = Cls.initKinds();

    private Cls() {
    }

    protected static Map<String, TypeKind> initKinds() {
        HashMap<String, TypeKind> kinds = new HashMap<String, TypeKind>();
        kinds.put("boolean", TypeKind.BOOLEAN);
        kinds.put("byte", TypeKind.BYTE);
        kinds.put("char", TypeKind.CHAR);
        kinds.put("short", TypeKind.SHORT);
        kinds.put("int", TypeKind.INT);
        kinds.put("long", TypeKind.LONG);
        kinds.put("float", TypeKind.FLOAT);
        kinds.put("double", TypeKind.DOUBLE);
        kinds.put("java.lang.String", TypeKind.STRING);
        kinds.put("java.lang.Boolean", TypeKind.BOOLEAN_OBJ);
        kinds.put("java.lang.Byte", TypeKind.BYTE_OBJ);
        kinds.put("java.lang.Character", TypeKind.CHAR_OBJ);
        kinds.put("java.lang.Short", TypeKind.SHORT_OBJ);
        kinds.put("java.lang.Integer", TypeKind.INT_OBJ);
        kinds.put("java.lang.Long", TypeKind.LONG_OBJ);
        kinds.put("java.lang.Float", TypeKind.FLOAT_OBJ);
        kinds.put("java.lang.Double", TypeKind.DOUBLE_OBJ);
        kinds.put("java.util.Date", TypeKind.DATE);
        return kinds;
    }

    public static TypeKind kindOf(Class<?> type) {
        String typeName = type.getName();
        TypeKind kind = KINDS.get(typeName);
        if (kind == null) {
            kind = TypeKind.OBJECT;
        }
        return kind;
    }

    public static TypeKind kindOf(Object value) {
        if (value == null) {
            return TypeKind.NULL;
        }
        String typeName = value.getClass().getName();
        TypeKind kind = KINDS.get(typeName);
        if (kind == null) {
            kind = TypeKind.OBJECT;
        }
        return kind;
    }

    public static void setFieldValue(Object instance, String fieldName, Object value) {
        try {
            for (Class<?> c = instance.getClass(); c != Object.class; c = c.getSuperclass()) {
                try {
                    Field field = c.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    field.set(instance, value);
                    field.setAccessible(false);
                    return;
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
            }
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot set field value!", (Throwable)e);
        }
        throw U.rte((String)"Cannot find the field '%s' in the class '%s'", (Object[])new Object[]{fieldName, instance.getClass()});
    }

    public static void setFieldValue(Field field, Object instance, Object value) {
        try {
            field.setAccessible(true);
            field.set(instance, value);
            field.setAccessible(false);
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot set field value!", (Throwable)e);
        }
    }

    public static <T> T getFieldValue(Object instance, String fieldName, T defaultValue) {
        try {
            return (T)Cls.getFieldValue(instance, fieldName);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Object getFieldValue(Object instance, String fieldName) {
        try {
            for (Class<?> c = instance.getClass(); c != Object.class; c = c.getSuperclass()) {
                try {
                    Field field = c.getDeclaredField(fieldName);
                    return Cls.getFieldValue(field, instance);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
            }
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot get field value!", (Throwable)e);
        }
        throw U.rte((String)"Cannot find the field '%s' in the class '%s'", (Object[])new Object[]{fieldName, instance.getClass()});
    }

    public static Object getFieldValue(Field field, Object instance) {
        try {
            field.setAccessible(true);
            Object value = field.get(instance);
            field.setAccessible(false);
            return value;
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot get field value!", (Throwable)e);
        }
    }

    public static List<Annotation> getAnnotations(Class<?> clazz) {
        List allAnnotations = U.list((Object[])new Object[0]);
        try {
            for (Class<?> c = clazz; c != Object.class; c = c.getSuperclass()) {
                Annotation[] annotations;
                for (Annotation an : annotations = c.getDeclaredAnnotations()) {
                    allAnnotations.add(an);
                }
            }
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot instantiate class!", (Throwable)e);
        }
        return allAnnotations;
    }

    public static List<Field> getFields(Class<?> clazz) {
        List allFields = U.list((Object[])new Object[0]);
        try {
            for (Class<?> c = clazz; c != Object.class; c = c.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = c.getDeclaredFields()) {
                    allFields.add(field);
                }
            }
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot instantiate class!", (Throwable)e);
        }
        return allFields;
    }

    public static List<Field> getFieldsAnnotated(Class<?> clazz, Class<? extends Annotation> annotation) {
        List annotatedFields = U.list((Object[])new Object[0]);
        try {
            for (Class<?> c = clazz; c != Object.class; c = c.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = c.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(annotation)) continue;
                    annotatedFields.add(field);
                }
            }
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot instantiate class!", (Throwable)e);
        }
        return annotatedFields;
    }

    public static List<Method> getMethodsAnnotated(Class<?> clazz, Class<? extends Annotation> annotation) {
        List annotatedMethods = U.list((Object[])new Object[0]);
        try {
            for (Class<?> c = clazz; c != Object.class; c = c.getSuperclass()) {
                Method[] methods;
                for (Method method : methods = c.getMethods()) {
                    if (!method.isAnnotationPresent(annotation)) continue;
                    annotatedMethods.add(method);
                }
            }
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot instantiate class!", (Throwable)e);
        }
        return annotatedMethods;
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw U.rte((String)"Cannot find method: %s", (Throwable)e, (Object[])new Object[]{name});
        }
        catch (SecurityException e) {
            throw U.rte((String)"Cannot access method: %s", (Throwable)e, (Object[])new Object[]{name});
        }
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static Field getField(Class<?> clazz, String name) {
        try {
            return clazz.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw U.rte((String)"Cannot find field: %s", (Throwable)e, (Object[])new Object[]{name});
        }
        catch (SecurityException e) {
            throw U.rte((String)"Cannot access field: %s", (Throwable)e, (Object[])new Object[]{name});
        }
    }

    public static Field findField(Class<?> clazz, String name) {
        try {
            return clazz.getField(name);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static <T> T invokeStatic(Method m, Object ... args) {
        boolean accessible = m.isAccessible();
        try {
            m.setAccessible(true);
            Object object = m.invoke(null, args);
            return (T)object;
        }
        catch (IllegalAccessException e) {
            throw U.rte((String)"Cannot statically invoke method '%s' with args: %s", (Throwable)e, (Object[])new Object[]{m.getName(), Arrays.toString(args)});
        }
        catch (IllegalArgumentException e) {
            throw U.rte((String)"Cannot statically invoke method '%s' with args: %s", (Throwable)e, (Object[])new Object[]{m.getName(), Arrays.toString(args)});
        }
        catch (InvocationTargetException e) {
            throw U.rte((String)"Cannot statically invoke method '%s' with args: %s", (Throwable)e, (Object[])new Object[]{m.getName(), Arrays.toString(args)});
        }
        finally {
            m.setAccessible(accessible);
        }
    }

    public static <T> T invoke(Method m, Object target, Object ... args) {
        boolean accessible = m.isAccessible();
        try {
            m.setAccessible(true);
            Object object = m.invoke(target, args);
            return (T)object;
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot invoke method '%s' with args: %s", (Throwable)e, (Object[])new Object[]{m.getName(), Arrays.toString(args)});
        }
        finally {
            m.setAccessible(accessible);
        }
    }

    public static Class<?>[] getImplementedInterfaces(Class<?> clazz) {
        try {
            LinkedList interfaces = new LinkedList();
            for (Class<?> c = clazz; c != Object.class; c = c.getSuperclass()) {
                for (Class<?> interf : c.getInterfaces()) {
                    interfaces.add(interf);
                }
            }
            return interfaces.toArray(new Class[interfaces.size()]);
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot retrieve implemented interfaces!", (Throwable)e);
        }
    }

    public static boolean annotatedMethod(Object instance, String methodName, Class<Annotation> annotation) {
        try {
            Method method = instance.getClass().getMethod(methodName, new Class[0]);
            return method.getAnnotation(annotation) != null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... paramTypes) {
        try {
            return clazz.getConstructor(paramTypes);
        }
        catch (Exception e) {
            throw U.rte((String)"Cannot find the constructor for %s with param types: %s", (Throwable)e, (Object[])new Object[]{clazz, Arrays.toString(paramTypes)});
        }
    }

    public static <T> T newInstance(Class<T> clazz, Map<String, Object> properties) {
        if (properties == null) {
            return Cls.newInstance(clazz);
        }
        Collection<Object> values = properties.values();
        for (Constructor<?> constr : clazz.getConstructors()) {
            Class<?>[] paramTypes = constr.getParameterTypes();
            Object[] args = Cls.getAssignableArgs(paramTypes, values);
            if (args == null) continue;
            try {
                return (T)constr.newInstance(args);
            }
            catch (Exception e) {
                throw U.rte((Throwable)e);
            }
        }
        throw U.rte((String)"Cannot find appropriate constructor for %s with args %s!", (Object[])new Object[]{clazz, values});
    }

    private static Object[] getAssignableArgs(Class<?>[] types, Collection<?> properties) {
        Object[] args = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            args[i] = Cls.getUniqueInstanceOf(type, properties);
        }
        return args;
    }

    public static <T> T getUniqueInstanceOf(Class<T> type, Collection<?> values) {
        T instance = null;
        for (Object obj : values) {
            if (!Cls.instanceOf(obj, type)) continue;
            if (instance == null) {
                instance = (T)obj;
                continue;
            }
            throw U.rte((String)"Found more than one instance of %s: %s and %s", (Object[])new Object[]{type, instance, obj});
        }
        return instance;
    }

    public static Object[] instantiateAll(Class<?> ... classes) {
        Object[] instances = new Object[classes.length];
        for (int i = 0; i < instances.length; ++i) {
            instances[i] = Cls.newInstance(classes[i]);
        }
        return instances;
    }

    public static Object[] instantiateAll(Collection<Class<?>> classes) {
        if (classes.isEmpty()) {
            return Constants.EMPTY_ARRAY;
        }
        Object[] instances = new Object[classes.size()];
        int i = 0;
        for (Class<?> clazz : classes) {
            instances[i++] = Cls.newInstance(clazz);
        }
        return instances;
    }

    public static <T> T createProxy(InvocationHandler handler, Class<?> ... interfaces) {
        return (T)Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, handler);
    }

    public static ClassLoader classLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static <T> T implement(final Object target, final InvocationHandler handler, Class<?> ... interfaces) {
        final Class<?> targetClass = target.getClass();
        return Cls.createProxy(new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass().isAssignableFrom(targetClass)) {
                    return method.invoke(target, args);
                }
                return handler.invoke(proxy, method, args);
            }
        }, interfaces);
    }

    public static <T> T implement(InvocationHandler handler, Class<?> ... classes) {
        return Cls.implement(new InterceptorProxy(U.readable((Object[])classes)), handler, classes);
    }

    public static <T> T implementInterfaces(Object target, InvocationHandler handler) {
        return Cls.implement(target, handler, Cls.getImplementedInterfaces(target.getClass()));
    }

    public static <T> T tracer(Object target) {
        return Cls.implementInterfaces(target, new InvocationHandler(){

            @Override
            public Object invoke(Object target, Method method, Object[] args) throws Throwable {
                Log.trace((String)"intercepting", (String)"method", (Object)method.getName(), (String)"args", (Object)Arrays.toString(args));
                return method.invoke(target, args);
            }
        });
    }

    public static <T> T convert(String value, Class<T> toType) {
        if (value == null) {
            return null;
        }
        if (toType.equals(Object.class)) {
            return (T)value;
        }
        if (Enum.class.isAssignableFrom(toType)) {
            T[] ens;
            for (T t : ens = toType.getEnumConstants()) {
                Enum en = (Enum)t;
                if (!en.name().equalsIgnoreCase(value)) continue;
                return (T)en;
            }
            throw U.rte((String)"Cannot find the enum constant: %s.%s", (Object[])new Object[]{toType, value});
        }
        TypeKind targetKind = Cls.kindOf(toType);
        switch (targetKind) {
            case NULL: {
                throw U.notExpected();
            }
            case BOOLEAN: 
            case BOOLEAN_OBJ: {
                if ("y".equalsIgnoreCase(value) || "t".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value)) {
                    return (T)Boolean.TRUE;
                }
                if ("n".equalsIgnoreCase(value) || "f".equalsIgnoreCase(value) || "no".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
                    return (T)Boolean.FALSE;
                }
                throw U.rte((String)"Cannot convert the string value '%s' to boolean!", (Object[])new Object[]{value});
            }
            case BYTE: 
            case BYTE_OBJ: {
                return (T)new Byte(value);
            }
            case SHORT: 
            case SHORT_OBJ: {
                return (T)new Short(value);
            }
            case CHAR: 
            case CHAR_OBJ: {
                return (T)new Character(value.charAt(0));
            }
            case INT: 
            case INT_OBJ: {
                return (T)new Integer(value);
            }
            case LONG: 
            case LONG_OBJ: {
                return (T)new Long(value);
            }
            case FLOAT: 
            case FLOAT_OBJ: {
                return (T)new Float(value);
            }
            case DOUBLE: 
            case DOUBLE_OBJ: {
                return (T)new Double(value);
            }
            case STRING: {
                return (T)value;
            }
            case OBJECT: {
                throw U.rte((String)"Cannot convert string value to type '%s'!", (Object[])new Object[]{toType});
            }
            case DATE: {
                return (T)Dates.date(value);
            }
        }
        throw U.notExpected();
    }

    public static <T> T convert(Object value, Class<T> toType) {
        if (value == null) {
            return null;
        }
        if (toType.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        if (toType.equals(Object.class)) {
            return (T)value;
        }
        if (value instanceof String) {
            return Cls.convert((String)value, toType);
        }
        TypeKind targetKind = Cls.kindOf(toType);
        boolean isNum = value instanceof Number;
        switch (targetKind) {
            case NULL: {
                throw U.notExpected();
            }
            case BOOLEAN: 
            case BOOLEAN_OBJ: {
                if (value instanceof Boolean) {
                    return (T)value;
                }
                throw U.rte((String)"Cannot convert the value '%s' to boolean!", (Object[])new Object[]{value});
            }
            case BYTE: 
            case BYTE_OBJ: {
                if (isNum) {
                    return (T)new Byte(((Number)value).byteValue());
                }
                throw U.rte((String)"Cannot convert the value '%s' to byte!", (Object[])new Object[]{value});
            }
            case SHORT: 
            case SHORT_OBJ: {
                if (isNum) {
                    return (T)new Short(((Number)value).shortValue());
                }
                throw U.rte((String)"Cannot convert the value '%s' to short!", (Object[])new Object[]{value});
            }
            case CHAR: 
            case CHAR_OBJ: {
                if (isNum) {
                    return (T)new Character((char)((Number)value).intValue());
                }
                throw U.rte((String)"Cannot convert the value '%s' to char!", (Object[])new Object[]{value});
            }
            case INT: 
            case INT_OBJ: {
                if (isNum) {
                    return (T)new Integer(((Number)value).intValue());
                }
                throw U.rte((String)"Cannot convert the value '%s' to int!", (Object[])new Object[]{value});
            }
            case LONG: 
            case LONG_OBJ: {
                if (isNum) {
                    return (T)new Long(((Number)value).longValue());
                }
                throw U.rte((String)"Cannot convert the value '%s' to long!", (Object[])new Object[]{value});
            }
            case FLOAT: 
            case FLOAT_OBJ: {
                if (isNum) {
                    return (T)new Float(((Number)value).floatValue());
                }
                throw U.rte((String)"Cannot convert the value '%s' to float!", (Object[])new Object[]{value});
            }
            case DOUBLE: 
            case DOUBLE_OBJ: {
                if (isNum) {
                    return (T)new Double(((Number)value).doubleValue());
                }
                throw U.rte((String)"Cannot convert the value '%s' to double!", (Object[])new Object[]{value});
            }
            case STRING: {
                if (value instanceof Date) {
                    return (T)Dates.str((Date)value);
                }
                return (T)U.readable((Object)value);
            }
            case OBJECT: {
                throw U.rte((String)"Cannot convert the value to type '%s'!", (Object[])new Object[]{toType});
            }
            case DATE: {
                if (value instanceof Date) {
                    return (T)value;
                }
                if (value instanceof Number) {
                    return (T)new Date(((Number)value).longValue());
                }
                throw U.rte((String)"Cannot convert the value '%s' to date!", (Object[])new Object[]{value});
            }
        }
        throw U.notExpected();
    }

    public static Map<String, Class<?>> classMap(Iterable<Class<?>> classes) {
        LinkedHashMap map = new LinkedHashMap();
        for (Class<?> cls : classes) {
            map.put(cls.getSimpleName(), cls);
        }
        return map;
    }

    public static Class<?>[] typesOf(Object[] args) {
        Class[] types = new Class[args.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = args[i] != null ? args[i].getClass() : null;
        }
        return types;
    }

    public static Method findMethodByArgs(Class<? extends Object> clazz, String name, Object ... args) {
        for (Method method : clazz.getMethods()) {
            Class<?>[] paramTypes = method.getParameterTypes();
            if (!method.getName().equals(name) || !Cls.areAssignable(paramTypes, args)) continue;
            return method;
        }
        return null;
    }

    public static <T> Class<T> clazz(Type type) {
        return (Class)(type instanceof Class ? type : Object.class);
    }

    public static Class<?> of(Object obj) {
        return obj != null ? obj.getClass() : Object.class;
    }

    public static Object str(Object value) {
        return Cls.convert(value, String.class);
    }

    public static ParameterizedType generic(Type type) {
        return type instanceof ParameterizedType ? (ParameterizedType)type : null;
    }

    public static boolean isJREClass(String canonicalClassName) {
        return JRE_CLASS_PATTERN.matcher(canonicalClassName).matches();
    }

    public static <T> Class<T> getWrapperClass(Class<T> c) {
        U.must((boolean)c.isPrimitive());
        return c.isPrimitive() ? PRIMITIVE_WRAPPERS.get(c) : c;
    }

    public static boolean instanceOf(Object obj, Class<?> ... classes) {
        return obj != null ? Cls.isAssignableTo(obj.getClass(), classes) : false;
    }

    public static boolean isAssignableTo(Class<?> clazz, Class<?> ... targetClasses) {
        for (Class<?> cls : targetClasses) {
            if (cls.isPrimitive()) {
                if (cls.isAssignableFrom(clazz)) {
                    return true;
                }
                cls = Cls.getWrapperClass(cls);
            }
            if (!cls.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean areAssignable(Class<?>[] types, Object[] values) {
        if (types.length != values.length) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            Object val = values[i];
            if (val == null || Cls.instanceOf(val, types[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> T newInstance(Class<T> clazz) {
        if (clazz == List.class) {
            return (T)U.list((Object[])new Object[0]);
        }
        if (clazz == Set.class) {
            return (T)U.set((Object[])new Object[0]);
        }
        if (clazz == Map.class) {
            return (T)U.map();
        }
        if (clazz == ConcurrentMap.class) {
            return (T)U.concurrentMap();
        }
        if (clazz == Var.class) {
            return (T)Vars.var(null);
        }
        if (clazz == Object.class) {
            return (T)new Object();
        }
        try {
            Constructor<T> constr = clazz.getDeclaredConstructor(new Class[0]);
            boolean accessible = constr.isAccessible();
            constr.setAccessible(true);
            T obj = constr.newInstance(new Object[0]);
            constr.setAccessible(accessible);
            return obj;
        }
        catch (Exception e) {
            throw U.rte((Throwable)e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) {
        for (Constructor<?> constr : clazz.getConstructors()) {
            Class<?>[] paramTypes = constr.getParameterTypes();
            if (!Cls.areAssignable(paramTypes, args)) continue;
            try {
                boolean accessible = constr.isAccessible();
                constr.setAccessible(true);
                Object obj = constr.newInstance(args);
                constr.setAccessible(accessible);
                return (T)obj;
            }
            catch (Exception e) {
                throw U.rte((Throwable)e);
            }
        }
        throw U.rte((String)"Cannot find appropriate constructor for %s with args %s!", (Object[])new Object[]{clazz, U.readable((Object[])args)});
    }

    public static <T> T customizable(Class<T> clazz, Object ... args) {
        String customClassName = "Customized" + clazz.getSimpleName();
        Class<T> customClass = Cls.getClassIfExists(customClassName);
        if (customClass == null) {
            customClass = Cls.getClassIfExists("custom." + customClassName);
        }
        if (customClass != null && !clazz.isAssignableFrom(customClass)) {
            customClass = null;
        }
        return Cls.newInstance((Class)U.or(customClass, clazz), args);
    }

    public static <T> Class<T> getClassIfExists(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Class<?> unproxy(Class<?> cls) {
        if (Proxy.class.isAssignableFrom(cls)) {
            for (Class<?> interf : cls.getInterfaces()) {
                if (Cls.isJREClass(interf.getCanonicalName())) continue;
                return interf;
            }
            throw U.rte((String)"Cannot unproxy the class: %s!", (Object[])new Object[]{cls});
        }
        return cls;
    }

    public static String entityName(Class<?> cls) {
        return Cls.unproxy(cls).getSimpleName();
    }

    public static String entityName(Object entity) {
        U.notNull((Object)entity, (String)"entity", (Object[])new Object[0]);
        return Cls.entityName(entity.getClass());
    }
}

