/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import java.util.Map;
import java.util.regex.Pattern;
import org.rapidoid.util.IO;
import org.rapidoid.util.U;

public class English {
    private static final Pattern PLURAL1 = Pattern.compile(".*(s|x|z|ch|sh)$");
    private static final Pattern PLURAL1U = Pattern.compile(".*(S|X|Z|CH|SH)$");
    private static final Pattern PLURAL2 = Pattern.compile(".*[bcdfghjklmnpqrstvwxz]o$");
    private static final Pattern PLURAL2U = Pattern.compile(".*[BCDFGHJKLMNPQRSTVWXZ]O$");
    private static final Pattern PLURAL3 = Pattern.compile(".*[bcdfghjklmnpqrstvwxz]y$");
    private static final Pattern PLURAL3U = Pattern.compile(".*[BCDFGHJKLMNPQRSTVWXZ]Y$");
    private static final Map<String, String> IRREGULAR_PLURAL = IO.loadMap("irregular-plural.txt");

    public static String plural(String s) {
        if (U.isEmpty((String)s)) {
            return s;
        }
        if (IRREGULAR_PLURAL.containsKey(s.toLowerCase())) {
            boolean capital = Character.isUpperCase(s.charAt(0));
            boolean upper = Character.isUpperCase(s.charAt(s.length() - 1));
            String pl = IRREGULAR_PLURAL.get(s.toLowerCase());
            if (upper) {
                return pl.toUpperCase();
            }
            return capital ? U.capitalized((String)pl) : pl;
        }
        if (PLURAL1.matcher(s).matches()) {
            return s + "es";
        }
        if (PLURAL2.matcher(s).matches()) {
            return s + "es";
        }
        if (PLURAL3.matcher(s).matches()) {
            return U.mid((String)s, (int)0, (int)-1) + "ies";
        }
        if (PLURAL1U.matcher(s).matches()) {
            return s + "ES";
        }
        if (PLURAL2U.matcher(s).matches()) {
            return s + "ES";
        }
        if (PLURAL3U.matcher(s).matches()) {
            return U.mid((String)s, (int)0, (int)-1) + "IES";
        }
        boolean upper = Character.isUpperCase(s.charAt(s.length() - 1));
        return s + (upper ? "S" : "s");
    }
}

