/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.var;

import java.util.Collection;
import org.rapidoid.var.Var;
import org.rapidoid.var.impl.ArrayContainerVar;
import org.rapidoid.var.impl.CollectionContainerVar;
import org.rapidoid.var.impl.EqualityVar;
import org.rapidoid.var.impl.MandatoryVar;
import org.rapidoid.var.impl.SimpleVar;

public class Vars {
    public static <T> Var<T> var(T value) {
        return new SimpleVar<T>(value);
    }

    public static <T> Var<T>[] vars(T ... values) {
        Var[] vars = new Var[values.length];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = Vars.var(values[i]);
        }
        return vars;
    }

    public static Var<Boolean> eq(Var<?> var, Object value) {
        return new EqualityVar(var, value);
    }

    public static Var<Boolean> has(Var<?> container, Object item) {
        Object arrOrColl = container.get();
        if (arrOrColl instanceof Collection) {
            return new CollectionContainerVar(container, item);
        }
        return new ArrayContainerVar(container, item);
    }

    public static <T> Var<T> mandatory(Var<T> var) {
        return new MandatoryVar<T>(var);
    }

    public static <T> T unwrap(T value) {
        return value instanceof Var ? ((Var)value).get() : value;
    }

    public static <T> Var<T> cast(Object value) {
        return (Var)value;
    }
}

