/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.aop;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.rapidoid.aop.AOPInterceptor;
import org.rapidoid.cls.Cls;
import org.rapidoid.util.U;

public class AOP {
    private static Map<Class<? extends Annotation>, AOPInterceptor> INTERCEPTORS = U.synchronizedMap();

    public static void register(Class<? extends Annotation> annotated, AOPInterceptor interceptor) {
        INTERCEPTORS.put(annotated, interceptor);
    }

    public static <T> T invoke(Object ctx, Method m, Object target, Object ... args) {
        for (Annotation ann : m.getAnnotations()) {
            Class<? extends Annotation> annotation = ann.annotationType();
            AOPInterceptor interceptor = INTERCEPTORS.get(annotation);
            if (interceptor == null) continue;
            return (T)interceptor.intercept(ann, ctx, m, target, args);
        }
        return (T)Cls.invoke((Method)m, (Object)target, (Object[])args);
    }
}

