/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard;

import org.refcodes.checkerboard.Neighbourhood;
import org.refcodes.exception.BugException;

public enum MooreNeighbourhood implements Neighbourhood<MooreNeighbourhood>
{
    LEFT(-1, 0),
    TOP_LEFT(-1, -1),
    TOP(0, -1),
    TOP_RIGHT(1, -1),
    RIGHT(1, 0),
    BOTTOM_RIGHT(1, 1),
    BOTTOM(1, 0),
    BOTTOM_LEFT(-1, 1);

    private int _posX;
    private int _posY;

    private MooreNeighbourhood(int aPosX, int aPosY) {
        this._posX = aPosX;
        this._posY = aPosY;
    }

    @Override
    public int getPositionX() {
        return this._posX;
    }

    @Override
    public int getPositionY() {
        return this._posY;
    }

    @Override
    public MooreNeighbourhood clockwiseNext() {
        switch (this) {
            case TOP: {
                return TOP_RIGHT;
            }
            case TOP_RIGHT: {
                return RIGHT;
            }
            case RIGHT: {
                return BOTTOM_RIGHT;
            }
            case BOTTOM_RIGHT: {
                return BOTTOM;
            }
            case BOTTOM: {
                return BOTTOM_LEFT;
            }
            case BOTTOM_LEFT: {
                return LEFT;
            }
            case LEFT: {
                return TOP_LEFT;
            }
            case TOP_LEFT: {
                return TOP;
            }
        }
        throw new BugException("This method is missing the implementation for the state <" + this.name() + ">.");
    }

    @Override
    public MooreNeighbourhood clockwisePrevious() {
        switch (this) {
            case TOP: {
                return TOP_LEFT;
            }
            case TOP_LEFT: {
                return LEFT;
            }
            case LEFT: {
                return BOTTOM_LEFT;
            }
            case BOTTOM_LEFT: {
                return BOTTOM;
            }
            case BOTTOM: {
                return BOTTOM_RIGHT;
            }
            case BOTTOM_RIGHT: {
                return RIGHT;
            }
            case RIGHT: {
                return TOP_RIGHT;
            }
            case TOP_RIGHT: {
                return TOP;
            }
        }
        throw new BugException("This method is missing the implementation for the state <" + this.name() + ">.");
    }
}

