/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.component;

import org.refcodes.component.ConnectionComponent;
import org.refcodes.component.ConnectionStatus;
import org.refcodes.component.OpenException;

public class ConnectionAutomatonImpl<CON>
implements ConnectionComponent.ConnectionAutomaton<CON> {
    private ConnectionStatus _connectionStatus = ConnectionStatus.NONE;
    protected ConnectionComponent<CON> _connectionComponent = null;

    public ConnectionAutomatonImpl() {
    }

    public ConnectionAutomatonImpl(ConnectionComponent<CON> aConnectionComponent) {
        this._connectionComponent = aConnectionComponent;
    }

    @Override
    public synchronized ConnectionStatus getConnectionStatus() {
        return this._connectionStatus;
    }

    @Override
    public boolean isOpenable(CON aConnection) {
        boolean isConnectable;
        boolean bl = isConnectable = this._connectionStatus == ConnectionStatus.NONE || this.isClosed();
        if (isConnectable && this._connectionComponent != null && this._connectionComponent instanceof ConnectionComponent.ConnectionAutomaton) {
            ConnectionComponent.ConnectionAutomaton theContactAutomaton = (ConnectionComponent.ConnectionAutomaton)this._connectionComponent;
            return theContactAutomaton.isOpenable(aConnection);
        }
        return isConnectable;
    }

    @Override
    public void open(CON aConnection) throws OpenException {
        if (!this.isOpenable(aConnection)) {
            throw new OpenException("Cannot open as the component is in status <" + (Object)((Object)this._connectionStatus) + "> which is not the appropriate status for opening.");
        }
        if (this._connectionComponent != null) {
            this._connectionComponent.open(aConnection);
        }
        this._connectionStatus = ConnectionStatus.OPENED;
    }

    @Override
    public boolean isOpened() {
        return this._connectionStatus == ConnectionStatus.OPENED;
    }

    @Override
    public boolean isClosable() {
        return this._connectionStatus == ConnectionStatus.OPENED;
    }

    @Override
    public boolean isClosed() {
        return this._connectionStatus == ConnectionStatus.CLOSED;
    }

    @Override
    public void close() {
        if (this.isOpened()) {
            try {
                if (this._connectionComponent != null) {
                    this._connectionComponent.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._connectionStatus = ConnectionStatus.CLOSED;
    }
}

