/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.component;

import org.refcodes.component.RunningAccessor;
import org.refcodes.component.StartException;
import org.refcodes.exception.HiddenException;

public interface Startable {
    public void start() throws StartException;

    default public void startUnchecked() {
        try {
            this.start();
        }
        catch (StartException e) {
            throw new HiddenException(e);
        }
    }

    public static interface UncheckedStartable
    extends Startable {
        @Override
        public void start();
    }

    public static interface StartBuilder<B extends StartBuilder<B>> {
        public B withStart() throws StartException;

        default public B withStartUnchecked() {
            try {
                return this.withStart();
            }
            catch (StartException e) {
                throw new HiddenException(e);
            }
        }
    }

    public static interface StartAutomaton
    extends Startable,
    RunningAccessor {
        public boolean isStartable();
    }
}

