/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.criteria;

import java.util.Iterator;
import org.refcodes.criteria.AndCriteria;
import org.refcodes.criteria.Criteria;
import org.refcodes.criteria.CriteriaLeaf;
import org.refcodes.criteria.EqualWithCriteria;
import org.refcodes.criteria.GreaterOrEqualThanCriteria;
import org.refcodes.criteria.GreaterThanCriteria;
import org.refcodes.criteria.IntersectWithCriteria;
import org.refcodes.criteria.LessOrEqualThanCriteria;
import org.refcodes.criteria.LessThanCriteria;
import org.refcodes.criteria.NotCriteria;
import org.refcodes.criteria.NotEqualWithCriteria;
import org.refcodes.criteria.OrCriteria;
import org.refcodes.criteria.QueryFactory;
import org.refcodes.criteria.UnknownCriteriaRuntimeException;
import org.refcodes.data.Literal;
import org.refcodes.data.QuotationMark;

public class ExpressionQueryFactoryImpl
implements QueryFactory<String> {
    private static final String IS = " IS ";
    private static final String EQUAL_WITH = " = ";
    private static final String IS_NOT = " IS NOT ";
    private static final String NOT_EQUAL_WITH = " != ";
    private static final String GREATER_THAN = " > ";
    private static final String GREATER_OR_EQUAL_THAN = " >= ";
    private static final String LESS_THAN = " < ";
    private static final String LESS_OR_EQUAL_THAN = " <= ";
    private static final String AND = " AND ";
    private static final String OR = " OR ";
    private static final String NOT = "NOT ";
    private static final String INTERSECTION = " INTERSECTION ";
    private static final String SINGLE_QUOTE = "" + QuotationMark.SINGLE_QUOTE.getChar();
    private static final String DELIMITER = ", ";
    private static final String BRACE_OPEN = "( ";
    private static final String BRACE_CLOSE = " )";

    @Override
    public String fromCriteria(Criteria aCriteria) {
        return this.toQuery(aCriteria, true);
    }

    private String toQuery(NotCriteria aCriteriaNode, boolean isCriteriaTreeRoot) {
        StringBuffer theQueryBuffer = new StringBuffer();
        theQueryBuffer.append(NOT);
        Iterator<Criteria> e = aCriteriaNode.getChildren().iterator();
        while (e.hasNext()) {
            theQueryBuffer.append(this.toQuery(e.next(), false));
            if (!e.hasNext()) continue;
            theQueryBuffer.append(DELIMITER);
        }
        return theQueryBuffer.toString();
    }

    private String toQuery(AndCriteria aCriteriaNode, boolean isCriteriaTreeRoot) {
        StringBuffer theQueryBuffer = new StringBuffer();
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_OPEN);
        }
        Iterator<Criteria> e = aCriteriaNode.getChildren().iterator();
        while (e.hasNext()) {
            theQueryBuffer.append(this.toQuery(e.next(), false));
            if (!e.hasNext()) continue;
            theQueryBuffer.append(AND);
        }
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_CLOSE);
        }
        return theQueryBuffer.toString();
    }

    private String toQuery(OrCriteria aCriteriaNode, boolean isCriteriaTreeRoot) {
        StringBuffer theQueryBuffer = new StringBuffer();
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_OPEN);
        }
        Iterator<Criteria> e = aCriteriaNode.getChildren().iterator();
        while (e.hasNext()) {
            theQueryBuffer.append(this.toQuery(e.next(), false));
            if (!e.hasNext()) continue;
            theQueryBuffer.append(OR);
        }
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_CLOSE);
        }
        return theQueryBuffer.toString();
    }

    public String toQuery(IntersectWithCriteria aCriteriaNode, boolean isCriteriaTreeRoot) {
        StringBuffer theQueryBuffer = new StringBuffer();
        Iterator<Criteria> e = aCriteriaNode.getChildren().iterator();
        while (e.hasNext()) {
            theQueryBuffer.append(this.toQuery(e.next(), false));
            if (!e.hasNext()) continue;
            theQueryBuffer.append(INTERSECTION);
        }
        return theQueryBuffer.toString();
    }

    private String toQuery(EqualWithCriteria<?> aCriteriaLeaf, boolean isCriteriaTreeRoot) {
        StringBuffer theQueryBuffer = new StringBuffer();
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_OPEN);
        }
        theQueryBuffer.append((String)aCriteriaLeaf.getKey());
        if (Literal.NULL.getName().equalsIgnoreCase(aCriteriaLeaf.getValue().toString())) {
            theQueryBuffer.append(IS);
        } else {
            theQueryBuffer.append(EQUAL_WITH);
        }
        this.doAppendCriteriaLeaf(aCriteriaLeaf, theQueryBuffer);
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_CLOSE);
        }
        return theQueryBuffer.toString();
    }

    private String toQuery(NotEqualWithCriteria<?> aCriteriaLeaf, boolean isCriteriaTreeRoot) {
        StringBuffer theQueryBuffer = new StringBuffer();
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_OPEN);
        }
        theQueryBuffer.append((String)aCriteriaLeaf.getKey());
        if (this.isNullCriteriaLeaf(aCriteriaLeaf)) {
            theQueryBuffer.append(IS_NOT);
        } else {
            theQueryBuffer.append(NOT_EQUAL_WITH);
        }
        this.doAppendCriteriaLeaf(aCriteriaLeaf, theQueryBuffer);
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_CLOSE);
        }
        return theQueryBuffer.toString();
    }

    private String toQuery(GreaterThanCriteria<?> aCriteriaLeaf, boolean isCriteriaTreeRoot) {
        StringBuffer theQueryBuffer = new StringBuffer();
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_OPEN);
        }
        theQueryBuffer.append((String)aCriteriaLeaf.getKey());
        theQueryBuffer.append(GREATER_THAN);
        this.doAppendCriteriaLeaf(aCriteriaLeaf, theQueryBuffer);
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_CLOSE);
        }
        return theQueryBuffer.toString();
    }

    private String toQuery(GreaterOrEqualThanCriteria<?> aCriteriaLeaf, boolean isCriteriaTreeRoot) {
        StringBuffer theQueryBuffer = new StringBuffer();
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_OPEN);
        }
        theQueryBuffer.append((String)aCriteriaLeaf.getKey());
        theQueryBuffer.append(GREATER_OR_EQUAL_THAN);
        this.doAppendCriteriaLeaf(aCriteriaLeaf, theQueryBuffer);
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_CLOSE);
        }
        return theQueryBuffer.toString();
    }

    public String toQuery(LessThanCriteria<?> aCriteriaLeaf, boolean isCriteriaTreeRoot) {
        StringBuffer theQueryBuffer = new StringBuffer();
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_OPEN);
        }
        theQueryBuffer.append((String)aCriteriaLeaf.getKey());
        theQueryBuffer.append(LESS_THAN);
        this.doAppendCriteriaLeaf(aCriteriaLeaf, theQueryBuffer);
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_CLOSE);
        }
        return theQueryBuffer.toString();
    }

    private String toQuery(LessOrEqualThanCriteria<?> aCriteriaLeaf, boolean isCriteriaTreeRoot) {
        StringBuffer theQueryBuffer = new StringBuffer();
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_OPEN);
        }
        theQueryBuffer.append((String)aCriteriaLeaf.getKey());
        theQueryBuffer.append(LESS_OR_EQUAL_THAN);
        this.doAppendCriteriaLeaf(aCriteriaLeaf, theQueryBuffer);
        if (!isCriteriaTreeRoot) {
            theQueryBuffer.append(BRACE_CLOSE);
        }
        return theQueryBuffer.toString();
    }

    private String toQuery(Criteria aCriteria, boolean isCriteriaTreeRoot) {
        if (aCriteria instanceof AndCriteria) {
            return this.toQuery((AndCriteria)aCriteria, isCriteriaTreeRoot);
        }
        if (aCriteria instanceof OrCriteria) {
            return this.toQuery((OrCriteria)aCriteria, isCriteriaTreeRoot);
        }
        if (aCriteria instanceof NotCriteria) {
            return this.toQuery((NotCriteria)aCriteria, isCriteriaTreeRoot);
        }
        if (aCriteria instanceof IntersectWithCriteria) {
            return this.toQuery((IntersectWithCriteria)aCriteria, isCriteriaTreeRoot);
        }
        if (aCriteria instanceof EqualWithCriteria) {
            return this.toQuery((EqualWithCriteria)aCriteria, isCriteriaTreeRoot);
        }
        if (aCriteria instanceof NotEqualWithCriteria) {
            return this.toQuery((NotEqualWithCriteria)aCriteria, isCriteriaTreeRoot);
        }
        if (aCriteria instanceof GreaterThanCriteria) {
            return this.toQuery((GreaterThanCriteria)aCriteria, isCriteriaTreeRoot);
        }
        if (aCriteria instanceof GreaterOrEqualThanCriteria) {
            return this.toQuery((GreaterOrEqualThanCriteria)aCriteria, isCriteriaTreeRoot);
        }
        if (aCriteria instanceof LessThanCriteria) {
            return this.toQuery((LessThanCriteria)aCriteria, isCriteriaTreeRoot);
        }
        if (aCriteria instanceof LessOrEqualThanCriteria) {
            return this.toQuery((LessOrEqualThanCriteria)aCriteria, isCriteriaTreeRoot);
        }
        throw new UnknownCriteriaRuntimeException(aCriteria, "The criteria with Name \"" + aCriteria.getName() + "\" is unknwon by this query factory.");
    }

    private void doAppendCriteriaLeaf(CriteriaLeaf<?> aCriteriaLeaf, StringBuffer aQueryBuffer) {
        boolean isQuote;
        boolean bl = isQuote = !(aCriteriaLeaf.getValue() instanceof Number) && !this.isNullCriteriaLeaf(aCriteriaLeaf);
        if (isQuote) {
            aQueryBuffer.append(SINGLE_QUOTE);
        }
        if (this.isNullCriteriaLeaf(aCriteriaLeaf)) {
            aQueryBuffer.append(Literal.NULL.getName().toUpperCase());
        } else {
            aQueryBuffer.append(aCriteriaLeaf.getValue());
        }
        if (isQuote) {
            aQueryBuffer.append(SINGLE_QUOTE);
        }
    }

    private boolean isNullCriteriaLeaf(CriteriaLeaf<?> aCriteriaLeaf) {
        return aCriteriaLeaf.getValue() instanceof String && ((String)aCriteriaLeaf.getValue()).equalsIgnoreCase(Literal.NULL.getName());
    }
}

