/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.graphical;

import java.io.InputStream;
import java.net.URL;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import org.refcodes.graphical.Dimension;
import org.refcodes.graphical.RgbPixel;
import org.refcodes.graphical.RgbPixelImpl;
import org.refcodes.graphical.RgbPixmap;
import org.refcodes.graphical.RgbPixmapImageBuilder;
import org.refcodes.graphical.RgbPixmapImpl;

public class RgbPixmapImageBuilderImpl
implements RgbPixmapImageBuilder {
    private InputStream _imageStream = null;
    private URL _imageUrl = null;
    private int _width = -1;
    private int _height = -1;

    @Override
    public int getWidth() {
        return this._width;
    }

    @Override
    public int getHeight() {
        return this._height;
    }

    @Override
    public void setDimension(int aWidth, int aHeight) {
        this._width = aWidth;
        this._height = aHeight;
    }

    @Override
    public void setDimension(Dimension aDimension) {
        this._width = aDimension.getWidth();
        this._height = aDimension.getHeight();
    }

    @Override
    public void setWidth(int aWidth) {
        this._width = aWidth;
    }

    @Override
    public void setHeight(int aHeight) {
        this._height = aHeight;
    }

    @Override
    public RgbPixmapImageBuilder withDimension(int aWidth, int aHeight) {
        this.setDimension(aWidth, aHeight);
        return this;
    }

    @Override
    public RgbPixmapImageBuilder withDimension(Dimension aDimension) {
        this.setDimension(aDimension);
        return this;
    }

    @Override
    public RgbPixmapImageBuilder withWidth(int aWidth) {
        this.setWidth(aWidth);
        return this;
    }

    @Override
    public RgbPixmapImageBuilder withHeight(int aHeight) {
        this.setHeight(aHeight);
        return this;
    }

    @Override
    public void setImageInputStream(InputStream aImageStream) {
        this._imageStream = aImageStream;
        this._imageUrl = null;
    }

    @Override
    public void setImageURL(URL aImageUrl) {
        this._imageStream = null;
        this._imageUrl = aImageUrl;
    }

    @Override
    public RgbPixmap toPixmap() {
        if (this._imageUrl != null) {
            return RgbPixmapImageBuilderImpl.toPixmap(new Image(this._imageUrl.toString(), (double)this._width, (double)this._height, true, false));
        }
        if (this._imageStream != null) {
            return RgbPixmapImageBuilderImpl.toPixmap(new Image(this._imageStream, (double)this._width, (double)this._height, true, false));
        }
        throw new IllegalStateException("Either an image URL or an image Input-Stream (File) must be set to produce a pixmap!");
    }

    @Override
    public RgbPixmap toPixmap(URL aImageUrl) {
        return RgbPixmapImageBuilderImpl.toPixmap(new Image(aImageUrl.toString(), (double)this._width, (double)this._height, true, false));
    }

    @Override
    public RgbPixmap toPixmap(InputStream aImageStream) {
        return RgbPixmapImageBuilderImpl.toPixmap(new Image(aImageStream, (double)this._width, (double)this._height, true, false));
    }

    protected static RgbPixmap toPixmap(Image aImage) {
        int theWidth = (int)aImage.getWidth();
        int theHeight = (int)aImage.getHeight();
        RgbPixel[][] thePixels = new RgbPixel[theWidth][theHeight];
        RgbPixmapImpl thePixmap = new RgbPixmapImpl(thePixels);
        PixelReader theReader = aImage.getPixelReader();
        for (int x = 0; x < theWidth; ++x) {
            for (int y = 0; y < theHeight; ++y) {
                thePixels[x][y] = new RgbPixelImpl(theReader.getArgb(x, y));
            }
        }
        return thePixmap;
    }
}

