/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.tabular;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.refcodes.exception.HiddenException;
import org.refcodes.tabular.Column;
import org.refcodes.tabular.ColumnMismatchException;
import org.refcodes.tabular.HeaderMismatchException;
import org.refcodes.tabular.HeaderTemplate;
import org.refcodes.tabular.Record;
import org.refcodes.tabular.RecordImpl;
import org.refcodes.tabular.Row;
import org.refcodes.tabular.RowImpl;

public abstract class AbstractHeader<T, C extends Column<? extends T>>
extends ArrayList<C>
implements HeaderTemplate<T, C>,
Cloneable {
    private static final long serialVersionUID = 1L;
    Set<String> _keys = new LinkedHashSet<String>();

    public AbstractHeader() {
    }

    @SafeVarargs
    public AbstractHeader(C ... aHeader) {
        int theIndex = 0;
        for (C eColumn : aHeader) {
            if (this.containsKey(eColumn.getKey())) {
                throw new IllegalArgumentException("A column with key \"" + (String)eColumn.getKey() + "\" at index <" + theIndex + "> already exists, cannot add a column with the same key twice.");
            }
            this.add(eColumn);
            ++theIndex;
        }
    }

    @Override
    public boolean containsKey(Object aKey) {
        for (Column eColumn : this) {
            if (!((String)eColumn.getKey()).equals(aKey)) continue;
            return true;
        }
        return false;
    }

    @Override
    public C get(Object aKey) {
        for (Column eColumn : this) {
            if (!((String)eColumn.getKey()).equals(aKey)) continue;
            return (C)eColumn;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> keySet() {
        if (this.size() != this._keys.size()) {
            AbstractHeader abstractHeader = this;
            synchronized (abstractHeader) {
                if (this.size() != this._keys.size()) {
                    this._keys.clear();
                    for (Column eColumn : this) {
                        this._keys.add((String)eColumn.getKey());
                    }
                }
            }
        }
        return this._keys;
    }

    @Override
    public int indexOf(String aKey) {
        int theIndex = 0;
        for (Column eColumn : this) {
            if (((String)eColumn.getKey()).equals(aKey)) {
                return theIndex;
            }
            ++theIndex;
        }
        return -1;
    }

    @Override
    public C delete(String aKey) {
        int theIndex = this.indexOf(aKey);
        if (theIndex == -1) {
            throw new NoSuchElementException("No such element with key \"" + aKey + "\" found.");
        }
        Column theColumn = (Column)this.remove(theIndex);
        if (theColumn == null) {
            throw new NoSuchElementException("No such element with key \"" + aKey + "\" found any more (thread race condition).");
        }
        return (C)theColumn;
    }

    @Override
    public Record<String> toStorageString(Record<? extends T> aRecord) throws HeaderMismatchException, ColumnMismatchException {
        this.throwHeaderMismatchException(aRecord);
        RecordImpl<String> theStringRecord = new RecordImpl<String>();
        for (Column eColumn : this) {
            Object eValue = eColumn.get(aRecord);
            String eStorageString = null;
            if (eValue != null) {
                this.throwColumnMismatchException(eValue, eColumn);
                eStorageString = eColumn.toStorageString(eValue);
            }
            theStringRecord.put((String)eColumn.getKey(), eStorageString);
        }
        return theStringRecord;
    }

    @Override
    public Row<String> toStorageString(Row<? extends T> aRow) throws HeaderMismatchException, ColumnMismatchException {
        this.throwHeaderMismatchException(aRow);
        RowImpl<String> theStringRow = new RowImpl<String>(new String[0]);
        for (int i = 0; i < this.size(); ++i) {
            Column eColumn = (Column)this.get(i);
            Object eValue = aRow.get(i);
            String eStorageString = null;
            if (eValue != null) {
                this.throwColumnMismatchException(eValue, eColumn);
                eStorageString = eColumn.toStorageString(eValue);
            }
            theStringRow.add(eStorageString);
        }
        return theStringRow;
    }

    @Override
    public Record<T> fromStorageString(Record<String> aStringRecord) throws HeaderMismatchException, ParseException {
        this.throwHeaderMismatchException(aStringRecord);
        RecordImpl theRecord = new RecordImpl();
        for (Column eColumn : this) {
            String eStorageString = (String)aStringRecord.get(eColumn.getKey());
            Object eValue = null;
            if (eStorageString != null) {
                eValue = eColumn.fromStorageString(eStorageString);
            }
            theRecord.put(eColumn.getKey(), eValue);
        }
        return theRecord;
    }

    @Override
    public Row<T> fromStorageString(Row<String> aStringRow) throws HeaderMismatchException, ParseException {
        this.throwHeaderMismatchException(aStringRow);
        RowImpl<Object> theRow = new RowImpl<Object>(new Object[0]);
        for (int i = 0; i < this.size(); ++i) {
            Column eColumn = (Column)this.get(i);
            String eStorageString = (String)aStringRow.get(i);
            Object eValue = null;
            if (eStorageString != null) {
                eValue = eColumn.fromStorageString(eStorageString);
            }
            theRow.add(eValue);
        }
        return theRow;
    }

    @Override
    public Record<String[]> toStorageStrings(Record<? extends T> aRecord) throws HeaderMismatchException, ColumnMismatchException {
        this.throwHeaderMismatchException(aRecord);
        RecordImpl<String[]> theStringsRecord = new RecordImpl<String[]>();
        for (Column eColumn : this) {
            Object eValue = eColumn.get(aRecord);
            String[] eStorageStrings = null;
            if (eValue != null) {
                this.throwColumnMismatchException(eValue, eColumn);
                eStorageStrings = eColumn.toStorageStrings(eValue);
            }
            theStringsRecord.put((String)eColumn.getKey(), eStorageStrings);
        }
        return theStringsRecord;
    }

    @Override
    public Row<String[]> toStorageStrings(Row<? extends T> aRow) throws HeaderMismatchException, ColumnMismatchException {
        this.throwHeaderMismatchException(aRow);
        RowImpl<String[]> theStringsRow = new RowImpl<String[]>((T[])new String[0][]);
        for (int i = 0; i < this.size(); ++i) {
            Column eColumn = (Column)this.get(i);
            Object eValue = aRow.get(i);
            String[] eStorageStrings = null;
            if (eValue != null) {
                this.throwColumnMismatchException(eValue, eColumn);
                eStorageStrings = eColumn.toStorageStrings(eValue);
            }
            theStringsRow.add(eStorageStrings);
        }
        return theStringsRow;
    }

    @Override
    public Row<T> fromStorageStrings(Row<String[]> aStringsRow) throws HeaderMismatchException, ParseException {
        this.throwHeaderMismatchException(aStringsRow);
        RowImpl<Object> theRow = new RowImpl<Object>(new Object[0]);
        for (int i = 0; i < this.size(); ++i) {
            Column eColumn = (Column)this.get(i);
            String[] eStorageStrings = (String[])aStringsRow.get(i);
            Object eValue = null;
            if (eStorageStrings != null) {
                eValue = eColumn.fromStorageStrings(eStorageStrings);
            }
            theRow.add(eValue);
        }
        return theRow;
    }

    @Override
    public Record<T> fromStorageStrings(Record<String[]> aStringsRecord) throws HeaderMismatchException, ParseException {
        this.throwHeaderMismatchException(aStringsRecord);
        RecordImpl theRecord = new RecordImpl();
        for (Column eColumn : this) {
            String[] eStorageStrings = (String[])aStringsRecord.get(eColumn.getKey());
            Object eValue = null;
            if (eStorageStrings != null) {
                eValue = eColumn.fromStorageStrings(eStorageStrings);
            }
            theRecord.put(eColumn.getKey(), eValue);
        }
        return theRecord;
    }

    @Override
    public Record<String> toPrintable(Record<? extends T> aRecord) throws HeaderMismatchException, ColumnMismatchException {
        this.throwHeaderMismatchException(aRecord);
        RecordImpl<String> theRecord = new RecordImpl<String>();
        for (Column eColumn : this) {
            Object eValue = eColumn.get(aRecord);
            String ePrintableString = null;
            if (eValue != null) {
                this.throwColumnMismatchException(eValue, eColumn);
                ePrintableString = eColumn.toPrintable(eValue);
            }
            theRecord.put((String)eColumn.getKey(), ePrintableString);
        }
        return theRecord;
    }

    @Override
    public Row<String> toPrintable(Row<? extends T> aRow) throws HeaderMismatchException, ColumnMismatchException {
        this.throwHeaderMismatchException(aRow);
        RowImpl<String> theRow = new RowImpl<String>(new String[0]);
        for (int i = 0; i < this.size(); ++i) {
            Column eColumn = (Column)this.get(i);
            Object eValue = aRow.get(i);
            String ePrintableString = null;
            if (eValue != null) {
                this.throwColumnMismatchException(eValue, eColumn);
                ePrintableString = eColumn.toPrintable(eValue);
            }
            theRow.add(ePrintableString);
        }
        return theRow;
    }

    @Override
    public Row<T> toRow(Record<? extends T> aRecord) throws HeaderMismatchException, ColumnMismatchException {
        return this.toRow(aRecord, false);
    }

    @Override
    public Row<?> toRowIgnoreType(Record<?> aRecord) throws HeaderMismatchException {
        try {
            return this.toRow(aRecord, true);
        }
        catch (ColumnMismatchException aException) {
            throw new HiddenException("This exception must not happen; this method's implementnation <" + this.getClass().getName() + "> is errornous, please check the code.", aException);
        }
    }

    @Override
    public Record<T> toRecord(Row<? extends T> aRow) throws HeaderMismatchException, ColumnMismatchException {
        return this.toRecord(aRow, false);
    }

    @Override
    public Record<?> toRecordIgnoreType(Row<?> aRow) throws HeaderMismatchException {
        try {
            return this.toRecord(aRow, true);
        }
        catch (ColumnMismatchException aException) {
            throw new HiddenException("This exception must not happen; this method's implementnation <" + this.getClass().getName() + "> is errornous, please check the code.", aException);
        }
    }

    @Override
    public Row<T> fromStorageStringRecord(Record<String> aStringRecord) throws HeaderMismatchException, ParseException {
        try {
            return this.toRow(this.fromStorageString(aStringRecord));
        }
        catch (ColumnMismatchException aException) {
            throw new HiddenException("This exception must not happen; this method's implementnation <" + this.getClass().getName() + "> is errornous, please check the code.", aException);
        }
    }

    @Override
    public Record<String> toStorageStringRecord(Row<? extends T> aRow) throws HeaderMismatchException, ColumnMismatchException {
        return this.toRecordIgnoreType(this.toStorageString(aRow));
    }

    @Override
    public Record<T> fromStorageStringRow(Row<String> aStringRow) throws HeaderMismatchException, ParseException {
        try {
            return this.toRecord(this.fromStorageString(aStringRow));
        }
        catch (ColumnMismatchException aException) {
            throw new HiddenException("This exception must not happen; this method's implementnation <" + this.getClass().getName() + "> is errornous, please check the code.", aException);
        }
    }

    @Override
    public Row<String> toStorageStringRow(Record<? extends T> aRecord) throws HeaderMismatchException, ColumnMismatchException {
        return this.toRowIgnoreType(this.toStorageString(aRecord));
    }

    @Override
    public Row<T> fromStorageStringsRecord(Record<String[]> aStringsRecord) throws HeaderMismatchException, ParseException {
        try {
            return this.toRow(this.fromStorageStrings(aStringsRecord));
        }
        catch (ColumnMismatchException aException) {
            throw new HiddenException("This exception must not happen; this method's implementnation <" + this.getClass().getName() + "> is errornous, please check the code.", aException);
        }
    }

    @Override
    public Record<String[]> toStorageStringsRecord(Row<? extends T> aRow) throws HeaderMismatchException, ColumnMismatchException {
        return this.toRecordIgnoreType(this.toStorageStrings(aRow));
    }

    @Override
    public Record<T> fromStorageStringsRow(Row<String[]> aStringsRow) throws HeaderMismatchException, ParseException {
        try {
            return this.toRecord(this.fromStorageStrings(aStringsRow));
        }
        catch (ColumnMismatchException aException) {
            throw new HiddenException("This exception must not happen; this method's implementnation <" + this.getClass().getName() + "> is errornous, please check the code.", aException);
        }
    }

    @Override
    public Row<String[]> toStorageStringsRow(Record<? extends T> aRecord) throws HeaderMismatchException, ColumnMismatchException {
        return this.toRowIgnoreType(this.toStorageStrings(aRecord));
    }

    @Override
    public Row<String> toPrintableRow(Record<? extends T> aRecord) throws HeaderMismatchException, ColumnMismatchException {
        return this.toRowIgnoreType(this.toPrintable(aRecord));
    }

    @Override
    public Record<String> toPrintableRecord(Row<? extends T> aRow) throws HeaderMismatchException, ColumnMismatchException {
        return this.toRecordIgnoreType(this.toPrintable(aRow));
    }

    @Override
    public synchronized boolean add(C aColumn) {
        if (this.containsKey(aColumn.getKey())) {
            throw new IllegalArgumentException("A column with key \"" + (String)aColumn.getKey() + "\" already exists, cannot add a column with the same key twice.");
        }
        this._keys.clear();
        return super.add(aColumn);
    }

    @Override
    public synchronized void add(int aIndex, C aColumn) {
        if (this.containsKey(aColumn.getKey())) {
            throw new IllegalArgumentException("A column with key \"" + (String)aColumn.getKey() + "\" already exists, cannot add a column with the same key twice.");
        }
        this._keys.clear();
        super.add(aIndex, aColumn);
    }

    @Override
    public Collection<C> values() {
        return this;
    }

    private Record<?> toRecord(Row<?> aRow, boolean isIgnoreType) throws HeaderMismatchException, ColumnMismatchException {
        this.throwHeaderMismatchException(aRow);
        RecordImpl theRecord = new RecordImpl();
        for (int i = 0; i < this.size(); ++i) {
            Column eColumn = (Column)this.get(i);
            Object eValue = aRow.get(i);
            if (!isIgnoreType && eValue != null) {
                this.throwColumnMismatchException(eValue, eColumn);
            }
            theRecord.put(eColumn.getKey(), eValue);
        }
        return theRecord;
    }

    private Row<?> toRow(Record<?> aRecord, boolean isIgnoreType) throws HeaderMismatchException, ColumnMismatchException {
        this.throwHeaderMismatchException(aRecord);
        RowImpl<Object> theRow = new RowImpl<Object>(new Object[0]);
        for (Column eColumn : this) {
            Object eValue;
            if (eColumn.contains(aRecord)) {
                eValue = eColumn.get(aRecord);
                theRow.add(eValue);
                continue;
            }
            if (aRecord.containsKey(eColumn.getKey())) {
                eValue = aRecord.get(eColumn.getKey());
                if (!isIgnoreType) {
                    this.throwColumnMismatchException(eValue, eColumn);
                    continue;
                }
                theRow.add(eValue);
                continue;
            }
            theRow.add(null);
        }
        return theRow;
    }

    private void throwHeaderMismatchException(Record<?> aRecord) throws HeaderMismatchException {
        for (String eKey : this.keySet()) {
            if (aRecord.containsKey(eKey)) continue;
            throw new HeaderMismatchException(eKey, "The key \"" + eKey + "\" provided by the header is not found in the given record.");
        }
    }

    private void throwHeaderMismatchException(Row<?> aRow) throws HeaderMismatchException {
        if (this.size() != aRow.size()) {
            String theKey = this.size() > aRow.size() ? (String)((Column)this.get(aRow.size())).getKey() : (String)((Column)this.get(0)).getKey();
            throw new HeaderMismatchException(theKey, "The row size <" + aRow.size() + "> does not match the header size <" + this.size() + ">; unable to assign key \"" + theKey + "\" with value from row.");
        }
    }

    private void throwColumnMismatchException(Object aValue, Column<?> eColumn) throws ColumnMismatchException {
        if (!eColumn.getType().isAssignableFrom(aValue.getClass())) {
            throw new ColumnMismatchException(eColumn, aValue, "The type <" + eColumn.getType().getName() + "> for column with key \"" + (String)eColumn.getKey() + "\" does not match the value's type <" + aValue.getClass().getName() + ">.");
        }
    }
}

