/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.textual;

import org.refcodes.runtime.SystemUtility;
import org.refcodes.textual.AbstractText;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.HorizAlignTextMode;

public class HorizAlignTextBuilderImpl
extends AbstractText<HorizAlignTextBuilder>
implements HorizAlignTextBuilder {
    private int _columnWidth = SystemUtility.toConsoleWidth();
    private HorizAlignTextMode _alignTextMode = HorizAlignTextMode.LEFT;
    private char _fillChar = (char)32;

    @Override
    public HorizAlignTextBuilder withColumnWidth(int aColumnWidth) {
        this.setColumnWidth(aColumnWidth);
        return this;
    }

    @Override
    public void setColumnWidth(int aColumnWidth) {
        this._columnWidth = aColumnWidth;
    }

    @Override
    public int getColumnWidth() {
        return this._columnWidth;
    }

    @Override
    public void setHorizAlignTextMode(HorizAlignTextMode aHorizAlignTextMode) {
        this._alignTextMode = aHorizAlignTextMode;
    }

    @Override
    public HorizAlignTextMode getHorizAlignTextMode() {
        return this._alignTextMode;
    }

    @Override
    public char getFillChar() {
        return this._fillChar;
    }

    @Override
    public void setFillChar(char aFillChar) {
        this._fillChar = aFillChar;
    }

    @Override
    public String[] toStrings() {
        return HorizAlignTextBuilderImpl.toAlign(this.getText(), this._columnWidth, this._fillChar, this._alignTextMode);
    }

    @Override
    public String[] toStrings(String ... aText) {
        return HorizAlignTextBuilderImpl.toAlign(aText, this._columnWidth, this._fillChar, this._alignTextMode);
    }

    protected static String toAlign(String aText, int aLength, char aFillChar, HorizAlignTextMode aHorizAlignTextMode) {
        if (aHorizAlignTextMode == null) {
            return aText;
        }
        switch (aHorizAlignTextMode) {
            case BLOCK: {
                return HorizAlignTextBuilderImpl.toAlignBlock(aText, aLength, aFillChar);
            }
            case CENTER: {
                return HorizAlignTextBuilderImpl.toAlignCenter(aText, aLength, aFillChar);
            }
            case LEFT: {
                return HorizAlignTextBuilderImpl.toAlignLeft(aText, aLength, aFillChar);
            }
            case RIGHT: {
                return HorizAlignTextBuilderImpl.toAlignRight(aText, aLength, aFillChar);
            }
        }
        throw new IllegalArgumentException("You must provide a supported value for the horizontal align mode, though you provided <" + (Object)((Object)aHorizAlignTextMode) + ">. The code seems to be out of date, please participate in getting the code even better. See <http://www.refcodes.org> and <https://birbucket.org/refcodes>.");
    }

    protected static String toAlignLeft(String aText, int aLength, char aFillChar) {
        if (aText.length() == aLength) {
            return aText;
        }
        if (aText.length() > aLength) {
            return aText.substring(0, aLength);
        }
        StringBuffer theBuffer = new StringBuffer();
        theBuffer.append(aText);
        for (int i = 0; i < aLength - aText.length(); ++i) {
            theBuffer.append(aFillChar);
        }
        return theBuffer.toString();
    }

    protected static String toAlignRight(String aText, int aLength, char aFillChar) {
        if (aText.length() == aLength) {
            return aText;
        }
        if (aText.length() > aLength) {
            return aText.substring(aText.length() - aLength);
        }
        StringBuffer theBuffer = new StringBuffer();
        for (int i = 0; i < aLength - aText.length(); ++i) {
            theBuffer.append(aFillChar);
        }
        theBuffer.append(aText);
        return theBuffer.toString();
    }

    protected static String toAlignCenter(String aText, int aLength, char aFillChar) {
        if (aText.length() == aLength) {
            return aText;
        }
        if (aText.length() > aLength) {
            int theExceed = aText.length() - aLength;
            int theLeft = theExceed / 2;
            int theRight = theExceed / 2;
            return aText.substring(theLeft, aText.length() - (theRight += theExceed % 2));
        }
        StringBuffer theBuffer = new StringBuffer();
        theBuffer.append(aText);
        while (theBuffer.length() < aLength) {
            theBuffer.append(aFillChar);
            if (theBuffer.length() >= aLength) continue;
            theBuffer.insert(0, aFillChar);
        }
        return theBuffer.toString();
    }

    protected static String toAlignBlock(String aText, int aLength, char aFillChar) {
        if (aText.length() == aLength) {
            return aText;
        }
        if (aText.length() > aLength) {
            int theExceed = aText.length() - aLength;
            int theLeft = theExceed / 2;
            int theRight = theExceed / 2;
            return aText.substring(theLeft, aText.length() - (theRight += theExceed % 2));
        }
        if (aText.indexOf(aFillChar) == -1) {
            return HorizAlignTextBuilderImpl.toAlignLeft(aText, aLength, aFillChar);
        }
        StringBuffer theBuffer = new StringBuffer();
        theBuffer.append(aText);
        String theChar = new String(new char[]{aFillChar});
        int eOffset = -1;
        while (theBuffer.length() < aLength) {
            if ((eOffset = theBuffer.indexOf(theChar, eOffset + 1)) == -1) {
                eOffset = 0;
                continue;
            }
            theBuffer.insert(eOffset, theChar);
            if (++eOffset <= aLength) continue;
            eOffset = 0;
        }
        return theBuffer.toString();
    }

    protected static String[] toAlign(String[] aText, int aLength, char aFillChar, HorizAlignTextMode aHorizAlignTextMode) {
        String[] theResult = new String[aText.length];
        for (int i = 0; i < aText.length; ++i) {
            theResult[i] = HorizAlignTextBuilderImpl.toAlign(aText[i], aLength, aFillChar, aHorizAlignTextMode);
        }
        return theResult;
    }
}

