/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard;

import org.refcodes.checkerboard.AbstractCheckerboardViewer;
import org.refcodes.checkerboard.ChangePositionEvent;
import org.refcodes.checkerboard.Checkerboard;
import org.refcodes.checkerboard.CheckerboardEvent;
import org.refcodes.checkerboard.ConsoleCheckerboardViewer;
import org.refcodes.checkerboard.ConsoleSpriteFactory;
import org.refcodes.checkerboard.DraggabilityChangedEvent;
import org.refcodes.checkerboard.GridDimensionChangedEvent;
import org.refcodes.checkerboard.GridModeChangedEvent;
import org.refcodes.checkerboard.Player;
import org.refcodes.checkerboard.PlayerAddedEvent;
import org.refcodes.checkerboard.PlayerEvent;
import org.refcodes.checkerboard.PlayerRemovedEvent;
import org.refcodes.checkerboard.PositionChangedEvent;
import org.refcodes.checkerboard.StateChangedEvent;
import org.refcodes.checkerboard.ViewportDimensionChangedEvent;
import org.refcodes.checkerboard.ViewportOffsetChangedEvent;
import org.refcodes.checkerboard.VisibilityChangedEvent;
import org.refcodes.component.InitializeException;
import org.refcodes.exception.VetoException;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.TableBuilder;
import org.refcodes.textual.TableBuilderImpl;

public class ConsoleCheckerboardViewerImpl<P extends Player<P, S>, S>
extends AbstractCheckerboardViewer<P, S, String, ConsoleSpriteFactory<S>, ConsoleCheckerboardViewer<P, S>>
implements ConsoleCheckerboardViewer<P, S> {
    private static final int DEFAULT_REFRESH_LOOP_TIME_IN_MILLIS = 100;
    private static final int DEFAULT_COLUMN_WIDTH = 3;
    private ConsoleSpriteFactory<S> _spriteFactory;
    private int _redrawLoopTimeInMillis;
    private int _oldState = -1;
    private int _columnWidth;

    public ConsoleCheckerboardViewerImpl(Checkerboard<P, S> aCheckerboard, ConsoleSpriteFactory<S> aSpriteFactory) {
        this(aCheckerboard, aSpriteFactory, 100);
    }

    public ConsoleCheckerboardViewerImpl(Checkerboard<P, S> aCheckerboard, ConsoleSpriteFactory<S> aSpriteFactory, int aRedrawLoopTimeInMillis) {
        this(aCheckerboard, aSpriteFactory, 3, aRedrawLoopTimeInMillis);
    }

    public ConsoleCheckerboardViewerImpl(Checkerboard<P, S> aCheckerboard, ConsoleSpriteFactory<S> aSpriteFactory, int aColumnWidth, int aRedrawLoopTimeInMillis) {
        super(aCheckerboard);
        aCheckerboard.subscribeObserver(this);
        this._spriteFactory = aSpriteFactory;
        this._redrawLoopTimeInMillis = aRedrawLoopTimeInMillis;
        this._columnWidth = aColumnWidth;
    }

    public void initialize() throws InitializeException {
        if (this._redrawLoopTimeInMillis > 0) {
            Thread t = new Thread(this::printPlaygroundDaemon);
            t.setDaemon(true);
            t.start();
        }
    }

    @Override
    public synchronized void onCheckerboardEvent(CheckerboardEvent<P, S> aCheckerboardEvent) {
        this.onEventPrintPlayground();
    }

    @Override
    public void onPlayerAddedEvent(PlayerAddedEvent<P, S> aCheckerboardEvent) {
    }

    @Override
    public void onPlayerRemovedEvent(PlayerRemovedEvent<P, S> aCheckerboardEvent) {
    }

    @Override
    public void onGridModeChangedEvent(GridModeChangedEvent<P, S> aCheckerboardEvent) {
    }

    @Override
    public void onGridDimensionChangedEvent(GridDimensionChangedEvent<P, S> aCheckerboardEvent) {
    }

    @Override
    public void onViewportOffsetChangedEvent(ViewportOffsetChangedEvent<P, S> aCheckerboardEvent) {
    }

    @Override
    public void onViewportDimensionChangedEvent(ViewportDimensionChangedEvent<P, S> aCheckerboardEvent) {
    }

    @Override
    public synchronized void onPlayerEvent(PlayerEvent<P> aPlayerEvent, Checkerboard<P, S> aSource) {
        this.onEventPrintPlayground();
    }

    @Override
    public void onChangePositionEvent(ChangePositionEvent<P> aPlayerEvent, Checkerboard<P, S> aSource) throws VetoException {
    }

    @Override
    public void onPositionChangedEvent(PositionChangedEvent<P> aPlayerEvent, Checkerboard<P, S> aSource) {
    }

    @Override
    public synchronized void onStateChangedEvent(StateChangedEvent<P, S> aPlayerEvent, Checkerboard<P, S> aSource) {
        this.onEventPrintPlayground();
    }

    @Override
    public void onVisibilityChangedEvent(VisibilityChangedEvent<P> aPlayerEvent, Checkerboard<P, S> aSource) {
    }

    @Override
    public void onDraggabilityChangedEvent(DraggabilityChangedEvent<P> aPlayerEvent, Checkerboard<P, S> aSource) {
    }

    @Override
    public int getRedrawLoopTimeInMillis() {
        return this._redrawLoopTimeInMillis;
    }

    @Override
    public boolean isRedrawOnEvent() {
        return this._redrawLoopTimeInMillis <= 0;
    }

    protected void printPlaygroundDaemon() {
        while (true) {
            this.printPlayground();
            try {
                Thread.sleep(this._redrawLoopTimeInMillis);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    protected void onEventPrintPlayground() {
        if (this._redrawLoopTimeInMillis <= 0) {
            this.printPlayground();
        }
    }

    private synchronized void printPlayground() {
        if (this._oldState != this.toState(this.getCheckerboard())) {
            int the1stWidth = (this.getCheckerboard().getGridHeight() + "").length() + 2;
            TableBuilder theBuilder = new TableBuilderImpl().withRowWidth(-1);
            theBuilder.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.CENTER).withColumnWidth(the1stWidth);
            for (int x = 0; x < this.getGridWidth(); ++x) {
                theBuilder.addColumn().withColumnHorizAlignTextMode(HorizAlignTextMode.CENTER).withColumnWidth(this._columnWidth);
            }
            String[] theRows = new String[this.getGridWidth() + 1];
            theRows[0] = "";
            for (int x = 0; x < this.getGridWidth(); ++x) {
                theRows[x + 1] = "" + x;
            }
            theBuilder.printHeader(theRows);
            String[] theColumns = new String[this.getGridWidth() + 1];
            for (int y = 0; y < this.getGridHeight(); ++y) {
                theColumns[0] = "" + new Character((char)(97 + y));
                for (int x = 0; x < this.getGridWidth(); ++x) {
                    Object ePlayer = this.getCheckerboard().atPosition(x, y);
                    theColumns[x + 1] = ePlayer != null ? (String)this._spriteFactory.createInstance(ePlayer.getStatus(), this) : "";
                }
                theBuilder.printRow(theColumns);
            }
            theBuilder.printTail();
            System.out.println();
            this._oldState = this.toState(this.getCheckerboard());
        }
    }

    private int toState(Checkerboard<P, S> aCheckerboard) {
        StringBuilder theBuilder = new StringBuilder();
        for (Player ePlayer : this.getCheckerboard().getPlayers()) {
            theBuilder.append(ePlayer.getPositionX());
            theBuilder.append(ePlayer.getPositionY());
            theBuilder.append(ePlayer.getStatus());
            if (ePlayer.getStatus() == null) continue;
            theBuilder.append(ePlayer.getStatus().hashCode());
        }
        return theBuilder.toString().hashCode();
    }

    public int getColumnWidth() {
        return this._columnWidth;
    }

    public void setColumnWidth(int aColumnWidth) {
        this._columnWidth = aColumnWidth;
    }
}

