/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.checkerboard;

import org.refcodes.checkerboard.Neighbourhood;
import org.refcodes.exception.BugException;

public enum VonNeumannNeighbourhood implements Neighbourhood<VonNeumannNeighbourhood>
{
    LEFT(-1, 0),
    TOP(0, -1),
    RIGHT(1, 0),
    BOTTOM(0, 1);

    private int _posX;
    private int _posY;

    private VonNeumannNeighbourhood(int aPosX, int aPosY) {
        this._posX = aPosX;
        this._posY = aPosY;
    }

    public int getPositionX() {
        return this._posX;
    }

    public int getPositionY() {
        return this._posY;
    }

    @Override
    public VonNeumannNeighbourhood clockwiseNext() {
        switch (this) {
            case TOP: {
                return RIGHT;
            }
            case RIGHT: {
                return BOTTOM;
            }
            case BOTTOM: {
                return LEFT;
            }
            case LEFT: {
                return TOP;
            }
        }
        throw new BugException("Missing case statement for <" + this + "> in implementation!");
    }

    @Override
    public VonNeumannNeighbourhood clockwisePrevious() {
        switch (this) {
            case TOP: {
                return LEFT;
            }
            case LEFT: {
                return BOTTOM;
            }
            case BOTTOM: {
                return RIGHT;
            }
            case RIGHT: {
                return TOP;
            }
        }
        throw new BugException("Missing case statement for <" + this + "> in implementation!");
    }
}

