// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.collection;

/**
 * A {@link Containable} is the base functionality provided container
 * (collection). The {@link Containable}it just informs about the metrics
 * of a container.
 */
public interface Containable {

	/**
	 * Returns the number of data elements contained in the collection.
	 * 
	 * @return An integer representing the number of items stored in the
	 *         accumulation.
	 */
	int size();

	/**
	 * Tests whether the accumulation is empty or not. Returns true if the
	 * accumulation is empty, else false is returned.
	 * 
	 * @return True if no element is contained in the accumulation - else false
	 *         is returned.
	 */
	boolean isEmpty();
}
