// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other close source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.component;

import org.refcodes.component.Initializable.InitializeAutomaton;

/**
 * This mixin might be implemented by a component in order to provide closing
 * connection(s) facilities.
 */
public interface Closable {

	/**
	 * Closes the component's connection(s). Throws a {@link CloseException} as
	 * upon close we may have to do things like flushing buffers which can fail
	 * (and would otherwise fail unhandled or even worse unnoticed).
	 * 
	 * @throws CloseException in case closing or pre-closing (flushing) fails.
	 */
	void close() throws CloseException;

	/**
	 * The {@link CloseAutomaton} interface defines those methods related to the
	 * closing of connection(s) life-cycle. The semantics of this interface is
	 * very similar to that of the {@link InitializeAutomaton} interface. To
	 * clarify the context regarding connections, the {@link CloseAutomaton}
	 * interface has been introduced.
	 */
	public interface CloseAutomaton extends Closable, ClosedAccessor {

		/**
		 * Determines whether the component's connection(s) may get closed.
		 * 
		 * @return True if {@link #close()} is possible.
		 */
		boolean isClosable();
	}
}
