// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.component;

import org.refcodes.exception.AbstractException;

/**
 * This exception is the base exception for the component package.
 */
public abstract class ComponentException extends AbstractException {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public ComponentException( String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
	}

	public ComponentException( String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
	}

	public ComponentException( String message, Throwable cause ) {
		super( message, cause );
	}

	public ComponentException( String message ) {
		super( message );
	}

	public ComponentException( Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
	}

	public ComponentException( Throwable cause ) {
		super( cause );
	}

	/**
	 * This exception is the base exception for connection related exceptions.
	 */
	@SuppressWarnings("rawtypes")
	static abstract class ComponentConnectionException extends ComponentException implements ConnectionAccessor {

		private static final long serialVersionUID = 1L;

		// /////////////////////////////////////////////////////////////////////////
		// VARIABLES:
		// /////////////////////////////////////////////////////////////////////////

		private Object _connection;

		// /////////////////////////////////////////////////////////////////////////
		// CONSTRUCTORS:
		// /////////////////////////////////////////////////////////////////////////


		public ComponentConnectionException( Object aConnection, String aMessage, String aErrorCode ) {
			super( aMessage, aErrorCode );
			_connection = aConnection;
		}


		public ComponentConnectionException( Object aConnection, String aMessage, Throwable aCause, String aErrorCode ) {
			super( aMessage, aCause, aErrorCode );
			_connection = aConnection;
		}


		public ComponentConnectionException( Object aConnection, String message, Throwable cause ) {
			super( message, cause );
			_connection = aConnection;
		}


		public ComponentConnectionException( Object aConnection, String message ) {
			super( message );
			_connection = aConnection;
		}


		public ComponentConnectionException( Object aConnection, Throwable aCause, String aErrorCode ) {
			super( aCause, aErrorCode );
			_connection = aConnection;
		}


		public ComponentConnectionException( Object aConnection, Throwable cause ) {
			super( cause );
			_connection = aConnection;
		}

		// /////////////////////////////////////////////////////////////////////////
		// METHODS:
		// /////////////////////////////////////////////////////////////////////////

		@Override
		public Object getConnection() {
			return _connection;
		}
	}

	/**
	 * This exception is the base exception for connection related exceptions.
	 */
	@SuppressWarnings("rawtypes")
	static abstract class ComponentIoConnectionException extends ComponentException implements BidirectionalConnectionAccessor {

		private static final long serialVersionUID = 1L;

		// /////////////////////////////////////////////////////////////////////////
		// VARIABLES:
		// /////////////////////////////////////////////////////////////////////////

		private Object _inputConnection;
		private Object _outputConnection;

		// /////////////////////////////////////////////////////////////////////////
		// CONSTRUCTORS:
		// /////////////////////////////////////////////////////////////////////////


		public ComponentIoConnectionException( Object aInputConnection, Object aOutputConnection, String aMessage, String aErrorCode ) {
			super( aMessage, aErrorCode );
			_inputConnection = aInputConnection;
			_outputConnection = aOutputConnection;
		}


		public ComponentIoConnectionException( Object aInputConnection, Object aOutputConnection, String aMessage, Throwable aCause, String aErrorCode ) {
			super( aMessage, aCause, aErrorCode );
			_inputConnection = aInputConnection;
			_outputConnection = aOutputConnection;
		}


		public ComponentIoConnectionException( Object aInputConnection, Object aOutputConnection, String message, Throwable cause ) {
			super( message, cause );
			_inputConnection = aInputConnection;
			_outputConnection = aOutputConnection;
		}


		public ComponentIoConnectionException( Object aInputConnection, Object aOutputConnection, String message ) {
			super( message );
			_inputConnection = aInputConnection;
			_outputConnection = aOutputConnection;
		}


		public ComponentIoConnectionException( Object aInputConnection, Object aOutputConnection, Throwable aCause, String aErrorCode ) {
			super( aCause, aErrorCode );
			_inputConnection = aInputConnection;
			_outputConnection = aOutputConnection;
		}


		public ComponentIoConnectionException( Object aInputConnection, Object aOutputConnection, Throwable cause ) {
			super( cause );
			_inputConnection = aInputConnection;
			_outputConnection = aOutputConnection;
		}

		// /////////////////////////////////////////////////////////////////////////
		// METHODS:
		// /////////////////////////////////////////////////////////////////////////

		@Override
		public Object getInputConnection() {
			return _inputConnection;
		}

		@Override
		public Object getOutputConnection() {
			return _outputConnection;
		}
	}

	/**
	 * This exception is the base exception for connection related exceptions.
	 */
	@SuppressWarnings("rawtypes")
	static abstract class ComponentContextException extends ComponentException implements ContextAccessor {

		private static final long serialVersionUID = 1L;

		// /////////////////////////////////////////////////////////////////////
		// VARIABLES:
		// /////////////////////////////////////////////////////////////////////

		private Object _context;

		// /////////////////////////////////////////////////////////////////////
		// CONSTRUCTORS:
		// /////////////////////////////////////////////////////////////////////


		public ComponentContextException( Object aContext, String aMessage, String aErrorCode ) {
			super( aMessage, aErrorCode );
			_context = aContext;
		}


		public ComponentContextException( Object aContext, String aMessage, Throwable aCause, String aErrorCode ) {
			super( aMessage, aCause, aErrorCode );
			_context = aContext;
		}


		public ComponentContextException( Object aContext, String message, Throwable cause ) {
			super( message, cause );
			_context = aContext;
		}


		public ComponentContextException( Object aContext, String message ) {
			super( message );
			_context = aContext;
		}


		public ComponentContextException( Object aContext, Throwable aCause, String aErrorCode ) {
			super( aCause, aErrorCode );
			_context = aContext;
		}


		public ComponentContextException( Object aContext, Throwable cause ) {
			super( cause );
			_context = aContext;
		}

		// /////////////////////////////////////////////////////////////////////
		// METHODS:
		// /////////////////////////////////////////////////////////////////////

		@Override
		public Object getContext() {
			return _context;
		}
	}

}
