// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.component;

import org.refcodes.exception.AbstractRuntimeException;

/**
 * This exception is the base runtime exception for the component package.
 */
abstract class ComponentRuntimeException extends AbstractRuntimeException {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public ComponentRuntimeException( String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
	}

	public ComponentRuntimeException( String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
	}

	public ComponentRuntimeException( String message, Throwable cause ) {
		super( message, cause );
	}

	public ComponentRuntimeException( String message ) {
		super( message );
	}

	public ComponentRuntimeException( Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
	}

	public ComponentRuntimeException( Throwable cause ) {
		super( cause );
	}

	/**
	 * This exception is the base exception for handle related runtime
	 * exceptions.
	 */
	@SuppressWarnings("rawtypes")
	static abstract class ComponentHandleRuntimeException extends ComponentRuntimeException implements HandleAccessor {

		private static final long serialVersionUID = 1L;

		// /////////////////////////////////////////////////////////////////////////
		// VARIABLES:
		// /////////////////////////////////////////////////////////////////////////

		private Object _handle;

		// /////////////////////////////////////////////////////////////////////////
		// CONSTRUCTORS:
		// /////////////////////////////////////////////////////////////////////////


		public ComponentHandleRuntimeException( Object aHandle, String aMessage, String aErrorCode ) {
			super( aMessage, aErrorCode );
			_handle = aHandle;
		}


		public ComponentHandleRuntimeException( Object aHandle, String aMessage, Throwable aCause, String aErrorCode ) {
			super( aMessage, aCause, aErrorCode );
			_handle = aHandle;
		}


		public ComponentHandleRuntimeException( Object aHandle, String message, Throwable cause ) {
			super( message, cause );
			_handle = aHandle;
		}


		public ComponentHandleRuntimeException( Object aHandle, String message ) {
			super( message );
			_handle = aHandle;
		}


		public ComponentHandleRuntimeException( Object aHandle, Throwable aCause, String aErrorCode ) {
			super( aCause, aErrorCode );
			_handle = aHandle;
		}


		public ComponentHandleRuntimeException( Object aHandle, Throwable cause ) {
			super( cause );
			_handle = aHandle;
		}

		// /////////////////////////////////////////////////////////////////////////
		// METHODS:
		// /////////////////////////////////////////////////////////////////////////

		@Override
		public Object getHandle() {
			return _handle;
		}
	}
}
