// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.component;

import org.refcodes.component.LifeCycleComponentHandle.LifeCycleAutomatonHandle;

/**
 * Similar to the {@link CompositeComponent}, the
 * {@link CompositeComponentHandle} provides all the defined handle based
 * functionality, implementing classes provide the means to invoke those methods
 * in case them are supported by the referenced components.
 *
 * @param <H> The type of the handles.
 *
 * @param <REF> The type of the objects to which the handles reference to.
 */
public interface CompositeComponentHandle<H, REF> extends HandleLookup<H, REF>, LifeCycleAutomatonHandle<H>, ProgressHandle<H>, ResetHandle<H>, FlushHandle<H> {}
