package org.refcodes.component;

import org.refcodes.component.LifeCycleComponentHandle.LifeCycleAutomatonHandle;

/**
 * The {@link ConfigurableLifeCycleComponentHandle} manages various
 * {@link LifeCycleStatus} states for {@link ConfigurableLifeCycleComponent}
 * instances each related to a handle. Operations manipulating on the
 * {@link LifeCycleStatus} are invoked by this
 * {@link ConfigurableLifeCycleComponentHandle} with a handle identifying the
 * according referenced {@link ConfigurableLifeCycleComponent}.
 * <p>
 * The {@link ConfigurableLifeCycleComponent} contains the business-logic where
 * as the {@link ConfigurableLifeCycleComponentHandle} provides the frame for
 * managing this business-logic. The {@link LifeCycleAutomatonHandle} takes care
 * of the correct life-cycle applied on a {@link ConfigurableLifeCycleComponent}
 * .
 *
 * @param <H> The type of the handles.
 *
 * @param <CTX> The context used to initialize the referenced instance.
 */
public interface ConfigurableLifeCycleComponentHandle<H, CTX> extends ConfigurableHandle<H, CTX>, StartableHandle<H>, PausableHandle<H>, ResumableHandle<H>, StoppableHandle<H>, DestroyableHandle<H> {

	/**
	 * The {@link ConfigurableLifeCycleAutomatonHandle} is an automaton managing
	 * various {@link LifeCycleStatus} states for {@link Component} instances
	 * each related to a handle. Operations manipulating on the
	 * {@link LifeCycleStatus} are invoked by this
	 * {@link ConfigurableLifeCycleAutomatonHandle} with a handle identifying
	 * the according referenced {@link Component}.
	 * 
	 * The {@link LifeCycleComponent} contains the business-logic where as the
	 * {@link ConfigurableLifeCycleAutomatonHandle} provides the frame for
	 * managing this business-logic. The
	 * {@link ConfigurableLifeCycleAutomatonHandle} takes care of the correct
	 * life-cycle applied on a {@link LifeCycleComponent}.
	 * 
	 * @param <H> The type of the handle.
	 * 
	 * @param <CTX> the context used to initialize the referenced instance.
	 */
	public interface ConfigurableLifeCycleAutomatonHandle<H, CTX> extends ConfigurableLifeCycleComponentHandle<H, CTX>, ConfigureAutomatonHandle<H, CTX>, StartAutomatonHandle<H>, PauseAutomatonHandle<H>, ResumeAutomatonHandle<H>, StopAutomatonHandle<H>, DestroyAutomatonHandle<H>, LifeCycleComponentHandle<H>, LifeCycleStatusHandle<H> {}

}
