// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.component;

/**
 * Thrown in case initializing a component caused problems. Usually a method
 * similar to ""initialize(...)" throws such an exception.
 */
@SuppressWarnings("rawtypes")
public class ConfigureException extends InitializeException implements ContextAccessor {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private Object _context;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	public ConfigureException( Object aContext, String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
		_context = aContext;
	}

	public ConfigureException( Object aContext, String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
		_context = aContext;
	}

	public ConfigureException( Object aContext, String message, Throwable cause ) {
		super( message, cause );
		_context = aContext;
	}

	public ConfigureException( Object aContext, String message ) {
		super( message );
		_context = aContext;
	}

	public ConfigureException( Object aContext, Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
		_context = aContext;
	}

	public ConfigureException( Object aContext, Throwable cause ) {
		super( cause );
		_context = aContext;
	}

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Object getContext() {
		return _context;
	}
}
