// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.component;

/**
 * Provides an accessor for a {@link ConnectionStatus} property.
 */
public interface ConnectionStatusAccessor {

	/**
	 * Retrieves the {@link ConnectionStatus} property from the property.
	 * Determines in which {@link ConnectionStatus} status a component is in.
	 * 
	 * @return Returns the {@link ConnectionStatus} property stored by the
	 *         property.
	 */
	ConnectionStatus getConnectionStatus();

	/**
	 * Provides a mutator for a {@link ConnectionStatus} property.
	 */
	public interface ConnectionStatusMutator {

		/**
		 * Sets the {@link ConnectionStatus} property for the property.
		 * 
		 * @param aConnectionStatus The {@link ConnectionStatus} property to be
		 *        stored by the property.
		 */
		void setConnectionStatus( ConnectionStatus aConnectionStatus );
	}

	/**
	 * Provides a {@link ConnectionStatus} property.
	 */
	public interface ConnectionStatusProperty extends ConnectionStatusAccessor, ConnectionStatusMutator {}
}
