// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.component;

/**
 * Provides access to the initialized handle reference.
 * <p>
 * The handle reference requires the {@link InitializedAccessor} interface to be
 * implemented.
 *
 * @param <H> The type of the handle.
 */
public interface InitializedHandle<H> {

	/**
	 * Determines whether the component identified by the given handle is
	 * opened.
	 * 
	 * @param aHandle The handle identifying the component.
	 * 
	 * @return True in case of being opened, else false.
	 * 
	 * @throws UnsupportedHandleOperationRuntimeException in case the reference
	 *         of the handle does not support the requested operation.
	 * 
	 * @throws UnknownHandleRuntimeException in case the given handle is
	 *         unknown.
	 */
	boolean isInitzialized( H aHandle ) throws UnknownHandleRuntimeException, UnsupportedHandleOperationRuntimeException;
}
