package org.refcodes.component;

/**
 * The {@link LifeCycleComponentHandle} manages various {@link LifeCycleStatus}
 * states for {@link LifeCycleComponent} instances each related to a handle.
 * Operations manipulating on the {@link LifeCycleStatus} are invoked by this
 * {@link LifeCycleComponentHandle} with a handle identifying the according
 * referenced {@link LifeCycleComponent}.
 * <p>
 * The {@link LifeCycleComponent} contains the business-logic where as the
 * {@link LifeCycleComponentHandle} provides the frame for managing this
 * business-logic. The {@link LifeCycleAutomatonHandle} takes care of the
 * correct life-cycle applied on a {@link LifeCycleComponent}.
 *
 * @param <H> The type of the handles.
 */
public interface LifeCycleComponentHandle<H> extends InitializableHandle<H>, StartableHandle<H>, PausableHandle<H>, ResumableHandle<H>, StoppableHandle<H>, DestroyableHandle<H> {

	/**
	 * The {@link LifeCycleAutomatonHandle} is an automaton managing various
	 * {@link LifeCycleStatus} states for {@link Component} instances each
	 * related to a handle. Operations manipulating on the
	 * {@link LifeCycleStatus} are invoked by this
	 * {@link LifeCycleAutomatonHandle} with a handle identifying the according
	 * referenced {@link Component}.
	 * 
	 * The {@link LifeCycleComponent} contains the business-logic where as the
	 * {@link LifeCycleAutomatonHandle} provides the frame for managing this
	 * business-logic. The {@link LifeCycleAutomatonHandle} takes care of the
	 * correct life-cycle applied on a {@link LifeCycleComponent}.
	 * 
	 * @param <H> The type of the handle.
	 */
	public interface LifeCycleAutomatonHandle<H> extends LifeCycleComponentHandle<H>, InitializeAutomatonHandle<H>, StartAutomatonHandle<H>, PauseAutomatonHandle<H>, ResumeAutomatonHandle<H>, StopAutomatonHandle<H>, DestroyAutomatonHandle<H>, LifeCycleStatusHandle<H> {}
}
